/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.checkboxlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import oracle.ide.controls.checkboxlist.CheckBoxListCellData;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public class CheckBoxListModel
extends AbstractListModel
implements Copyable {
    private ArrayList _dataList;
    private Comparator _comparator;

    private void $init$() {
        this._dataList = new ArrayList();
        this._comparator = new 1();
    }

    public CheckBoxListModel() {
        this.$init$();
    }

    public CheckBoxListModel(Object[] userObjects) {
        this.$init$();
        int i = 0;
        while (i < userObjects.length) {
            this.addElement(userObjects[i], null, false, false);
            ++i;
        }
    }

    public CheckBoxListModel(Object[] userObjects, Icon icon, boolean hasCheckBox) {
        this(userObjects, icon, hasCheckBox, false);
    }

    public CheckBoxListModel(Object[] userObjects, Icon icon, boolean hasCheckBox, boolean checkBoxState) {
        this.$init$();
        int i = 0;
        while (i < userObjects.length) {
            this.addElement(userObjects[i], icon, hasCheckBox, checkBoxState);
            ++i;
        }
    }

    public CheckBoxListModel(Object[] userObjects, boolean hasCheckBox) {
        this(userObjects, null, hasCheckBox);
    }

    public CheckBoxListModel(Object[] userObjects, boolean hasCheckBox, boolean checkBoxState) {
        this(userObjects, null, hasCheckBox, checkBoxState);
    }

    public void addElement(Object userObject, Icon icon, String label, String toolTipText) {
        this.addElementAt(-1, userObject, icon, false, false, label, toolTipText);
    }

    public void addElementAt(int position, Object userObject, Icon icon, String label, String toolTipText) {
        this.addElementAt(position, userObject, icon, false, false, label, toolTipText);
    }

    public void addElement(Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState) {
        this.addElementAt(-1, userObject, icon, hasCheckBox, checkBoxState, userObject.toString());
    }

    public void addElementAt(int position, Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState) {
        this.addElementAt(position, userObject, icon, hasCheckBox, checkBoxState, userObject.toString());
    }

    public void addElement(Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState, String label) {
        this.addElementAt(-1, userObject, icon, hasCheckBox, checkBoxState, label, null);
    }

    public void addElementAt(int position, Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState, String label) {
        this.addElementAt(position, userObject, icon, hasCheckBox, checkBoxState, label, null);
    }

    public void addElement(Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState, String label, String toolTipText) {
        this.addElementAt(-1, userObject, icon, hasCheckBox, checkBoxState, label, toolTipText);
    }

    public void addElementAt(int position, Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState, String label, String toolTipText) {
        TriStateBoolean triStateBoolean = checkBoxState ? TriStateBoolean.TRUE : TriStateBoolean.FALSE;
        int addedPosition = 0;
        if (position == -1) {
            this._dataList.add(new CheckBoxListCellData(icon, label, hasCheckBox, triStateBoolean, userObject, toolTipText));
            addedPosition = this._dataList.size() - 1;
        } else {
            this._dataList.add(position, new CheckBoxListCellData(icon, label, hasCheckBox, triStateBoolean, userObject, toolTipText));
            addedPosition = position;
        }
        this.fireIntervalAdded(this, addedPosition, addedPosition);
    }

    public void addCheckBoxStateListener(CheckBoxListItemStateListener listener) {
        if (listener != null) {
            for (CheckBoxListCellData listCellData : this._dataList) {
                listCellData.setStateListener(listener);
            }
        }
    }

    public void selectAll() {
        for (CheckBoxListCellData listCellData : this._dataList) {
            listCellData.setCheckBoxState(true);
        }
        this.fireContentsChanged(this, 0, this._dataList.size() - 1);
    }

    public void deselectAll() {
        for (CheckBoxListCellData listCellData : this._dataList) {
            listCellData.setCheckBoxState(false);
        }
        this.fireContentsChanged(this, 0, this._dataList.size() - 1);
    }

    public List getSelectionList() {
        ArrayList<Object> selectedList = new ArrayList<Object>();
        for (CheckBoxListCellData listCellData : this._dataList) {
            TriStateBoolean triStateBoolean = listCellData.getCheckBoxState();
            if (!triStateBoolean.isTrue()) continue;
            selectedList.add(listCellData.getUserObject());
        }
        if (selectedList.size() > 0) {
            return selectedList;
        }
        return null;
    }

    public void findUserObjectAndMark(Object findObject, boolean selectObject) {
        for (CheckBoxListCellData listCellData : this._dataList) {
            if (!listCellData.getUserObject().equals(findObject)) continue;
            listCellData.setCheckBoxState(selectObject);
            return;
        }
    }

    public boolean isElementSelected(int index) {
        CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(index);
        TriStateBoolean triStateBoolean = listCellData.getCheckBoxState();
        return triStateBoolean.isTrue();
    }

    public void setElementSelected(int index) {
        CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(index);
        listCellData.setCheckBoxState(true);
    }

    public Object getUserObjectAt(int index) {
        CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(index);
        return listCellData.getUserObject();
    }

    public void setCheckBoxVisible(boolean checkboxVisible, boolean checkboxState) {
        int numElements = this._dataList.size();
        int i = 0;
        while (i < numElements) {
            CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(i);
            listCellData.setHasCheckBox(checkboxVisible);
            listCellData.setCheckBoxState(checkboxState);
            ++i;
        }
    }

    public void sort() {
        Collections.sort(this._dataList, this._comparator);
        this.fireContentsChanged(this, 0, this._dataList.size());
    }

    public void clear() {
        int numElements = this._dataList.size();
        if (numElements > 0) {
            this._dataList.clear();
            this.fireIntervalRemoved(this, 0, numElements - 1);
        }
    }

    public void removeElementByText(String value) {
        int position = this.findElementByText(value);
        if (position != -1) {
            this._dataList.remove(position);
            this.fireIntervalRemoved(this, position, position);
        }
    }

    public void removeElementByIndex(int index) {
        this._dataList.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public int findElementByText(String value) {
        int numElements = this._dataList.size();
        int i = 0;
        while (i < numElements) {
            CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(i);
            if (listCellData.getText().equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String findTextForElement(int index) {
        CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(index);
        return listCellData.getText();
    }

    public String getToolTipTextForElement(int index) {
        CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(index);
        return listCellData.getToolTipText();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((CheckBoxListModel)o);
    }

    protected final boolean equalsImpl(CheckBoxListModel other) {
        return other._dataList.equals(this._dataList);
    }

    public void putCheckBoxListCellDataAt(int index, CheckBoxListCellData data) {
        this._dataList.add(index, data);
    }

    public Object getElementAt(int index) {
        return this._dataList.get(index);
    }

    public int getSize() {
        return this._dataList.size();
    }

    public Object copyTo(Object target) {
        CheckBoxListModel copy = target != null ? (CheckBoxListModel)target : new CheckBoxListModel();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(CheckBoxListModel copy) {
        ModelUtil.deepCopy((List)this._dataList, (List)copy._dataList);
    }

    final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            CheckBoxListCellData lc1 = (CheckBoxListCellData)o1;
            CheckBoxListCellData lc2 = (CheckBoxListCellData)o2;
            return lc1.getText().compareTo(lc2.getText());
        }
    }
}

