/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.HashMap;
import java.util.Set;
import oracle.javatools.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMap<K, V> {
    private HashMap<Class<? extends K>, V> map;
    private static final Log LOG = new Log("typemap");

    private void $init$() {
        this.map = new HashMap();
    }

    public TypeMap() {
        this.$init$();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Class<? extends K> key) {
        return this.get(key) != null;
    }

    public V get(Class<? extends K> key) {
        LOG.trace("get {0}", key);
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        Class<K> type = key;
        do {
            Class match;
            if ((match = this.matchInterfaces(type.getInterfaces())) != null) {
                V value = this.map.get(match);
                this.map.put(key, value);
                return value;
            }
            if ((type = type.getSuperclass()) == null) {
                return null;
            }
            LOG.trace("test superclass {0}", type);
        } while (!this.map.containsKey(type));
        V value = this.map.get(type);
        this.map.put(key, value);
        return value;
    }

    public V put(Class<? extends K> key, V value) {
        return this.map.put(key, value);
    }

    public Set<Class<? extends K>> keySet() {
        return this.map.keySet();
    }

    private Class matchInterfaces(Class[] interfaces) {
        int i = 0;
        while (i < interfaces.length) {
            Class type = interfaces[i];
            LOG.trace("test interface {0}", type);
            if (this.map.containsKey(type)) {
                return type;
            }
            Class match = this.matchInterfaces(type.getInterfaces());
            if (match != null) {
                return match;
            }
            ++i;
        }
        return null;
    }
}

