/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class Log {
    public static final long TIME_ZERO_NANO = System.nanoTime();
    public static final long TIME_ZERO_MILLI = System.currentTimeMillis();
    private final boolean enabled;
    private final String name;
    private static final String NAME_WHITESPACE = "                  ";
    private static final String ERROR_NAME = "ERROR";
    private static final boolean any;
    private static boolean teeErrors;
    private static Set<String> names;
    private static int longestNameLength;
    private static Map<Class, Formatter> formatters;
    private static Logger logger;
    private static Formatter DEFAULT_FORMATTER;
    private static AtomicInteger lastTag;
    private static char[] tagBuffer;
    private static char[] timeBuffer;

    public static void error(String message) {
        Log.error(message, null);
    }

    public static void error(String message, Object p1) {
        Log.error(message, new Object[]{p1});
    }

    public static void error(String message, Object p1, Object p2) {
        Log.error(message, new Object[]{p1, p2});
    }

    public static void error(String message, Object p1, Object p2, Object p3) {
        Log.error(message, new Object[]{p1, p2, p3});
    }

    public static void error(String message, Object p1, Object p2, Object p3, Object p4) {
        Log.error(message, new Object[]{p1, p2, p3, p4});
    }

    public static void error(String message, Object p1, Object p2, Object p3, Object p4, Object p5) {
        Log.error(message, new Object[]{p1, p2, p3, p4, p5});
    }

    public static void error(String message, Object[] parameters) {
        Log.printerror(message, parameters);
    }

    public Log(String name) {
        if (any) {
            if (names.contains(name)) {
                this.enabled = true;
                this.name = name;
            } else {
                this.enabled = false;
                this.name = null;
            }
        } else {
            this.enabled = false;
            this.name = null;
        }
    }

    public Log(String name1, String name2) {
        if (any) {
            if (names.contains(name1)) {
                this.enabled = true;
                this.name = name1;
            } else if (names.contains(name2)) {
                this.enabled = true;
                this.name = name2;
            } else {
                this.enabled = false;
                this.name = null;
            }
        } else {
            this.enabled = false;
            this.name = null;
        }
    }

    public Log(String name1, String name2, String name3) {
        if (any) {
            if (names.contains(name1)) {
                this.enabled = true;
                this.name = name1;
            } else if (names.contains(name2)) {
                this.enabled = true;
                this.name = name2;
            } else if (names.contains(name3)) {
                this.enabled = true;
                this.name = name3;
            } else {
                this.enabled = false;
                this.name = null;
            }
        } else {
            this.enabled = false;
            this.name = null;
        }
    }

    public Log(String[] names) {
        if (any) {
            String name = null;
            int i = 0;
            while (i < names.length) {
                if (Log.names.contains(names[i])) {
                    name = names[i];
                    break;
                }
                ++i;
            }
            if (name != null) {
                this.enabled = true;
                this.name = name;
            } else {
                this.enabled = false;
                this.name = null;
            }
        } else {
            this.enabled = false;
            this.name = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean trace(String message) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, null);
        return true;
    }

    public boolean trace(String message, Object p1) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1});
        return true;
    }

    public boolean trace(String message, int p1) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1)});
        return true;
    }

    public boolean trace(String message, long p1) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Long(p1)});
        return true;
    }

    public boolean trace(String message, boolean p1) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1});
        return true;
    }

    public boolean trace(String message, Object p1, Object p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2});
        return true;
    }

    public boolean trace(String message, int p1, Object p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1), p2});
        return true;
    }

    public boolean trace(String message, int p1, int p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1), new Integer(p2)});
        return true;
    }

    public boolean trace(String message, long p1, Object p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Long(p1), p2});
        return true;
    }

    public boolean trace(String message, boolean p1, Object p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Boolean(p1), p2});
        return true;
    }

    public boolean trace(String message, boolean p1, boolean p2) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Boolean(p1), new Boolean(p2)});
        return true;
    }

    public boolean trace(String message, Object p1, Object p2, Object p3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3});
        return true;
    }

    public boolean trace(String message, int p1, Object p2, Object p3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1), p2, p3});
        return true;
    }

    public boolean trace(String message, int p1, int p2, Object p3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1), new Integer(p2), p3});
        return true;
    }

    public boolean trace(String message, int p1, int p2, int p3) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1), new Integer(p2), new Integer(p3)});
        return true;
    }

    public boolean trace(String message, Object p1, Object p2, Object p3, Object p4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3, p4});
        return true;
    }

    public boolean trace(String message, int p1, Object p2, Object p3, Object p4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1), p2, p3, p4});
        return true;
    }

    public boolean trace(String message, int p1, int p2, Object p3, Object p4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1), new Integer(p2), p3, p4});
        return true;
    }

    public boolean trace(String message, int p1, int p2, int p3, Object p4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1), new Integer(p2), new Integer(p3), p4});
        return true;
    }

    public boolean trace(String message, int p1, int p2, int p3, int p4) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1), new Integer(p2), new Integer(p3), new Integer(p4)});
        return true;
    }

    public boolean trace(String message, Object p1, Object p2, Object p3, Object p4, Object p5) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{p1, p2, p3, p4, p5});
        return true;
    }

    public boolean trace(String message, int p1, Object p2, Object p3, Object p4, Object p5) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1), p2, p3, p4, p5});
        return true;
    }

    public boolean trace(String message, int p1, int p2, Object p3, Object p4, Object p5) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, new Object[]{new Integer(p1), new Integer(p2), p3, p4, p5});
        return true;
    }

    public boolean trace(String message, Object[] parameters) {
        if (!this.enabled) {
            return true;
        }
        Log.trace(this.name, message, parameters);
        return true;
    }

    public static void addFormatter(Class type, Formatter formatter) {
        formatters.put(type, formatter != null ? formatter : DEFAULT_FORMATTER);
    }

    public static String format(String message, Object[] arguments) {
        StringBuffer buffer = new StringBuffer();
        Log.append(buffer, message, arguments);
        return buffer.toString();
    }

    public static void append(StringBuffer buffer, String message, Object[] arguments) {
        int length = message.length();
        char[] chars = new char[length + 1];
        message.getChars(0, length, chars, 0);
        chars[length] = '\u0000';
        int i = 0;
        while (true) {
            char c;
            int index;
            char c2;
            int i0 = i;
            do {
                if ((c2 = chars[i++]) != '\u0000') continue;
                buffer.append(chars, i0, i - i0 - 1);
                return;
            } while (c2 != '{' || (index = Character.digit(chars[i], 10)) < 0);
            buffer.append(chars, i0, i - i0 - 1);
            Object argument = index < arguments.length ? arguments[index] : "?";
            Log.append(buffer, argument);
            do {
                int n = ++i;
                ++i;
                c = chars[n];
                if (c != '\u0000') continue;
                buffer.append('?');
                return;
            } while (c != '}');
        }
    }

    public static StringBuffer append(StringBuffer buffer, Object object) {
        Formatter formatter = Log.getFormatter(object);
        try {
            formatter.append(buffer, object);
        }
        catch (Throwable t) {
            buffer.append('<').append(t.getMessage()).append('>');
        }
        return buffer;
    }

    public static Formatter getFormatter(Object object) {
        if (object == null) {
            return DEFAULT_FORMATTER;
        }
        return Log.getFormatter(object.getClass());
    }

    public static Formatter getFormatter(Class objectType) {
        Formatter formatter;
        block3: {
            formatter = formatters.get(objectType);
            if (formatter != null) break block3;
            Class type = objectType;
            do {
                Class<?>[] types = type.getInterfaces();
                int i = 0;
                while (i < types.length) {
                    formatter = formatters.get(types[i]);
                    if (formatter != null) {
                        formatters.put(objectType, formatter);
                        break block3;
                    }
                    ++i;
                }
                if ((type = type.getSuperclass()) != null) continue;
                formatter = DEFAULT_FORMATTER;
                break block3;
            } while ((formatter = formatters.get(type)) == null);
            formatters.put(objectType, formatter);
        }
        return formatter;
    }

    static {
        longestNameLength = ERROR_NAME.length();
        formatters = new HashMap<Class, Formatter>();
        lastTag = new AtomicInteger();
        DEFAULT_FORMATTER = new DefaultFormatter(null);
        formatters.put(Object.class, DEFAULT_FORMATTER);
        formatters.put(boolean[].class, new BooleanArrayFormatter(null));
        formatters.put(byte[].class, new ByteArrayFormatter(null));
        formatters.put(char[].class, new CharArrayFormatter(null));
        formatters.put(short[].class, new ShortArrayFormatter(null));
        formatters.put(int[].class, new IntArrayFormatter(null));
        formatters.put(long[].class, new LongArrayFormatter(null));
        formatters.put(float[].class, new FloatArrayFormatter(null));
        formatters.put(double[].class, new DoubleArrayFormatter(null));
        formatters.put(AWTEvent.class, new AWTEventFormatter(null));
        formatters.put(InputEvent.class, new InputEventFormatter(null));
        formatters.put(ActionEvent.class, new ActionEventFormatter(null));
        String property = System.getProperty("audit.trace");
        if (property != null) {
            int end;
            ArrayList<String> tokens = new ArrayList<String>();
            int start = 0;
            while ((end = property.indexOf(44, start)) >= 0) {
                tokens.add(property.substring(start, end));
                start = end + 1;
            }
            tokens.add(property.substring(start));
            if (!tokens.isEmpty()) {
                boolean asynchronous = false;
                boolean synchronous = false;
                any = true;
                names = new HashSet<String>();
                String destination = "error";
                int i = 0;
                while (i < tokens.size()) {
                    String name = (String)tokens.get(i);
                    if (name.length() != 0) {
                        if (name.charAt(0) == '!') {
                            if ((name = name.substring(1).trim()).equals("asynchronous")) {
                                asynchronous = true;
                            } else if (name.equals("synchronous")) {
                                synchronous = true;
                            } else {
                                destination = name;
                                teeErrors = "error".equalsIgnoreCase(destination) ^ true;
                            }
                        } else {
                            int length = Math.min(NAME_WHITESPACE.length(), name.length());
                            if (length > longestNameLength) {
                                longestNameLength = length;
                            }
                            names.add(name);
                        }
                    }
                    ++i;
                }
                logger = synchronous ? new SynchronousLogger(destination) : (asynchronous ? new AsynchronousLogger(destination, true) : new AsynchronousLogger(destination, false));
            } else {
                any = false;
            }
        } else {
            any = false;
        }
        tagBuffer = new char[]{' ', ' ', ' ', '0'};
        timeBuffer = new char[]{' ', ' ', '0', '.', '0', '0', '0', ',', '0', '0', '0'};
    }

    private static void printerror(String message, Object[] parameters) {
        if (logger != null && !logger.isDisabled()) {
            if (teeErrors) {
                Log.print(System.err, ERROR_NAME, lastTag.getAndIncrement(), System.nanoTime(), Thread.currentThread().getName(), message, parameters);
            }
            logger.add(ERROR_NAME, message, parameters);
        } else {
            Log.print(System.err, ERROR_NAME, lastTag.getAndIncrement(), System.nanoTime(), Thread.currentThread().getName(), message, parameters);
        }
    }

    private static void trace(String name, String message, Object[] parameters) {
        logger.add(name, message, parameters);
    }

    private static PrintStream getStream(String destination) {
        PrintStream stream;
        if (destination.equalsIgnoreCase("error")) {
            stream = System.err;
            System.err.println("Audit: tracing enabled to standard error");
        } else if (destination.equalsIgnoreCase("output")) {
            stream = System.out;
            System.err.println("Audit: tracing enabled to standard output");
        } else {
            try {
                stream = new PrintStream(new BufferedOutputStream(new FileOutputStream(destination)));
                System.err.println("Audit: tracing enabled to " + new File(destination).getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                stream = null;
                System.err.println("Audit: tracing aborted: file " + new File(destination).getAbsolutePath() + " not created:");
                e.printStackTrace(System.err);
            }
        }
        return stream;
    }

    private static void appendTag(StringBuffer buffer, int tag) {
        int i = tagBuffer.length;
        while (tag > 0 && i > 0) {
            Log.tagBuffer[--i] = (char)(48 + tag % 10);
            tag /= 10;
        }
        buffer.append(tagBuffer);
    }

    public static String formatTime(long time) {
        StringBuffer buffer = new StringBuffer();
        Log.appendTime(buffer, time, new char[]{' ', ' ', '0', '.', '0', '0', '0', ',', '0', '0', '0'});
        return buffer.toString();
    }

    public static void appendTime(StringBuffer buffer, long time, char[] timeBuffer) {
        time = (time - TIME_ZERO_NANO) / 1000L;
        timeBuffer[10] = (char)((long)48 + time % (long)10);
        if ((time /= (long)10) > 0L) {
            timeBuffer[9] = (char)((long)48 + time % (long)10);
            if ((time /= (long)10) > 0L) {
                timeBuffer[8] = (char)((long)48 + time % (long)10);
                if ((time /= (long)10) > 0L) {
                    timeBuffer[7] = 44;
                    timeBuffer[6] = (char)((long)48 + time % (long)10);
                    if ((time /= (long)10) > 0L) {
                        timeBuffer[5] = (char)((long)48 + time % (long)10);
                        if ((time /= (long)10) > 0L) {
                            timeBuffer[4] = (char)((long)48 + time % (long)10);
                            if ((time /= (long)10) > 0L) {
                                timeBuffer[3] = 46;
                                timeBuffer[2] = (char)((long)48 + time % (long)10);
                                if ((time /= (long)10) > 0L) {
                                    timeBuffer[1] = (char)((long)48 + time % (long)10);
                                    if ((time /= (long)10) > 0L) {
                                        timeBuffer[0] = (char)((long)48 + time % (long)10);
                                        if ((time /= (long)10) <= 0L) {
                                            // empty if block
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        buffer.append(timeBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(PrintStream stream, String name, int tag, long time, String thread, String message, Object[] parameters) {
        StringBuffer buffer = new StringBuffer("____AUDIT ");
        buffer.append(name);
        buffer.append(NAME_WHITESPACE, name.length(), longestNameLength);
        buffer.append(' ');
        Log.appendTag(buffer, tag);
        buffer.append(": ");
        Log.appendTime(buffer, time, timeBuffer);
        buffer.append(" [");
        int threadLength = thread.length();
        int LIMIT = 16;
        if (threadLength <= 16) {
            buffer.append(thread);
            buffer.append("] ");
            buffer.append(NAME_WHITESPACE, threadLength, 16);
        } else {
            buffer.append(thread, 0, 7);
            buffer.append("*");
            buffer.append(thread, threadLength - 8, threadLength);
            buffer.append("] ");
        }
        if (parameters == null) {
            buffer.append(message);
            stream.println(buffer);
        } else {
            Log.append(buffer, message, parameters);
            if (parameters.length > 0 && parameters[parameters.length - 1] instanceof Throwable) {
                PrintStream printStream = stream;
                synchronized (printStream) {
                    stream.println(buffer);
                    Throwable throwable = (Throwable)parameters[parameters.length - 1];
                    Log.printStackTrace(throwable, stream);
                }
            } else {
                stream.println(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printStackTrace(Throwable e, PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            StackTraceElement[] trace = e.getStackTrace();
            int i = 0;
            while (i < trace.length) {
                s.println("\tat " + trace[i]);
                ++i;
            }
            Throwable cause = e.getCause();
            if (cause != null) {
                Log.printStackTraceAsCause(cause, s, trace);
            }
        }
    }

    private static void printStackTraceAsCause(Throwable e, PrintStream s, StackTraceElement[] causedTrace) {
        Throwable cause;
        StackTraceElement[] trace = e.getStackTrace();
        int m = trace.length - 1;
        int n = causedTrace.length - 1;
        while (m >= 0 && n >= 0 && trace[m].equals(causedTrace[n])) {
            --m;
            --n;
        }
        int framesInCommon = trace.length - 1 - m;
        s.println("Caused by: " + e);
        int i = 0;
        while (i <= m) {
            s.println("\tat " + trace[i]);
            ++i;
        }
        if (framesInCommon != 0) {
            s.println("\t... " + framesInCommon + " more");
        }
        if ((cause = e.getCause()) != null) {
            Log.printStackTraceAsCause(cause, s, trace);
        }
    }

    static AtomicInteger ra$lastTag() {
        return lastTag;
    }

    static void maS$print(PrintStream printStream, String string, int n, long l, String string2, String string3, Object[] objectArray) {
        Log.print(printStream, string, n, l, string2, string3, objectArray);
    }

    static PrintStream maS$getStream(String string) {
        return Log.getStream(string);
    }

    public interface Formatter {
        public void append(StringBuffer var1, Object var2);
    }

    private static class Trace {
        private String name;
        private int tag;
        private long time;
        private String thread;
        private String message;
        private Object[] parameters;

        public Trace(String name, int tag, long time, String thread, String message, Object[] parameters) {
            this.name = name;
            this.tag = tag;
            this.time = time;
            this.thread = thread;
            this.message = message;
            this.parameters = parameters;
        }

        static String ra$name(Trace trace) {
            return trace.name;
        }

        static int ra$tag(Trace trace) {
            return trace.tag;
        }

        static long ra$time(Trace trace) {
            return trace.time;
        }

        static String ra$thread(Trace trace) {
            return trace.thread;
        }

        static String ra$message(Trace trace) {
            return trace.message;
        }

        static Object[] ra$parameters(Trace trace) {
            return trace.parameters;
        }
    }

    private interface Logger {
        public void add(String var1, String var2, Object[] var3);

        public boolean isDisabled();
    }

    private static class SynchronousLogger
    implements Logger {
        private final boolean disabled;
        private final PrintStream stream;

        public SynchronousLogger(String destination) {
            this.stream = Log.maS$getStream(destination);
            boolean bl = this.disabled = this.stream == null;
            if (this.stream != null) {
                try {
                    Runtime.getRuntime().addShutdownHook(new 1("AuditLoggerShutdown"));
                }
                catch (IllegalStateException e) {
                    this.stream.flush();
                }
            }
        }

        public void add(String name, String message, Object[] parameters) {
            if (this.disabled) {
                return;
            }
            Log.maS$print(this.stream, name, Log.ra$lastTag().getAndIncrement(), System.nanoTime(), Thread.currentThread().getName(), message, parameters);
        }

        public boolean isDisabled() {
            return this.stream != null;
        }

        static PrintStream ra$stream(SynchronousLogger synchronousLogger) {
            return synchronousLogger.stream;
        }

        final class 1
        extends Thread {
            public void run() {
                SynchronousLogger.ra$stream(SynchronousLogger.this).flush();
            }

            public 1(String string) {
                super(string);
            }
        }
    }

    private static class AsynchronousLogger
    implements Logger,
    Runnable {
        private String destination;
        private boolean deferredParameters;
        private BlockingQueue<Trace> queue;
        private Thread thread;
        private volatile boolean stopped;
        private volatile boolean disabled;

        public AsynchronousLogger(String destination, boolean deferredParameters) {
            this.destination = destination;
            this.deferredParameters = deferredParameters;
            this.queue = new ArrayBlockingQueue<Trace>(512);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String name, String message, Object[] parameters) {
            if (this.disabled) {
                return;
            }
            int tag = Log.ra$lastTag().getAndIncrement();
            long time = System.nanoTime();
            if (!this.deferredParameters && parameters != null && parameters.length > 0) {
                Object[] evaluated = new Object[parameters.length];
                int i = 0;
                while (i < parameters.length) {
                    evaluated[i] = parameters[i] instanceof Throwable ? parameters[i] : Log.append(new StringBuffer(), parameters[i]);
                    ++i;
                }
                parameters = evaluated;
            }
            Trace trace = new Trace(name, tag, time, Thread.currentThread().getName(), message, parameters);
            BlockingQueue<Trace> blockingQueue = this.queue;
            synchronized (blockingQueue) {
                if (this.thread == null) {
                    this.thread = new Thread((Runnable)this, "AuditLogger");
                    this.thread.setPriority(1);
                    this.thread.start();
                }
            }
            try {
                this.queue.put(trace);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        public void run() {
            PrintStream stream = Log.maS$getStream(this.destination);
            this.destination = null;
            if (stream == null) {
                this.disabled = true;
                this.queue.clear();
                return;
            }
            try {
                Runtime.getRuntime().addShutdownHook(new 1(this, "AuditLoggerShutdown", stream));
            }
            catch (IllegalStateException e) {
                this.stopped = true;
            }
            while (!this.stopped) {
                try {
                    Trace trace = this.queue.take();
                    Log.maS$print(stream, Trace.ra$name(trace), Trace.ra$tag(trace), Trace.ra$time(trace), Trace.ra$thread(trace), Trace.ra$message(trace), Trace.ra$parameters(trace));
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            for (Trace trace : this.queue) {
                Log.maS$print(stream, Trace.ra$name(trace), Trace.ra$tag(trace), Trace.ra$time(trace), Trace.ra$thread(trace), Trace.ra$message(trace), Trace.ra$parameters(trace));
            }
            stream.close();
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        static void wa$stopped(AsynchronousLogger asynchronousLogger, boolean bl) {
            asynchronousLogger.stopped = bl;
        }

        static Thread ra$thread(AsynchronousLogger asynchronousLogger) {
            return asynchronousLogger.thread;
        }

        final class 1
        extends Thread {
            private final /* synthetic */ PrintStream v$stream;
            final /* synthetic */ AsynchronousLogger this$0;

            public void run() {
                this.v$stream.flush();
                AsynchronousLogger.wa$stopped(this.this$0, true);
                AsynchronousLogger.ra$thread(this.this$0).interrupt();
            }

            public 1(AsynchronousLogger asynchronousLogger, String string, PrintStream printStream) {
                this.v$stream = printStream;
                this.this$0 = asynchronousLogger;
                super(string);
            }
        }
    }

    private static class DefaultFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            if (object == null) {
                buffer.append("null");
            } else {
                Class<?> type = object.getClass();
                if (!type.isArray()) {
                    buffer.append(object);
                } else {
                    Class<?> componentType = type.getComponentType();
                    buffer.append(componentType.getName());
                    buffer.append("[]{");
                    Object[] array = (Object[])object;
                    if (array.length > 0) {
                        Log.append(buffer, array[0]);
                        int i = 1;
                        while (i < array.length) {
                            buffer.append(", ");
                            Log.append(buffer, array[i]);
                            ++i;
                        }
                    }
                    buffer.append("}");
                }
            }
        }

        private DefaultFormatter() {
        }

        DefaultFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class BooleanArrayFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            boolean[] array = (boolean[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            int i = 1;
            while (i < array.length) {
                buffer.append(", ");
                buffer.append(array[i]);
                ++i;
            }
            buffer.append('}');
        }

        private BooleanArrayFormatter() {
        }

        BooleanArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ByteArrayFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            byte[] array = (byte[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            int i = 1;
            while (i < array.length) {
                buffer.append(", ");
                buffer.append(array[i]);
                ++i;
            }
            buffer.append('}');
        }

        private ByteArrayFormatter() {
        }

        ByteArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class CharArrayFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            buffer.append('\"');
            char[] array = (char[])object;
            int i = 0;
            while (i < array.length) {
                char c = array[i];
                switch (c) {
                    case '\b': {
                        buffer.append("\\b");
                        break;
                    }
                    case '\t': {
                        buffer.append("\\t");
                        break;
                    }
                    case '\n': {
                        buffer.append("\\n");
                        break;
                    }
                    case '\f': {
                        buffer.append("\\f");
                        break;
                    }
                    case '\r': {
                        buffer.append("\\r");
                        break;
                    }
                    case '\"': {
                        buffer.append("\\\"");
                        break;
                    }
                    case '\\': {
                        buffer.append("\\\\");
                        break;
                    }
                    default: {
                        if (c >= ' ' || c < '\u007f') {
                            buffer.append(c);
                            break;
                        }
                        buffer.append("\\u");
                        String digits = Integer.toHexString(c);
                        int j = digits.length();
                        while (j < 4) {
                            buffer.append('0');
                            ++j;
                        }
                        buffer.append(digits);
                    }
                }
                ++i;
            }
            buffer.append('\"');
        }

        private CharArrayFormatter() {
        }

        CharArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ShortArrayFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            short[] array = (short[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            int i = 1;
            while (i < array.length) {
                buffer.append(", ");
                buffer.append(array[i]);
                ++i;
            }
            buffer.append('}');
        }

        private ShortArrayFormatter() {
        }

        ShortArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class IntArrayFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            int[] array = (int[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            int i = 1;
            while (i < array.length) {
                buffer.append(", ");
                buffer.append(array[i]);
                ++i;
            }
            buffer.append('}');
        }

        private IntArrayFormatter() {
        }

        IntArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class LongArrayFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            long[] array = (long[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            int i = 1;
            while (i < array.length) {
                buffer.append(", ");
                buffer.append(array[i]);
                ++i;
            }
            buffer.append('}');
        }

        private LongArrayFormatter() {
        }

        LongArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class FloatArrayFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            float[] array = (float[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            int i = 1;
            while (i < array.length) {
                buffer.append(", ");
                buffer.append(array[i]);
                ++i;
            }
            buffer.append('}');
        }

        private FloatArrayFormatter() {
        }

        FloatArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class DoubleArrayFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            double[] array = (double[])object;
            if (array.length > 0) {
                buffer.append(array[0]);
            }
            int i = 1;
            while (i < array.length) {
                buffer.append(", ");
                buffer.append(array[i]);
                ++i;
            }
            buffer.append('}');
        }

        private DoubleArrayFormatter() {
        }

        DoubleArrayFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class AWTEventFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            AWTEvent event = (AWTEvent)object;
            buffer.append(event.paramString());
            buffer.append('}');
        }

        private AWTEventFormatter() {
        }

        AWTEventFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class InputEventFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            buffer.append("[when ");
            InputEvent event = (InputEvent)object;
            buffer.append(event.getWhen() - TIME_ZERO_NANO);
            buffer.append("] ");
            buffer.append(event.paramString());
            buffer.append('}');
        }

        private InputEventFormatter() {
        }

        InputEventFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ActionEventFormatter
    implements Formatter {
        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            buffer.append("[when ");
            ActionEvent event = (ActionEvent)object;
            buffer.append(event.getWhen() - TIME_ZERO_MILLI);
            buffer.append("] ");
            buffer.append(event.paramString());
            buffer.append('}');
        }

        private ActionEventFormatter() {
        }

        ActionEventFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

