/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySortedSet<E>
extends AbstractSet<E>
implements SortedSet<E>,
Cloneable {
    private E[] _contents;
    private int _size;
    private Comparator<? super E> _comparator;
    private int _modCount;
    private static final int ALLOW_EXIST = 0;
    private static final int REQUIRE_EXIST = 1;
    private static final int REQUIRE_NOT_EXIST = 2;

    public ArraySortedSet() {
        this(10);
    }

    public ArraySortedSet(int initialSize) {
        this(initialSize, null);
    }

    public ArraySortedSet(Comparator<? super E> comparator) {
        this(10, comparator);
    }

    public ArraySortedSet(int initialSize, Comparator<? super E> comparator) {
        this.$init$();
        initialSize = Math.max(initialSize, 0);
        this._comparator = comparator;
        this._contents = new Object[initialSize];
    }

    public ArraySortedSet(E[] initialContents, Comparator<? super E> comparator) {
        this(initialContents.length, comparator);
        this.addAll(initialContents);
    }

    public ArraySortedSet(Collection<? extends E> initialContents, Comparator<? super E> comparator) {
        this(initialContents.size(), comparator);
        this.addAll(initialContents);
    }

    private void $init$() {
        this._contents = null;
        this._size = 0;
        this._comparator = null;
        this._modCount = 0;
    }

    public void addAll(E[] objects) {
        int count = objects == null ? 0 : objects.length;
        int i = 0;
        while (i < count) {
            this.add(objects[i]);
            ++i;
        }
    }

    public void trimToSize() {
        if (this._size != this._contents.length) {
            Object[] newContents = new Object[this._size];
            System.arraycopy(this._contents, 0, newContents, 0, this._size);
            this._contents = newContents;
        }
    }

    public E lookup(E o) {
        int index = this.find(o, 1);
        return index == -1 ? null : (E)this._contents[index];
    }

    protected ArraySortedSet<E> newArraySortedSet(int initialSize, Comparator<? super E> comparator) {
        return new ArraySortedSet<E>(initialSize, comparator);
    }

    public Object clone() {
        int initialSize = this._contents.length;
        ArraySortedSet<? super E> copy = this.newArraySortedSet(initialSize, this._comparator);
        System.arraycopy(this._contents, 0, copy._contents, 0, this._size);
        copy._size = this._size;
        return copy;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this._comparator;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return new Subset(fromElement, toElement, null);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return new Subset(null, toElement, null);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return new Subset(fromElement, null, null);
    }

    @Override
    public E first() {
        if (this._size > 0) {
            return this._contents[0];
        }
        throw new NoSuchElementException();
    }

    @Override
    public E last() {
        if (this._size > 0) {
            return this._contents[this._size - 1];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayItr(null);
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this._size];
        System.arraycopy(this._contents, 0, a, 0, this._size);
        return a;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length < this._size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this._size);
        }
        System.arraycopy(this._contents, 0, a, 0, this._size);
        if (a.length > this._size) {
            a[this._size] = null;
        }
        return a;
    }

    @Override
    public boolean add(E o) {
        int insertPos = this.find(o, 2);
        if (insertPos != -1) {
            this.insertIndex(o, insertPos);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.find(o, 1);
        if (index != -1) {
            this.removeIndex(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        int index = this.find(o, 1);
        return index != -1;
    }

    @Override
    public void clear() {
        ++this._modCount;
        this._contents = new Object[this._contents.length];
        this._size = 0;
    }

    protected Object intern(E o) {
        int index = this.find(o, 1);
        if (index == -1) {
            this.add(o);
            return o;
        }
        return this._contents[index];
    }

    private int find(Object o, int flags) {
        int top = 0;
        int bottom = this._size;
        while (true) {
            int spread = bottom - top;
            switch (spread) {
                case 0: {
                    return flags == 1 ? -1 : top;
                }
                case 1: {
                    E o2 = this._contents[top];
                    int compare = this.compare(o, o2);
                    boolean matched = compare == 0;
                    int returnIndex = compare <= 0 ? top : bottom;
                    switch (flags) {
                        case 1: {
                            return matched ? top : -1;
                        }
                        case 0: {
                            return returnIndex;
                        }
                        case 2: {
                            return !matched ? returnIndex : -1;
                        }
                    }
                    throw new IllegalStateException("Invalid flag: " + flags);
                }
            }
            int middle_entry = top + bottom >> 1;
            E o2 = this._contents[middle_entry];
            int compare = this.compare(o, o2);
            if (compare == 0) {
                return flags == 2 ? -1 : middle_entry;
            }
            if (compare < 0) {
                bottom = middle_entry;
                continue;
            }
            top = middle_entry + 1;
        }
    }

    private int compare(E o1, E o2) {
        if (this._comparator != null) {
            return this._comparator.compare(o1, o2);
        }
        return ((Comparable)o1).compareTo(o2);
    }

    private void ensureCapacity(int capacity) {
        int currentCapacity = this._contents.length;
        if (currentCapacity < capacity) {
            int newCapacity = Math.max(currentCapacity * 5 / 4, capacity);
            Object[] newContents = new Object[newCapacity];
            System.arraycopy(this._contents, 0, newContents, 0, this._size);
            this._contents = newContents;
        }
    }

    private void insertIndex(E o, int index) {
        if (index <= this._size) {
            ++this._modCount;
            this.ensureCapacity(this._size + 1);
            int countToMove = this._size - index;
            if (countToMove > 0) {
                System.arraycopy(this._contents, index, this._contents, index + 1, countToMove);
            }
            this._contents[index] = o;
            ++this._size;
        } else {
            throw new IllegalStateException("Invalid index: " + index);
        }
    }

    private void removeIndex(int index) {
        if (index < this._size) {
            ++this._modCount;
            int lastIndex = this._size - 1;
            int countToMove = lastIndex - index;
            if (countToMove > 0) {
                System.arraycopy(this._contents, index + 1, this._contents, index, countToMove);
            }
            this._contents[lastIndex] = null;
            --this._size;
        } else {
            throw new IllegalStateException("Invalid index: " + index);
        }
    }

    private void removeRange(int start, int end) {
        int countToRemove = end - start;
        if (start < 0 || end < start || this._size < end) {
            throw new IllegalStateException("Invalid range");
        }
        ++this._modCount;
        int countToMove = this._size - end;
        if (countToMove > 0) {
            System.arraycopy(this._contents, end, this._contents, start, countToMove);
        }
        int i = start + countToMove;
        while (i < this._size) {
            this._contents[i] = null;
            ++i;
        }
        this._size -= countToRemove;
    }

    static int ra$_modCount(ArraySortedSet arraySortedSet) {
        return arraySortedSet._modCount;
    }

    static void mav$removeIndex(ArraySortedSet arraySortedSet, int n) {
        arraySortedSet.removeIndex(n);
    }

    static Object[] ra$_contents(ArraySortedSet arraySortedSet) {
        return arraySortedSet._contents;
    }

    static int ra$_size(ArraySortedSet arraySortedSet) {
        return arraySortedSet._size;
    }

    static int mav$find(ArraySortedSet arraySortedSet, Object object, int n) {
        return arraySortedSet.find(object, n);
    }

    static void mav$removeRange(ArraySortedSet arraySortedSet, int n, int n2) {
        arraySortedSet.removeRange(n, n2);
    }

    static int mav$compare(ArraySortedSet arraySortedSet, Object object, Object object2) {
        return arraySortedSet.compare(object, object2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ArrayItr
    implements Iterator<E> {
        private int endIndex;
        private int nextIndex;
        private int lastIndex;
        private int modCount;

        private ArrayItr() {
            this.$init$();
            this.modCount = ArraySortedSet.ra$_modCount(ArraySortedSet.this);
            this.nextIndex = 0;
            this.endIndex = ArraySortedSet.ra$_size(ArraySortedSet.this);
        }

        private ArrayItr(int start, int end) {
            this.$init$();
            this.modCount = ArraySortedSet.ra$_modCount(ArraySortedSet.this);
            this.nextIndex = start;
            this.endIndex = end;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.endIndex;
        }

        @Override
        public E next() {
            Object next;
            try {
                next = ArraySortedSet.ra$_contents(ArraySortedSet.this)[this.nextIndex];
                this.checkModification();
                this.lastIndex = this.nextIndex++;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkModification();
                throw new NoSuchElementException();
            }
            return next;
        }

        @Override
        public void remove() {
            if (this.lastIndex == -1) {
                throw new IllegalStateException();
            }
            this.checkModification();
            try {
                ArraySortedSet.mav$removeIndex(ArraySortedSet.this, this.lastIndex);
                this.lastIndex = -1;
                --this.nextIndex;
                --this.endIndex;
                this.modCount = ArraySortedSet.ra$_modCount(ArraySortedSet.this);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        private void checkModification() {
            if (this.modCount != ArraySortedSet.ra$_modCount(ArraySortedSet.this)) {
                throw new ConcurrentModificationException();
            }
        }

        private void $init$() {
            this.lastIndex = -1;
        }

        ArrayItr(1 var2_2) {
            this();
        }

        ArrayItr(int n, int n2, 1 var4_4) {
            this(n, n2);
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Subset
    extends AbstractSet<E>
    implements SortedSet<E> {
        private E headObj;
        private E tailObj;

        private Subset(E from, E to) {
            this.headObj = from;
            this.tailObj = to;
        }

        @Override
        public Comparator<? super E> comparator() {
            return ArraySortedSet.this.comparator();
        }

        private boolean inRange(Object o) {
            if (this.headObj != null && ArraySortedSet.mav$compare(ArraySortedSet.this, this.headObj, o) > 0) {
                return false;
            }
            return this.tailObj == null || ArraySortedSet.mav$compare(ArraySortedSet.this, o, this.tailObj) <= 0;
        }

        @Override
        public boolean add(E o) {
            if (!this.inRange(o)) {
                throw new IllegalArgumentException("outside of subset");
            }
            return ArraySortedSet.this.add(o);
        }

        @Override
        public boolean remove(Object o) {
            if (!this.inRange(o)) {
                return false;
            }
            return ArraySortedSet.this.remove(o);
        }

        @Override
        public void clear() {
            int start = this.getStart();
            int end = this.getEnd();
            ArraySortedSet.mav$removeRange(ArraySortedSet.this, start, end);
        }

        @Override
        public SortedSet<E> subSet(E from, E to) {
            Object adjustedFrom = this.inRange(from) ? from : this.headObj;
            Object adjustedTo = this.inRange(to) ? to : this.tailObj;
            return new Subset(adjustedFrom, adjustedTo);
        }

        @Override
        public SortedSet<E> headSet(E to) {
            Object adjustedTo = this.inRange(to) ? to : this.tailObj;
            return new Subset(this.headObj, adjustedTo);
        }

        @Override
        public SortedSet<E> tailSet(E from) {
            Object adjustedFrom = this.inRange(from) ? from : this.headObj;
            return new Subset(adjustedFrom, this.tailObj);
        }

        @Override
        public E first() {
            int end;
            int start = this.getStart();
            if (start == (end = this.getEnd())) {
                throw new NoSuchElementException();
            }
            return ArraySortedSet.ra$_contents(ArraySortedSet.this)[start];
        }

        @Override
        public E last() {
            int end;
            int start = this.getStart();
            if (start == (end = this.getEnd())) {
                throw new NoSuchElementException();
            }
            return ArraySortedSet.ra$_contents(ArraySortedSet.this)[end - 1];
        }

        @Override
        public int size() {
            return this.getEnd() - this.getStart();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            if (this.inRange(o)) {
                return ArraySortedSet.this.contains(o);
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            int start = this.getStart();
            int end = this.getEnd();
            return new ArrayItr(start, end, null);
        }

        private int getStart() {
            int startIndex = this.headObj == null ? 0 : ArraySortedSet.mav$find(ArraySortedSet.this, this.headObj, 0);
            return startIndex;
        }

        private int getEnd() {
            int endIndex = this.tailObj == null ? ArraySortedSet.ra$_size(ArraySortedSet.this) : ArraySortedSet.mav$find(ArraySortedSet.this, this.tailObj, 0);
            return endIndex;
        }

        @Override
        public Object[] toArray() {
            int startIndex = this.getStart();
            int endIndex = this.getEnd();
            int count = endIndex - startIndex;
            Object[] ret = new Object[count];
            System.arraycopy(ArraySortedSet.ra$_contents(ArraySortedSet.this), startIndex, ret, 0, count);
            return ret;
        }

        @Override
        public Object[] toArray(Object[] a) {
            int startIndex = this.getStart();
            int endIndex = this.getEnd();
            int count = endIndex - startIndex;
            if (a.length < count) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), count);
            }
            System.arraycopy(ArraySortedSet.ra$_contents(ArraySortedSet.this), startIndex, a, 0, count);
            if (a.length > count) {
                a[count] = null;
            }
            return a;
        }

        Subset(Object object, Object object2, 1 var4_4) {
            this(object, object2);
        }

        public final class 1 {
        }
    }
}

