/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMap<K, V>
extends AbstractMap<K, V> {
    private ArrayEntry[] entries;
    private int size;
    private int version;
    private ArrayEntrySet entrySet;

    private boolean equals(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public ArrayMap() {
        this.entries = (ArrayEntry[])Array.newInstance(ArrayEntry.class, 4);
    }

    public ArrayMap(Map<? extends K, ? extends V> map) {
        this.size = map.size();
        int capacity = (int)Math.min((long)this.size * (long)110 / (long)100, Integer.MAX_VALUE);
        this.entries = (ArrayEntry[])Array.newInstance(ArrayEntry.class, capacity);
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.entries[index] = new ArrayEntry(entry.getKey(), entry.getValue());
            ++index;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyIndex(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int i = this.size;
            while (--i >= 0) {
                if (ArrayEntry.ra$value(this.entries[i]) != null) continue;
                return true;
            }
        } else {
            int i = this.size;
            while (--i >= 0) {
                if (!value.equals(ArrayEntry.ra$value(this.entries[i]))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        ArrayEntry entry = this.getEntry(key);
        return (V)(entry != null ? ArrayEntry.ra$value(entry) : null);
    }

    @Override
    public V put(K key, V value) {
        return this.put(this.keyIndex(key), value, key);
    }

    @Override
    public V remove(Object key) {
        return this.removeIndex(this.keyIndex(key));
    }

    @Override
    public void clear() {
        ++this.version;
        int i = this.size;
        while (--i >= 0) {
            this.entries[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ArrayEntrySet(null);
        }
        return this.entrySet;
    }

    /*
     * Unable to fully structure code
     */
    private int keyIndex(Object key) {
        block3: {
            i = this.size;
            if (key != null) ** GOTO lbl-1000
            while (--i >= 0) {
                if (ArrayEntry.ra$key(this.entries[i]) != null) {
                    continue;
                }
                break block3;
            }
            break block3;
            while (!key.equals(ArrayEntry.ra$key(this.entries[i]))) lbl-1000:
            // 2 sources

            {
                if (--i >= 0) continue;
            }
        }
        return i;
    }

    private ArrayEntry getEntry(Object key) {
        if (key == null) {
            int i = this.size;
            while (--i >= 0) {
                if (ArrayEntry.ra$key(this.entries[i]) != null) continue;
                return this.entries[i];
            }
        } else {
            int i = this.size;
            while (--i >= 0) {
                if (!key.equals(ArrayEntry.ra$key(this.entries[i]))) continue;
                return this.entries[i];
            }
        }
        return null;
    }

    private V put(int index, V value, K key) {
        ++this.version;
        if (index >= 0) {
            ArrayEntry entry = this.entries[index];
            Object oldValue = ArrayEntry.ra$value(entry);
            ArrayEntry.wa$value(entry, value);
            return (V)oldValue;
        }
        if (this.size == this.entries.length) {
            int newLength = this.size + this.size;
            ArrayEntry[] newEntries = (ArrayEntry[])Array.newInstance(ArrayEntry.class, newLength);
            System.arraycopy(this.entries, 0, newEntries, 0, this.size);
            this.entries = newEntries;
        }
        this.entries[this.size] = new ArrayEntry(key, value);
        ++this.size;
        return null;
    }

    private V removeIndex(int index) {
        if (index < 0 || index >= this.size) {
            return null;
        }
        ++this.version;
        Object oldValue = ArrayEntry.ra$value(this.entries[index]);
        if (index < --this.size) {
            this.entries[index] = this.entries[this.size];
            this.entries[this.size] = null;
        } else {
            this.entries[index] = null;
        }
        return (V)oldValue;
    }

    static int mav$keyIndex(ArrayMap arrayMap, Object object) {
        return arrayMap.keyIndex(object);
    }

    static ArrayEntry[] ra$entries(ArrayMap arrayMap) {
        return arrayMap.entries;
    }

    static boolean mav$equals(ArrayMap arrayMap, Object object, Object object2) {
        return arrayMap.equals(object, object2);
    }

    static Object mav$removeIndex(ArrayMap arrayMap, int n) {
        return arrayMap.removeIndex(n);
    }

    static int ra$size(ArrayMap arrayMap) {
        return arrayMap.size;
    }

    static ArrayEntry mav$getEntry(ArrayMap arrayMap, Object object) {
        return arrayMap.getEntry(object);
    }

    static int ra$version(ArrayMap arrayMap) {
        return arrayMap.version;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        @Override
        public int size() {
            return ArrayMap.ra$size(ArrayMap.this);
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.ra$size(ArrayMap.this) == 0;
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry thatEntry = (Map.Entry)object;
            ArrayEntry thisEntry = ArrayMap.mav$getEntry(ArrayMap.this, thatEntry.getKey());
            return thisEntry != null && ArrayMap.mav$equals(ArrayMap.this, ArrayEntry.ra$value(thisEntry), thatEntry.getValue());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ArrayEntryIterator();
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[ArrayMap.ra$size(ArrayMap.this)];
            System.arraycopy(ArrayMap.ra$entries(ArrayMap.this), 0, array, 0, ArrayMap.ra$size(ArrayMap.this));
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            if (array.length < ArrayMap.ra$size(ArrayMap.this)) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), ArrayMap.ra$size(ArrayMap.this));
            }
            System.arraycopy(ArrayMap.ra$entries(ArrayMap.this), 0, array, 0, ArrayMap.ra$size(ArrayMap.this));
            if (array.length > ArrayMap.ra$size(ArrayMap.this)) {
                array[ArrayMap.ra$size((ArrayMap)ArrayMap.this)] = null;
            }
            return array;
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            Object key = entry.getKey();
            boolean added = ArrayMap.this.containsKey(key) ^ true;
            ArrayMap.this.put(key, entry.getValue());
            return added;
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object key = entry.getKey();
            int index = ArrayMap.mav$keyIndex(ArrayMap.this, key);
            if (index < 0) {
                return false;
            }
            Object value = entry.getValue();
            if (ArrayMap.mav$equals(ArrayMap.this, value, ArrayEntry.ra$value(ArrayMap.ra$entries(ArrayMap.this)[index]))) {
                ArrayMap.mav$removeIndex(ArrayMap.this, index);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }

        private ArrayEntrySet() {
        }

        ArrayEntrySet(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayEntry
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public ArrayEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)object;
            Object thatKey = that.getKey();
            if (!ArrayMap.mav$equals(ArrayMap.this, this.key, thatKey)) {
                return false;
            }
            Object thatValue = that.getValue();
            return ArrayMap.mav$equals(ArrayMap.this, this.value, thatValue);
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + " = " + this.getValue();
        }

        static Object ra$value(ArrayEntry arrayEntry) {
            return arrayEntry.value;
        }

        static void wa$value(ArrayEntry arrayEntry, Object object) {
            arrayEntry.value = object;
        }

        static Object ra$key(ArrayEntry arrayEntry) {
            return arrayEntry.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int index;
        private int expectedVersion;
        private boolean removable;

        public ArrayEntryIterator() {
            this.expectedVersion = ArrayMap.ra$version(ArrayMap.this);
        }

        @Override
        public boolean hasNext() {
            return this.index < ArrayMap.ra$size(ArrayMap.this);
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.expectedVersion != ArrayMap.ra$version(ArrayMap.this)) {
                throw new ConcurrentModificationException();
            }
            if (this.index >= ArrayMap.ra$size(ArrayMap.this)) {
                throw new NoSuchElementException();
            }
            this.removable = true;
            return ArrayMap.ra$entries(ArrayMap.this)[this.index++];
        }

        @Override
        public void remove() {
            if (this.expectedVersion != ArrayMap.ra$version(ArrayMap.this)) {
                throw new ConcurrentModificationException();
            }
            if (!this.removable) {
                throw new IllegalStateException();
            }
            ArrayMap.mav$removeIndex(ArrayMap.this, this.index - 1);
            this.expectedVersion = ArrayMap.ra$version(ArrayMap.this);
            this.removable = false;
        }
    }
}

