/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterator<E>
implements Iterator<E> {
    private E[] array;
    private int index;
    private int endIndex;

    public ArrayIterator(E[] array) {
        this(array, 0, array.length);
    }

    public ArrayIterator(E[] array, int startIndex) {
        this(array, startIndex, array.length);
    }

    public ArrayIterator(E[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalArgumentException(endIndex + " > " + array.length);
        }
        this.array = array;
        this.index = startIndex;
        this.endIndex = endIndex;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    @Override
    public E next() {
        if (this.index >= this.endIndex) {
            throw new NoSuchElementException();
        }
        return this.array[this.index++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

