/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.util;

import java.util.concurrent.CancellationException;

public abstract class AsyncTask
implements Runnable {
    public static final int STATUS_READY = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_COMPLETED = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_CANCELLED = 5;
    protected static final String CANCELLED_RESULT = "cancelled";
    private int _status = 1;
    private Object _result;

    protected AsyncTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int getStatus() {
        int result;
        AsyncTask asyncTask = this;
        synchronized (asyncTask) {
            result = this._status;
        }
        return result;
    }

    public boolean isFinished() {
        int status = this.getStatus();
        return status == 5 || status == 3 || status == 4;
    }

    public void waitUntilFinished() {
        this.waitUntilFinished(25);
    }

    public void waitUntilFinished(int ms) {
        while (!this.isFinished()) {
            AsyncTask.sleep(ms);
        }
    }

    protected static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        AsyncTask asyncTask = this;
        synchronized (asyncTask) {
            if (this._status != 1) {
                return;
            }
            this._status = 2;
        }
        try {
            Object result = this.runImpl();
            AsyncTask asyncTask2 = this;
            synchronized (asyncTask2) {
                if (result == CANCELLED_RESULT) {
                    this._status = 5;
                    result = null;
                } else {
                    this._status = 3;
                }
                this.setResult(result);
            }
        }
        catch (CancellationException e) {
            this.setResult(null);
            AsyncTask asyncTask3 = this;
            synchronized (asyncTask3) {
                this._status = 5;
            }
        }
        catch (CancelledException e) {
            this.setResult(null);
            AsyncTask asyncTask4 = this;
            synchronized (asyncTask4) {
                this._status = 5;
            }
        }
        catch (RuntimeException e) {
            this.setResult(e);
            AsyncTask asyncTask5 = this;
            synchronized (asyncTask5) {
                this._status = 4;
            }
        }
    }

    protected abstract Object runImpl() throws CancelledException;

    protected abstract void requestCancelImpl();

    protected abstract boolean isCancelledImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void requestCancel() {
        AsyncTask asyncTask = this;
        synchronized (asyncTask) {
            switch (this._status) {
                case 1: {
                    this._status = 5;
                    break;
                }
                case 2: {
                    this.requestCancelImpl();
                    break;
                }
                default: {
                    break;
                }
            }
        }
    }

    protected void bailIfCancelled() throws CancelledException {
        if (this.isCancelledImpl()) {
            throw new CancelledException();
        }
    }

    public final Object getResult() {
        return this._result;
    }

    private void setResult(Object result) {
        this._result = result;
    }

    public static class CancelledException
    extends Exception {
        public CancelledException() {
        }

        public CancelledException(String message) {
            super(message);
        }

        public CancelledException(String message, Throwable cause) {
            super(message, cause);
        }

        public CancelledException(Throwable cause) {
            super(cause);
        }
    }
}

