/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.syntax;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.plsql.data.PtnodConstants;
import oracle.javatools.parser.plsql.symtab.PtnodError;
import oracle.javatools.parser.plsql.symtab.PtnodRoot;
import oracle.javatools.parser.plsql.syntax.AST;
import oracle.javatools.parser.plsql.syntax.BaseSqlLexer;
import oracle.javatools.parser.plsql.syntax.ParserException;
import oracle.javatools.parser.plsql.syntax.PlsqlErrorCodes;
import oracle.javatools.resource.BundleHelper;

abstract class BaseSqlLayer
implements PlsqlErrorCodes,
PtnodConstants {
    protected int curToken;
    protected int lastEndOffset;
    protected int handlerDepth;
    protected BaseSqlLexer lexer;
    protected ReadTextBuffer textBuffer;
    protected AST stackTop;
    protected AST[] stack;
    protected int stackHeight;
    protected PtnodRoot root;
    protected int lastCheckpoint;
    protected int errorCount;
    protected int lastErrorOffset;
    protected static final BundleHelper resources = new BundleHelper("oracle.javatools.parser.resource.ParserBundle");

    protected void ips() {
        this.skipToken();
        this.lastEndOffset = 0;
        this.handlerDepth = 0;
        this.stackTop = null;
        this.stack = new AST[4];
        this.lastCheckpoint = -1;
        this.stackHeight = 0;
        this.errorCount = 0;
        this.lastErrorOffset = -1;
        this.node(1);
        this.root = (PtnodRoot)this.stackTop;
    }

    protected Context save_context() {
        Context context = new Context();
        this.lexer.save_context(context);
        context.stackHeight = (short)this.stackHeight;
        context.lastEndOffset = this.lastEndOffset;
        context.lastErrorOffset = this.lastErrorOffset;
        context.handlerDepth = this.handlerDepth;
        context.shushDepth = this.stackTop.shushDepth;
        context.skipDepth = this.stackTop.skipDepth;
        return context;
    }

    protected void restore_context(Context context) {
        this.lexer.restore_context(context);
        this.curToken = this.lexer.lastToken;
        this.lastEndOffset = context.lastEndOffset;
        this.lastErrorOffset = context.lastErrorOffset;
        this.handlerDepth = context.handlerDepth;
        short savedHeight = context.stackHeight;
        int i = this.stackHeight;
        while (i > savedHeight) {
            this.stack[i - 1] = null;
            --i;
        }
        this.stackHeight = savedHeight;
        this.stackTop = this.stack[this.stackHeight - 1];
        this.stackTop.shushDepth = context.shushDepth;
        this.stackTop.skipDepth = context.skipDepth;
    }

    public void setTextBuffer(ReadTextBuffer textBuffer) {
        this.lexer.setTextBuffer(textBuffer);
        this.textBuffer = textBuffer;
    }

    protected final void nextToken(int tk) {
        if (this.curToken == tk) {
            this.skipToken();
        } else {
            this.errorExpecting(tk);
        }
    }

    protected final void nextToken(int tk1, int tk2) {
        if (this.curToken == tk1 || this.curToken == tk2) {
            this.skipToken();
        } else {
            this.errorExpecting(tk1, tk2);
        }
    }

    protected final boolean optionalToken(int tk) {
        if (this.curToken != tk) {
            return false;
        }
        this.skipToken();
        return true;
    }

    protected final boolean optionalToken(int tk1, int tk2) {
        if (this.curToken != tk1 && this.curToken != tk2) {
            return false;
        }
        this.skipToken();
        return true;
    }

    protected final void skipToken() {
        this.lastEndOffset = this.lexer.endOffset;
        this.curToken = this.lexer.lex(null);
    }

    protected abstract AST allocateNode(int var1);

    protected abstract void finishNode();

    protected final boolean node(int ty) {
        if (this.stackTop != null && this.stackTop.shushDepth > 0) {
            this.stackTop.shushDepth = (byte)(this.stackTop.shushDepth + 1);
            return false;
        }
        AST ast = this.allocateNode(ty);
        if (ast == null) {
            this.stackTop.skipDepth = (byte)(this.stackTop.skipDepth + 1);
            return false;
        }
        ast.parent = this.stackTop;
        ast.kind = ty;
        ast.startOffset = this.lexer.startOffset;
        this.push(ast);
        return false;
    }

    private void push(AST ast) {
        if (this.stack.length == this.stackHeight) {
            AST[] newStack = new AST[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        ast.stackDepth = (short)this.stackHeight;
        this.stack[this.stackHeight++] = ast;
        this.stackTop = ast;
    }

    protected final void pop() {
        boolean nonnull;
        if (this.stackTop.shushDepth > 0) {
            this.stackTop.shushDepth = (byte)(this.stackTop.shushDepth - 1);
            return;
        }
        if (this.stackTop.skipDepth > 0) {
            this.stackTop.skipDepth = (byte)(this.stackTop.skipDepth - 1);
            return;
        }
        if (this.stackTop.stackDepth != this.stackHeight - 1) {
            this.internalError();
        }
        boolean bl = nonnull = this.lexer.startOffset != this.stackTop.startOffset;
        if (nonnull) {
            this.finishNode();
        }
        if (this.stackHeight == 0) {
            this.internalError();
        }
        this.stack[--this.stackHeight] = null;
        AST oldStackTop = this.stackTop;
        this.stackTop = this.stackTop.parent;
        if (this.stackHeight == 0) {
            if (this.stackTop != null) {
                this.internalError();
            }
        } else if (this.stackTop != this.stack[this.stackHeight - 1]) {
            this.internalError();
        }
        if (this.stackTop != null && nonnull) {
            this.stackTop.addKid(oldStackTop);
        }
    }

    protected final boolean checkpoint() {
        if (this.lastCheckpoint == this.lexer.startOffset) {
            this.errorUnexpected();
            return false;
        }
        this.lastCheckpoint = this.lexer.startOffset;
        return true;
    }

    protected final void begin_exception_handler() {
        ++this.handlerDepth;
    }

    protected final void end_exception_handler() {
        --this.handlerDepth;
    }

    protected void notImplementedYet(String message) {
        String basic = BaseSqlLayer.lookupErrorMessage(10);
        basic = basic.replaceFirst("{0}", message);
        this.error(10, basic);
    }

    protected void internalError() {
        String message = BaseSqlLayer.lookupErrorMessage(6);
        if (this.root.getErrors().length == 0) {
            this.error(6, message);
        }
        throw new ParserException(message);
    }

    protected void error(int code) {
        String message = BaseSqlLayer.lookupErrorMessage(code);
        this.error(code, message);
    }

    protected void error(int code, String message) {
        if (this.handlerDepth > 0) {
            throw new ParserException(message);
        }
        if (this.errorCount++ < 32 && this.lastErrorOffset != this.lexer.startOffset) {
            PtnodError error = new PtnodError();
            error.kind = 2;
            error.startOffset = this.lexer.startOffset;
            error.message = message;
            this.root.addKid(error);
            this.lastErrorOffset = this.lexer.startOffset;
        }
    }

    protected void errorExpecting(int a) {
        this.error(14);
    }

    protected void errorExpecting(int a, int b) {
        this.error(14);
    }

    protected void errorUnexpected() {
        this.error(14);
        this.skipToken();
    }

    public static String lookupErrorMessage(int code) {
        switch (code) {
            case 1: {
                return resources.getString("PTERR_ALTER_ATTR_MODIFY");
            }
            case 2: {
                return resources.getString("PTERR_ALTER_TYPE");
            }
            case 3: 
            case 15: {
                return resources.getString("PPARSER_ERROR_EXPECTING_IDENTIFIER");
            }
            case 4: {
                return resources.getString("PPARSER_ERROR_EXPECTING_INT_LITERAL");
            }
            case 5: {
                return resources.getString("PTERR_EXPECTING_STRING");
            }
            case 6: {
                return resources.getString("PTERR_INTERNAL_ERROR");
            }
            case 7: {
                return resources.getString("PTERR_INVALID_INTERVAL");
            }
            case 8: 
            case 23: {
                return resources.getString("PTERR_INVALID_PREDICATE");
            }
            case 9: {
                return resources.getString("PTERR_INVALID_TYPE_DEF");
            }
            case 10: {
                return resources.getString("PTERR_NOT_IMPLEMENTED_YET");
            }
            case 11: {
                return resources.getString("PTERR_PARAMETER_STYLE");
            }
            case 12: {
                return resources.getString("PTERR_PARTITION");
            }
            case 13: {
                return resources.getString("PTERR_SQLJ_USING");
            }
            case 14: {
                return resources.getString("PARSER_ERROR_UNEXPECTED");
            }
            case 16: {
                return resources.getString("QCERR_INVALID_CASE");
            }
            case 17: {
                return resources.getString("QCERR_INVALID_DBNM");
            }
            case 18: {
                return resources.getString("QCERR_INVALID_EXPRESSION");
            }
            case 19: {
                return resources.getString("QCERR_INVALID_HEURISTIC");
            }
            case 20: {
                return resources.getString("QCERR_INVALID_INTERVAL");
            }
            case 21: {
                return resources.getString("QCERR_INVALID_JOIN");
            }
            case 22: {
                return resources.getString("QCERR_INVALID_LOCK_TABLE");
            }
            case 24: {
                return resources.getString("QCERR_INVALID_USING");
            }
            case 25: {
                return resources.getString("QCERR_LISTSIZE_MISMATCH");
            }
            case 26: {
                return resources.getString("QCERR_MISSING_EXPRESSION");
            }
            case 27: {
                return resources.getString("QCERR_NO_ALIAS");
            }
            case 28: {
                return resources.getString("QCERR_NO_CUBE_ROLLUP");
            }
            case 29: {
                return resources.getString("QCERR_NO_INLINE_VIEW");
            }
            case 30: {
                return resources.getString("QCERR_NO_LIST_OPERANDS");
            }
            case 31: {
                return resources.getString("QCERR_NO_SAMPLE");
            }
            case 32: {
                return resources.getString("QCERR_RELOP_NEED_ANYALL");
            }
            case 33: {
                return resources.getString("QCERR_SUBQUERY_REQUIRED");
            }
            case 34: {
                return resources.getString("QCERR_TOO_MANY_OPERANDS");
            }
            case 35: {
                return resources.getString("PARSER_ERROR_EOF");
            }
        }
        return resources.getString("QCERR_UNKNOWN");
    }

    BaseSqlLayer() {
    }

    protected static class Context
    extends BaseSqlLexer.Context {
        protected int lastEndOffset;
        protected int lastErrorOffset;
        protected int handlerDepth;
        protected short stackHeight;
        protected byte shushDepth;
        protected byte skipDepth;
        protected int prxopc;

        protected Context() {
        }
    }
}

