/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.SyntaxListener;
import oracle.javatools.parser.SyntaxToken;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxCodes;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxRecognizer;
import oracle.javatools.parser.plsql.old.symbol.CommonRoot;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbolFactory;

public class PlsqlTreeGenerator
implements PlsqlSyntaxCodes,
SyntaxListener {
    private static final int FORCE_FINISH_THRESHOLD = 25;
    private static final boolean kDebugging = false;
    private ReadTextBuffer textBuffer;
    private PlsqlSyntaxRecognizer recognizer;
    private PlsqlSymbolFactory factory;
    private PlsqlSymbol currentParent;
    private CommonRoot currentRoot;
    private int lastOffset;

    private void $init$() {
        this.factory = new PlsqlSymbolFactory();
        this.currentParent = null;
        this.currentRoot = null;
        this.lastOffset = 0;
    }

    public PlsqlTreeGenerator() {
        this.$init$();
    }

    public void initialize(PlsqlSyntaxRecognizer t) {
        this.recognizer = t;
        this.recognizer.setListener(this);
        this.textBuffer = this.recognizer.getLexer().getTextBuffer();
    }

    public PlsqlSyntaxRecognizer getRecognizer() {
        return this.recognizer;
    }

    private void forceFinish() {
        int failureCount = 0;
        while (this.currentParent != null) {
            PlsqlSymbol tmp = this.currentParent.getParent();
            if (!this.factory.forceFinishSymbol(this.currentParent, this.lastOffset, this.textBuffer) && 25 < failureCount++ && this.currentParent != this.currentRoot) {
                this.factory.forceFinishSymbol(this.currentRoot, this.lastOffset, this.textBuffer);
                return;
            }
            this.currentParent = tmp;
        }
    }

    public CommonRoot generate() {
        block3: {
            this.currentRoot = (CommonRoot)this.factory.createSymbol(10, -1, -1, null);
            this.currentParent = this.currentRoot;
            try {
                this.recognizer.parse();
            }
            catch (RuntimeException e) {
                if (this.recognizer.getDebugLevel() != 0) break block3;
                CommonRoot commonRoot = null;
                return commonRoot;
            }
        }
        if (this.currentParent != null) {
            this.forceFinish();
        }
        return this.currentRoot;
    }

    private void debug(SyntaxToken token) {
        int code = token.getCode();
        int startOffset = token.getStartOffset();
        int endOffset = token.getEndOffset();
        String codeString = this.recognizer._codeToString(code);
        if (code == 1) {
            System.out.println("Error message: " + token.getContextString());
        }
        if (endOffset == -1) {
            System.out.println("begin> " + codeString + ". Start = " + startOffset);
        } else {
            System.out.println("  " + codeString + ". (  Start, End  ) = (  " + startOffset + ", " + endOffset + "  )");
            String str = "";
            str = endOffset != -1 && startOffset != -1 ? new String(this.textBuffer.getChars(startOffset, endOffset - startOffset)) : "empty>";
            System.out.println("\t\"" + str + "\"");
            System.out.println("");
        }
    }

    public void receive(SyntaxToken token, int syntaxCode) {
        boolean syntaxIsBegin;
        if (syntaxCode == 1) {
            this.factory.createAndFinishErrorSymbol(token, this.currentRoot);
            return;
        }
        boolean bl = syntaxIsBegin = token.getEndOffset() == -1;
        if (syntaxIsBegin) {
            this.currentParent = this.factory.createSymbol(token, this.currentParent);
        } else if (this.currentParent.getCode() == syntaxCode) {
            this.lastOffset = token.getEndOffset();
            PlsqlSymbol nextParent = this.currentParent.getParent();
            this.factory.finishSymbol(this.currentParent, token, this.textBuffer);
            this.currentParent = nextParent;
        } else if (syntaxCode != 0) {
            PlsqlSymbol symbol = this.factory.createSymbol(token, this.currentParent);
            this.factory.finishSymbol(symbol, token, this.textBuffer);
        } else {
            throw new RuntimeException("EOF!!!");
        }
    }
}

