/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.write;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import oracle.javatools.data.HashStructure;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaPreferences;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MemberComparator
implements Comparator,
JavaConstants,
JavaPreferences.MemberOrder {
    private final byte[] values;

    MemberComparator() {
        this.values = JavaPreferences.MemberOrder.MEMBER_default;
    }

    MemberComparator(SourcePreferences p) {
        HashStructure h = p.getMemberOrderHashStructure();
        if (h != null) {
            int count = 11;
            this.values = new byte[11];
            Arrays.fill(this.values, (byte)-1);
            int i = 0;
            while (i < 11) {
                String key = JavaPreferences.MemberOrder.MEMBER_keys[i];
                if (h.containsKey(key)) {
                    this.values[i] = (byte)h.getInt(key);
                }
                if (this.values[i] < 0) {
                    this.values[i] = JavaPreferences.MemberOrder.MEMBER_default[i];
                }
                ++i;
            }
        } else {
            this.values = JavaPreferences.MemberOrder.MEMBER_default;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MemberComparator) {
            return this.equals((MemberComparator)o);
        }
        return false;
    }

    public boolean equals(MemberComparator o) {
        if (this == o) {
            return true;
        }
        return Arrays.equals(this.values, o.values);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        Sym s1 = (Sym)o1;
        Sym s2 = (Sym)o2;
        short value1 = this.classify(s1);
        short value2 = this.classify(s2);
        return value1 - value2;
    }

    private short classify(Sym s) {
        int member;
        switch (s.symKind) {
            case 7: {
                return Short.MIN_VALUE;
            }
            case 9: {
                int access = s.getModifiers();
                boolean isStatic = Modifier.isStatic(access);
                if (Modifier.isPublic(access)) {
                    if (isStatic) {
                        member = 0;
                        break;
                    }
                    member = 4;
                    break;
                }
                if (Modifier.isProtected(access)) {
                    if (isStatic) {
                        member = 1;
                        break;
                    }
                    member = 5;
                    break;
                }
                if (Modifier.isPrivate(access)) {
                    if (isStatic) {
                        member = 3;
                        break;
                    }
                    member = 7;
                    break;
                }
                if (isStatic) {
                    member = 2;
                    break;
                }
                member = 6;
                break;
            }
            case 6: {
                member = 8;
                break;
            }
            case 19: {
                member = 9;
                break;
            }
            case 3: {
                member = 10;
                break;
            }
            default: {
                return Short.MAX_VALUE;
            }
        }
        return this.values[member];
    }
}

