/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

import java.util.logging.Level;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;
import oracle.javatools.parser.java.v2.write.SourceTransaction;

public class Formatting {
    public static Selection reformatRegion(SourceFile file, int startOffset, int endOffset) {
        FormatRegion region;
        FileSym fileSym = (FileSym)file;
        SourceTransaction transaction = fileSym.getTransaction();
        SourceSavepoint savepoint = null;
        if (transaction != null) {
            savepoint = transaction.savepoint();
        }
        if ((region = fileSym.reformatRegion(startOffset, endOffset)) == null) {
            return null;
        }
        int tokenCount = fileSym.tokens.tokenCount;
        try {
            int startIndex = region.toIndices.getStartOffset();
            if (startIndex < 0) {
                Selection selection = null;
                return selection;
            }
            int targetStartOffset = fileSym.tokens.tokenStarts[startIndex];
            if (targetStartOffset < 0) {
                Selection selection = null;
                return selection;
            }
            int endIndex = region.toIndices.getEndOffset();
            int targetEndOffset = fileSym.tokens.tokenEnds[endIndex];
            int targetLength = targetEndOffset - targetStartOffset;
            Selection selection = new Selection(targetStartOffset, targetLength, null);
            return selection;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JavaParser.getLogger().log(Level.INFO, "Out-of-date token data.", e);
            Selection selection = null;
            return selection;
        }
    }

    public static void reformatSubtree(SourceElement subtree) {
        subtree.reformatSelf(0);
    }

    public static UndoableEdit reformatSelection(SourceFile file, int start, int end) {
        if (file.getErrors(3, 2).size() > 0) {
            return null;
        }
        SourceTransaction rtrans = file.beginTransaction();
        SourceSavepoint rpnt = rtrans.savepoint();
        try {
            Selection selection = Formatting.reformatRegion(file, start, end);
            if (selection == null) {
                throw new Exception();
            }
            UndoableEdit redit = rtrans.commit();
            if (redit == null) {
                throw new Exception();
            }
            UndoableEdit undoableEdit = redit;
            return undoableEdit;
        }
        catch (Exception e) {
            rtrans.rollback(rpnt);
            return null;
        }
    }

    private Formatting() {
    }

    public static class Selection {
        private final int selectionStartOffset;
        private final int selectionLength;

        private Selection(int start, int length) {
            this.selectionStartOffset = start;
            this.selectionLength = length;
        }

        public final int getStartOffset() {
            return this.selectionStartOffset;
        }

        public final int getLength() {
            return this.selectionLength;
        }

        Selection(int n, int n2, 1 var3_3) {
            this(n, n2);
        }

        public final class 1 {
        }
    }
}

