/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.scanner.FastLexer;
import oracle.javatools.parser.util.KeywordTable;

public class JavaLexer
extends FastLexer
implements JavaTokens,
LexerToken {
    public static final KeywordTable keyword13Table;
    public static final KeywordTable keyword14Table;
    public static final KeywordTable keyword15Table;
    private static final int TK_EOF = 0;
    private static final int FL_WHITESPACE = 0x1000000;
    private static final int FL_ID_START = 0x2000000;
    private static final int FL_ID_PART = 0x4000000;
    private static final int FL_SIMPLE_OP = 0x8000000;
    private static final int FL_DIGIT = 0x10000000;
    private static final int FL_COMP_EQ_OP = 0x20000000;
    private static final int MASK_TK = 4095;
    private static final int[] lookupTable;
    private short lastToken;
    private int startOffset;
    private int endOffset;
    private boolean recognizeSQLJ;
    private final KeywordTable keywordTable;

    public JavaLexer() {
        this(JavaParser.j2se);
    }

    public JavaLexer(int j2se) {
        this.setSkipComments(false);
        this.recognizeSQLJ = true;
        this.setTextBuffer(null);
        this.setPosition(0);
        switch (j2se) {
            case 1: {
                this.keywordTable = keyword13Table;
                break;
            }
            default: {
                this.keywordTable = keyword14Table;
                break;
            }
            case 3: {
                this.keywordTable = keyword15Table;
                break;
            }
        }
    }

    public void setPosition(int offset) {
        super.setPosition(offset);
        this.lastToken = (short)-1;
        this.startOffset = -1;
        this.endOffset = -1;
    }

    public void setRecognizeSQLJ(boolean recognizeSQLJ) {
        this.recognizeSQLJ = recognizeSQLJ;
    }

    protected boolean isComment(int tk) {
        switch (tk) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public int getToken() {
        return this.lastToken;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int lex() {
        return this.lex(null);
    }

    /*
     * Unable to fully structure code
     */
    public int lex(LexerToken lexedToken) {
        block85: {
            block86: {
                this.lastToken = 0;
                try {
                    block60: while (true) {
                        this.startOffset = this.currentPos;
                        if ((c = this.textBuffer.getChar(this.currentPos++)) < '\u0100') {
                            lookupValue = JavaLexer.lookupTable[c];
                            if ((lookupValue & 0x1000000) != 0) continue;
                            if ((lookupValue & 0x2000000) != 0) {
                                this.handleIdentifier(c);
                                break block85;
                            }
                            if ((lookupValue & 0x8000000) != 0) {
                                this.lastToken = (short)(lookupValue & 4095);
                                break block85;
                            }
                            if ((lookupValue & 0x20000000) != 0) {
                                this.lastToken = (short)(lookupValue & 4095);
                                if (this.textBuffer.getChar(this.currentPos) == '=') {
                                    this.lastToken = (short)(lookupValue >> 12 & 4095);
                                    ++this.currentPos;
                                }
                                break block85;
                            }
                            if ((lookupValue & 0x10000000) != 0) {
                                this.lastToken = (short)8;
                                this.handleDecimal(c);
                                break block85;
                            }
                        }
                        switch (c) {
                            case '&': {
                                this.lastToken = (short)34;
                                c = this.textBuffer.getChar(this.currentPos);
                                switch (c) {
                                    case '&': {
                                        this.lastToken = (short)52;
                                        ++this.currentPos;
                                        break block60;
                                    }
                                    case '=': {
                                        this.lastToken = (short)32;
                                        ++this.currentPos;
                                        break block60;
                                    }
                                }
                                break block60;
                            }
                            case '|': {
                                this.lastToken = (short)36;
                                c = this.textBuffer.getChar(this.currentPos);
                                switch (c) {
                                    case '|': {
                                        this.lastToken = (short)54;
                                        ++this.currentPos;
                                        break block60;
                                    }
                                    case '=': {
                                        this.lastToken = (short)66;
                                        ++this.currentPos;
                                        break block60;
                                    }
                                }
                                break block60;
                            }
                            case '+': {
                                this.lastToken = (short)67;
                                c = this.textBuffer.getChar(this.currentPos);
                                switch (c) {
                                    case '+': {
                                        this.lastToken = (short)48;
                                        ++this.currentPos;
                                        break block60;
                                    }
                                    case '=': {
                                        this.lastToken = (short)68;
                                        ++this.currentPos;
                                        break block60;
                                    }
                                }
                                break block60;
                            }
                            case '-': {
                                this.lastToken = (short)59;
                                c = this.textBuffer.getChar(this.currentPos);
                                switch (c) {
                                    case '-': {
                                        this.lastToken = (short)40;
                                        ++this.currentPos;
                                        break block60;
                                    }
                                    case '=': {
                                        this.lastToken = (short)60;
                                        ++this.currentPos;
                                        break block60;
                                    }
                                }
                                break block60;
                            }
                            case '<': {
                                this.lastToken = (short)58;
                                c = this.textBuffer.getChar(this.currentPos);
                                switch (c) {
                                    case '=': {
                                        this.lastToken = (short)51;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '<': {
                                        this.lastToken = (short)56;
                                        ++this.currentPos;
                                        c = this.textBuffer.getChar(this.currentPos);
                                        if (c == '=') {
                                            this.lastToken = (short)57;
                                            ++this.currentPos;
                                            break;
                                        }
                                        break block85;
                                    }
                                }
                                break block85;
                            }
                            case '>': {
                                this.lastToken = (short)46;
                                c = this.textBuffer.getChar(this.currentPos);
                                switch (c) {
                                    case '=': {
                                        this.lastToken = (short)45;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '>': {
                                        this.lastToken = (short)73;
                                        ++this.currentPos;
                                        c = this.textBuffer.getChar(this.currentPos);
                                        switch (c) {
                                            case '=': {
                                                this.lastToken = (short)74;
                                                ++this.currentPos;
                                                break;
                                            }
                                            case '>': {
                                                this.lastToken = (short)76;
                                                ++this.currentPos;
                                                c = this.textBuffer.getChar(this.currentPos);
                                                if (c == '=') {
                                                    this.lastToken = (short)77;
                                                    ++this.currentPos;
                                                    break;
                                                }
                                                break block85;
                                            }
                                        }
                                        break block85;
                                    }
                                }
                                break block85;
                            }
                            case '/': {
                                this.lastToken = (short)41;
                                c = this.textBuffer.getChar(this.currentPos);
                                switch (c) {
                                    case '=': {
                                        this.lastToken = (short)42;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '*': {
                                        this.lastToken = (short)25;
                                        ++this.currentPos;
                                        this.skipMultiLineComment();
                                        if (this.textBuffer.getChar(this.startOffset + 2) == '*') {
                                            this.lastToken = (short)26;
                                        }
                                        if (this.skipComments) {
                                            this.lastToken = 0;
                                            continue block60;
                                        }
                                        break block85;
                                    }
                                    case '/': {
                                        this.lastToken = (short)24;
                                        ++this.currentPos;
                                        this.skipLineComment();
                                        if (this.skipComments) {
                                            this.lastToken = 0;
                                            continue block60;
                                        }
                                        break block85;
                                    }
                                }
                                break block85;
                            }
                            case '\"': {
                                this.lastToken = (short)14;
                                this.skipStringLiteral();
                                break block60;
                            }
                            case '\'': {
                                this.lastToken = (short)13;
                                this.skipCharacterLiteral();
                                break block60;
                            }
                            case '.': {
                                this.lastToken = (short)43;
                                c = this.textBuffer.getChar(this.currentPos);
                                if (JavaLexer.isDecimalDigit(c)) {
                                    ++this.currentPos;
                                    this.lastToken = (short)10;
                                    this.skipFloatLiteral();
                                    break block60;
                                }
                                if (c == '.' && this.textBuffer.getChar(this.currentPos + 1) == '.') {
                                    this.lastToken = (short)80;
                                    this.currentPos += 2;
                                    break block60;
                                }
                                break block85;
                            }
                            case '0': {
                                this.lastToken = (short)8;
                                c = this.textBuffer.getChar(this.currentPos);
                                switch (c) {
                                    case 'X': 
                                    case 'x': {
                                        ++this.currentPos;
                                        this.skipHexDigits();
                                        break block60;
                                    }
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        ++this.currentPos;
                                        this.skipDecimalDigits();
                                    }
                                }
                                c = this.textBuffer.getChar(this.currentPos);
                                switch (c) {
                                    case '.': {
                                        ++this.currentPos;
                                        this.lastToken = (short)11;
                                        this.skipFloatLiteral();
                                        break block60;
                                    }
                                    case 'E': 
                                    case 'e': {
                                        this.lastToken = (short)11;
                                        this.skipFloatLiteral();
                                        break block60;
                                    }
                                    case 'L': 
                                    case 'l': {
                                        ++this.currentPos;
                                        this.lastToken = (short)9;
                                        break block60;
                                    }
                                    case 'F': 
                                    case 'f': {
                                        ++this.currentPos;
                                        this.lastToken = (short)10;
                                        break block60;
                                    }
                                    case 'D': 
                                    case 'd': {
                                        ++this.currentPos;
                                        this.lastToken = (short)11;
                                        break block60;
                                    }
                                }
                                break block60;
                            }
                            case '#': {
                                if (this.recognizeSQLJ && this.textBuffer.getLength() - this.currentPos >= 3 && this.textBuffer.getChar(this.currentPos) == 's' && this.textBuffer.getChar(this.currentPos + 1) == 'q' && this.textBuffer.getChar(this.currentPos + 2) == 'l') {
                                    if (this.textBuffer.getLength() - this.currentPos > 3) {
                                        c = this.textBuffer.getChar(this.currentPos + 3);
                                        if (Character.isWhitespace(c) || c == '{' || c == '[') {
                                            this.lastToken = (short)6;
                                            this.currentPos += 4;
                                            this.skipSQLJStatement();
                                            break block60;
                                        }
                                    } else {
                                        this.lastToken = (short)6;
                                        this.currentPos += 3;
                                        this.skipSQLJStatement();
                                        break block60;
                                    }
                                }
                            }
                            default: {
                                if (!Character.isJavaIdentifierStart(c)) {
                                    this.lastToken = 0;
                                    continue block60;
                                }
                                this.handleIdentifier(c);
                                break block60;
                            }
                        }
                        break;
                    }
                    break block85;
                }
                catch (IndexOutOfBoundsException e) {
                    this.currentPos = this.textBuffer.getLength();
                    if (this.lastToken == 0) {
                        this.startOffset = this.currentPos;
                        break block86;
                    }
                    if (this.lastToken != 4) break block86;
                    hash = 0;
                    i = this.startOffset;
                    ** while (i < this.currentPos)
                }
lbl-1000:
                // 1 sources

                {
                    c = this.textBuffer.getChar(i);
                    hash = KeywordTable.computePartialHash(c, hash);
                    ++i;
                    continue;
                }
lbl240:
                // 1 sources

                keyword = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, hash);
                if (keyword != -1) {
                    this.lastToken = (short)keyword;
                }
            }
            if (this.skipComments && this.isComment(this.lastToken)) {
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            } else if (this.lastToken == 25 && this.startOffset + 2 < this.currentPos && this.textBuffer.getChar(this.startOffset + 2) == '*') {
                this.lastToken = (short)26;
            }
        }
        this.endOffset = this.currentPos;
        return this.fillLexerToken(lexedToken);
    }

    public void backup() {
        throw new RuntimeException("Operation not supported");
    }

    private void handleIdentifier(char c) {
        int keyword;
        this.lastToken = (short)4;
        int hash = KeywordTable.computePartialHash(c, 0);
        while ((c = this.textBuffer.getChar(this.currentPos)) < '\u0100' && (lookupTable[c] & 0x4000000) != 0) {
            hash = KeywordTable.computePartialHash(c, hash);
            ++this.currentPos;
        }
        if (c >= '\u0100') {
            while (Character.isJavaIdentifierPart(c = this.textBuffer.getChar(this.currentPos))) {
                hash = KeywordTable.computePartialHash(c, hash);
                ++this.currentPos;
            }
        }
        if ((keyword = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, hash)) != -1) {
            this.lastToken = (short)keyword;
        }
    }

    private void handleDecimal(char c) {
        this.lastToken = (short)8;
        this.skipDecimalDigits();
        c = this.textBuffer.getChar(this.currentPos);
        switch (c) {
            case 'L': 
            case 'l': {
                ++this.currentPos;
                this.lastToken = (short)9;
                break;
            }
            case 'F': 
            case 'f': {
                ++this.currentPos;
                this.lastToken = (short)10;
                break;
            }
            case 'D': 
            case 'd': {
                ++this.currentPos;
                this.lastToken = (short)11;
                break;
            }
            case '.': {
                ++this.currentPos;
                this.lastToken = (short)11;
                this.skipFloatLiteral();
                break;
            }
            case 'E': 
            case 'e': {
                this.lastToken = (short)11;
                this.skipFloatLiteral();
                break;
            }
        }
    }

    private void skipStringLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    --this.currentPos;
                }
                case '\"': {
                    return;
                }
                case '\\': {
                    ++this.currentPos;
                }
            }
        }
    }

    private void skipCharacterLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    --this.currentPos;
                }
                case '\'': {
                    return;
                }
                case '\\': {
                    ++this.currentPos;
                }
            }
        }
    }

    private void skipLineComment() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private void skipMultiLineComment() {
        ++this.currentPos;
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '*': {
                    c = this.textBuffer.getChar(this.currentPos + 1);
                    if (c != '/') break;
                    this.currentPos += 2;
                    return;
                }
                case '/': {
                    c = this.textBuffer.getChar(this.currentPos - 1);
                    if (c != '*') break;
                    ++this.currentPos;
                    return;
                }
            }
            this.currentPos += 2;
        }
    }

    private void skipSQLJStatement() {
        int inBlock = 0;
        block8: while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case ';': {
                    if (0 < inBlock) continue block8;
                    return;
                }
                case '{': {
                    ++inBlock;
                    continue block8;
                }
                case '}': {
                    --inBlock;
                    continue block8;
                }
                case '/': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c == '/') {
                        this.skipLineComment();
                        continue block8;
                    }
                    if (c != '*') continue block8;
                    this.skipMultiLineComment();
                    continue block8;
                }
                case '-': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c != '-') continue block8;
                    this.skipLineComment();
                    continue block8;
                }
                case '\"': 
                case '\'': {
                    char match = c;
                    while ((c = this.textBuffer.getChar(this.currentPos++)) != match) {
                    }
                    continue block8;
                }
            }
        }
    }

    private void skipFloatLiteral() {
        this.skipFloatLiteral(false);
    }

    /*
     * Unable to fully structure code
     */
    private void skipFloatLiteral(boolean hexadecimal) {
        block12: {
            c = this.textBuffer.getChar(this.currentPos);
            if (!hexadecimal) ** GOTO lbl10
            while (JavaLexer.isHexDigit(c) || c == '.') {
                ++this.currentPos;
                c = this.textBuffer.getChar(this.currentPos);
            }
            break block12;
lbl-1000:
            // 1 sources

            {
                ++this.currentPos;
                c = this.textBuffer.getChar(this.currentPos);
lbl10:
                // 2 sources

                ** while (JavaLexer.isDecimalDigit((char)c) || c == '.')
            }
        }
        switch (c) {
            case 'P': 
            case 'p': {
                if (!hexadecimal) break;
            }
            case 'E': 
            case 'e': {
                ++this.currentPos;
                c = this.textBuffer.getChar(this.currentPos);
                if (c == '+' || c == '-') {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                while (JavaLexer.isDecimalDigit(c)) {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                break;
            }
        }
        switch (c) {
            case 'F': 
            case 'f': {
                this.lastToken = (short)10;
            }
            case 'D': 
            case 'd': {
                ++this.currentPos;
                break;
            }
        }
    }

    private void skipDecimalDigits() {
        char c;
        while (JavaLexer.isDecimalDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private void skipHexDigits() {
        while (true) {
            char c;
            if (!JavaLexer.isHexDigit(c = this.textBuffer.getChar(this.currentPos))) {
                switch (c) {
                    case 'L': 
                    case 'l': {
                        this.lastToken = (short)9;
                        ++this.currentPos;
                        break;
                    }
                    case '.': 
                    case 'P': 
                    case 'p': {
                        this.skipFloatLiteral(true);
                        break;
                    }
                }
                return;
            }
            ++this.currentPos;
        }
    }

    private int fillLexerToken(LexerToken lexedToken) {
        if (lexedToken == null) {
            return this.lastToken;
        }
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static boolean isDecimalDigit(char digit) {
        return '0' <= digit && digit <= '9';
    }

    public static boolean isOctalDigit(char digit) {
        return '0' <= digit && digit <= '7';
    }

    public static boolean isHexDigit(char digit) {
        if ('0' <= digit && digit <= '9') {
            return true;
        }
        if ('a' <= digit && digit <= 'f') {
            return true;
        }
        return 'A' <= digit && digit <= 'F';
    }

    static {
        lookupTable = new int[256];
        if (JavaTokens.KW_words.length != 50) {
            System.out.println("Warning: Keyword count mismatch");
        }
        if (JavaTokens.DW_words.length != JavaTokens.DW_values.length) {
            System.out.println("Warning: Duplicate word count mismatch");
        }
        int dupwordCount = JavaTokens.DW_words.length;
        keyword13Table = new KeywordTable(48 + dupwordCount);
        keyword13Table.setCaseSensitivity(true);
        keyword14Table = new KeywordTable(49 + dupwordCount);
        keyword14Table.setCaseSensitivity(true);
        keyword15Table = new KeywordTable(50 + dupwordCount);
        keyword15Table.setCaseSensitivity(true);
        int kw = 96;
        while (kw < 146) {
            if (kw < 144) {
                keyword13Table.addKeyword(JavaTokens.KW_words[kw - 96], kw);
            }
            if (kw < 145) {
                keyword14Table.addKeyword(JavaTokens.KW_words[kw - 96], kw);
            }
            if (kw < 146) {
                keyword15Table.addKeyword(JavaTokens.KW_words[kw - 96], kw);
            }
            kw = (short)(kw + 1);
        }
        int i = 0;
        while (i < dupwordCount) {
            keyword13Table.addKeyword(JavaTokens.DW_words[i], JavaTokens.DW_values[i]);
            keyword14Table.addKeyword(JavaTokens.DW_words[i], JavaTokens.DW_values[i]);
            keyword15Table.addKeyword(JavaTokens.DW_words[i], JavaTokens.DW_values[i]);
            ++i;
        }
        char count = lookupTable.length;
        char ch = '\u0000';
        while (ch < count) {
            int value = 0;
            if (Character.isWhitespace(ch)) {
                value |= 0x1000000;
            }
            if (Character.isJavaIdentifierStart(ch)) {
                value |= 0x2000000;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                value |= 0x4000000;
            }
            if (Character.isDigit(ch) && ch != '0') {
                value |= 0x10000000;
            }
            if (value != 0) {
                JavaLexer.lookupTable[ch] = value;
            }
            ch = (char)(ch + '\u0001');
        }
        JavaLexer.setSimpleOp(64, 79);
        JavaLexer.setSimpleOp(123, 49);
        JavaLexer.setSimpleOp(125, 70);
        JavaLexer.setSimpleOp(91, 50);
        JavaLexer.setSimpleOp(93, 71);
        JavaLexer.setSimpleOp(40, 55);
        JavaLexer.setSimpleOp(41, 72);
        JavaLexer.setSimpleOp(44, 39);
        JavaLexer.setSimpleOp(59, 75);
        JavaLexer.setSimpleOp(126, 35);
        JavaLexer.setSimpleOp(63, 69);
        JavaLexer.setSimpleOp(58, 38);
        JavaLexer.setCompoundEqualsOp(33, 53, 65);
        JavaLexer.setCompoundEqualsOp(42, 63, 64);
        JavaLexer.setCompoundEqualsOp(61, 33, 44);
        JavaLexer.setCompoundEqualsOp(37, 61, 62);
        JavaLexer.setCompoundEqualsOp(94, 37, 78);
    }

    private static void setSimpleOp(int c, int tk) {
        JavaLexer.lookupTable[c] = 0x8000000 | tk & 0xFFF;
    }

    private static void setCompoundEqualsOp(int c, int tk, int tk_equals) {
        JavaLexer.lookupTable[c] = 0x20000000 | tk & 0xFFF | (tk_equals & 0xFFF) << 12;
    }
}

