/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.FastLexer;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public final class ArrayedLexer
extends FastLexer {
    private boolean flag_arrayed;
    private boolean flag_checkarrayed;
    private TokenArray tokens;
    private FastLexer baseLexer;
    private int index;

    private void $init$() {
        this.flag_arrayed = true;
        this.flag_checkarrayed = false;
        this.index = -1;
    }

    public ArrayedLexer(TokenArray tokens, FastLexer baseLexer) {
        this.$init$();
        this.tokens = tokens;
        this.baseLexer = baseLexer;
    }

    public void setTextBuffer(ReadTextBuffer textBuffer) {
        super.setTextBuffer(textBuffer);
        this.baseLexer.setTextBuffer(textBuffer);
    }

    public void setPosition(int offset) {
        this.align(offset);
        this.baseLexer.setPosition(offset);
    }

    private boolean align(int offset) {
        this.flag_arrayed = false;
        if (offset == 0) {
            this.flag_checkarrayed = true;
            this.index = -1;
        } else {
            this.index = this.tokens.search(offset);
            if (this.index >= 0) {
                boolean bl = this.flag_checkarrayed = this.tokens.tokenStarts[this.index] == offset;
                if (this.flag_checkarrayed) {
                    --this.index;
                }
            } else {
                this.flag_checkarrayed = false;
                this.index = -this.index - 1;
            }
        }
        return this.flag_checkarrayed;
    }

    public void setTokenIndex(int index) {
        boolean inBounds;
        this.flag_arrayed = true;
        boolean bl = inBounds = 0 <= index && index < this.tokens.tokenCount;
        if (!inBounds) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.index = index - 1;
    }

    public void setSkipComments(boolean skipComments) {
        super.setSkipComments(skipComments);
        this.baseLexer.setSkipComments(skipComments);
    }

    protected boolean isComment(int tk) {
        return this.baseLexer.isComment(tk);
    }

    public int getToken() {
        if (this.flag_arrayed) {
            if (this.index != -1) {
                return this.tokens.tokenValues[this.index];
            }
            return -1;
        }
        return this.baseLexer.getToken();
    }

    public int getStartOffset() {
        if (this.flag_arrayed) {
            if (this.index != -1) {
                return this.tokens.tokenStarts[this.index];
            }
            return 0;
        }
        return this.baseLexer.getStartOffset();
    }

    public int getEndOffset() {
        if (this.flag_arrayed) {
            if (this.index != -1) {
                return this.tokens.tokenEnds[this.index];
            }
            return 0;
        }
        return this.baseLexer.getEndOffset();
    }

    public int getTokenIndex() {
        return this.index;
    }

    public int lex() {
        return this.lex(null);
    }

    public int lex(LexerToken lexerToken) {
        if (this.flag_checkarrayed) {
            this.flag_arrayed = true;
            this.flag_checkarrayed = false;
        }
        if (this.flag_arrayed) {
            while (this.tokens.tokenCount > this.index + 1) {
                ++this.index;
                if (this.skipComments && this.isComment(this.tokens.tokenValues[this.index])) continue;
            }
            return this.tokens.tokenValues[this.index];
        }
        int out = this.baseLexer.lex(lexerToken);
        int startOffset = this.baseLexer.getStartOffset();
        this.align(startOffset);
        if (this.align(startOffset)) {
            return this.lex();
        }
        return out;
    }
}

