/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.util;

import java.util.Arrays;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.util.OffsetPair;

public final class TokenMap {
    private final FileSym fromFile;
    private final FileSym toFile;
    public final int[] forwardMap;
    public final int[] backwardMap;

    public TokenMap(FileSym fromFile, FileSym toFile) {
        this.fromFile = fromFile;
        this.toFile = toFile;
        int fromCount = fromFile.tokens.tokenCount;
        this.forwardMap = new int[fromCount];
        Arrays.fill(this.forwardMap, -1);
        int toCount = toFile.tokens.tokenCount;
        this.backwardMap = new int[toCount];
        Arrays.fill(this.backwardMap, -1);
        TokenMapTraversal t = new TokenMapTraversal(null);
        fromFile.traverseDual(toFile, t);
        this.forwardMap[fromCount - 1] = toCount - 1;
        this.backwardMap[toCount - 1] = fromCount - 1;
    }

    public int mapForward(int fromFileIndex) {
        return this.map(fromFileIndex, this.forwardMap);
    }

    public int mapBackward(int toFileIndex) {
        return this.map(toFileIndex, this.backwardMap);
    }

    private int map(int index, int[] map) {
        try {
            int n = map[index];
            return n;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int n = -1;
            return n;
        }
    }

    void alignSelf(FormatRegion region, boolean forward) {
        OffsetPair toIndices;
        OffsetPair fromIndices;
        int[] map;
        if (forward) {
            map = this.forwardMap;
            fromIndices = region.fromIndices;
            toIndices = region.toIndices;
        } else {
            map = this.backwardMap;
            fromIndices = region.toIndices;
            toIndices = region.fromIndices;
        }
        int fromStartIndex = fromIndices.getStartOffset();
        int toStartIndex = 0;
        while (fromStartIndex >= 0) {
            toStartIndex = this.map(fromStartIndex, map);
            if (toStartIndex >= 0) break;
            --fromStartIndex;
        }
        if (fromStartIndex < 0) {
            fromStartIndex = 0;
            toStartIndex = 0;
        }
        int fromTokenCount = map.length;
        int fromEndIndex = fromIndices.getEndOffset();
        int toEndIndex = 0;
        while (fromEndIndex < fromTokenCount) {
            toEndIndex = this.map(fromEndIndex, map);
            if (toEndIndex >= 0) break;
            ++fromEndIndex;
        }
        fromIndices.setStartAndEnd(fromStartIndex, fromEndIndex);
        toIndices.setStartAndEnd(toStartIndex, toEndIndex);
    }

    private class TokenMapTraversal
    extends Sym.SymDualTraversal {
        int i;

        private void $init$() {
            this.i = -1;
        }

        protected boolean enter(Sym sym, Sym other) {
            int mappedStart;
            int symStart;
            if (sym.symKind == 70) {
                return false;
            }
            if (sym.symKind == 69) {
                return false;
            }
            if (other != null && (symStart = sym.getStartIndex()) >= 0 && this.i < symStart && (mappedStart = other.getStartIndex()) >= 0) {
                TokenMap.this.forwardMap[symStart] = mappedStart;
                TokenMap.this.backwardMap[mappedStart] = symStart;
                this.i = symStart;
            }
            return sym.symKind != 63;
        }

        protected boolean leave(Sym sym, Sym other) {
            int mappedEnd;
            int symEnd;
            if (other != null && (symEnd = sym.getEndIndex()) >= 0 && this.i < symEnd && (mappedEnd = other.getEndIndex()) >= 0) {
                try {
                    TokenMap.this.forwardMap[symEnd] = mappedEnd;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("Length is " + TokenMap.this.forwardMap.length);
                    sym.describeSelf(0);
                    e.printStackTrace();
                }
                try {
                    TokenMap.this.backwardMap[mappedEnd] = symEnd;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("Length is " + TokenMap.this.backwardMap.length);
                    other.describeSelf(0);
                    e.printStackTrace();
                }
                this.i = symEnd;
            }
            return true;
        }

        private TokenMapTraversal() {
            this.$init$();
        }

        TokenMapTraversal(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

