/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VardeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;

public class VariableSym
extends ObjectSym
implements SourceVariable {
    public short varXDimension;
    public TypeSym varType;

    public final SourceVariableDeclaration getOwningDeclaration() {
        return this.getOwningDeclarationSym();
    }

    public final VardeclSym getOwningDeclarationSym() {
        Sym parentSym = this.getParentSym();
        if (parentSym == null) {
            return null;
        }
        switch (parentSym.symKind) {
            case 9: 
            case 18: {
                return (VardeclSym)parentSym;
            }
        }
        return null;
    }

    public SourceBlock getOwningBlock() {
        Sym parentSym = this.getParentSym();
        switch (this.symKind) {
            case 17: {
                Sym sym = parentSym;
                while (sym != null) {
                    if (sym.symKind == 2) {
                        return (SourceBlock)((Object)sym);
                    }
                    sym = sym.symParent;
                }
                break;
            }
            case 13: {
                Sym sym = parentSym;
                while (sym != null) {
                    switch (sym.symKind) {
                        case 6: 
                        case 19: {
                            MethodSym methodSym = (MethodSym)sym;
                            return methodSym.getBlock();
                        }
                        case 2: {
                            return (SourceBlock)((Object)sym);
                        }
                        case 31: {
                            return ((TreeSym)sym).getBlock();
                        }
                    }
                    sym = sym.symParent;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public final TypeSym getTypeSym() {
        TypeSym typeSym = super.getTypeSym();
        if (typeSym != null) {
            return typeSym;
        }
        return this.varType;
    }

    public void setTypeSym(TypeSym typeSym) {
        int found;
        if (typeSym == null) {
            throw new IllegalArgumentException();
        }
        if (typeSym.isSynthetic()) {
            typeSym = (TypeSym)typeSym.cloneSelf(this.symFile);
            typeSym.symAccess = (char)(typeSym.symAccess & 0xFFFFEFFF);
        }
        if ((found = this.indexOf((byte)27)) != -1) {
            this.replaceChild(found, typeSym);
            return;
        }
        VardeclSym owning = this.getOwningDeclarationSym();
        if (owning == null) {
            this.add(typeSym);
            return;
        }
        List vars = owning.getVariables();
        TypeSym owningType = owning.getTypeSym();
        if (vars.size() > 1) {
            String owningTypeName = owningType.getName();
            if (owningTypeName.equals(typeSym.getName())) {
                this.varType.typeXtraDimension = typeSym.typeXtraDimension;
                return;
            }
            this.separateSelf();
        }
        owning.setTypeSym(typeSym);
        if (this.varType == null) {
            this.buildSelf();
        }
        this.useType(typeSym);
    }

    public SourceExpression getInitializer() {
        return this.getExpressionSym();
    }

    public void setInitializer(SourceExpression e) {
        this.setExpressionSym((Expr)e);
    }

    public Object getConstantValue() {
        if (!this.isFinal()) {
            return null;
        }
        Expr e = this.getExpressionSym();
        if (e == null) {
            return null;
        }
        return e.getConstantValue();
    }

    protected void setModifiersImpl(char access) {
        VardeclSym owning;
        boolean setParentAccess;
        Sym parentSym = this.getParentSym();
        boolean bl = setParentAccess = parentSym != null && parentSym.symAccess != access;
        if (setParentAccess && (owning = this.getOwningDeclarationSym()) != null) {
            List vars = owning.getVariables();
            if (vars.size() > 1) {
                this.separateSelf();
            }
            owning.setModifiers(access);
            return;
        }
        this.setAccess(access);
    }

    public void separateSelf() {
        this.separateSelfImpl();
    }

    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        if (this.varType != null) {
            this.varType.clearCompiledInfo();
        }
    }

    public String printCompiledInfo() {
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null) {
            return "FieldSignature " + resolvedType.getTypeSignature();
        }
        return "FieldSignatrue <unknown>";
    }

    protected void add(Sym child, byte filter) {
        VardeclSym vardecl;
        if (child != null && child.symKind == 1 && (vardecl = this.getOwningDeclarationSym()) != null) {
            vardecl.add(child, filter);
            return;
        }
        super.add(child, filter);
    }

    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 27: {
                return 0;
            }
            case 20: {
                if (this.varType != null) {
                    return 0;
                }
                return 1;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    protected boolean isValidChild(Sym target, byte filter) {
        switch (target.symKind) {
            case 20: 
            case 27: {
                return true;
            }
        }
        if (target.is((byte)83)) {
            return true;
        }
        return super.isValidChild(target, filter);
    }

    protected final void linkSelfTrigger(TreeSym parent, byte filter) {
        super.linkSelfTrigger(parent, filter);
    }

    protected final void unlinkSelfTrigger(TreeSym parent, byte filter) {
        super.unlinkSelfTrigger(parent, filter);
    }

    public void buildSelf() {
        VardeclSym owning = this.getOwningDeclarationSym();
        if (owning != null) {
            this.symAccess = (char)(this.symAccess | owning.symAccess);
            this.objectImplicit = owning.objectImplicit;
        }
        super.buildSelf();
        switch (this.symKind) {
            case 10: 
            case 17: {
                this.varType = (TypeSym)SymFactory.createNode(this.symFile, 27);
                SymFactory.setupSynthetic(this.varType, this, -1);
                break;
            }
        }
        if (this.varXDimension > 0) {
            TypeSym typeSym = this.getTypeSym();
            typeSym.typeXtraDimension = this.varXDimension;
        }
    }

    public Sym cloneSelf(FileSym targetFile) {
        VariableSym sym = (VariableSym)super.cloneSelf(targetFile);
        sym.varXDimension = this.varXDimension;
        if (this.varType != null) {
            sym.varType = (TypeSym)this.varType.cloneSelf(targetFile);
            sym.varType.symParent = this;
        }
        return sym;
    }

    protected JavaElement resolveImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    private void print_initializer(PrintWriter out) {
        Sym initializer = this.getChild((byte)83);
        if (initializer != null) {
            out.print(" = ");
            initializer.print(out);
        }
    }

    public void print(PrintWriter out, int argument) {
        switch (argument) {
            default: {
                this.print_annotations(out);
                this.print_modifiers(out);
                VariableSym.print(this.getTypeSym(), out, argument);
                out.print(' ');
                VariableSym.print(this.getNameSym(), out, argument);
                this.print_initializer(out);
                break;
            }
            case 2: {
                VariableSym.print(this.getTypeSym(), out, argument);
                out.print(' ');
                VariableSym.print(this.getNameSym(), out, argument);
                break;
            }
            case 1: {
                VariableSym.print(this.getNameSym(), out, argument);
                int i = 0;
                while (i < this.varXDimension) {
                    out.print("[]");
                    ++i;
                }
                this.print_initializer(out);
                break;
            }
            case 3: {
                VariableSym.print(this.getTypeSym(), out, argument);
                break;
            }
        }
    }

    protected void finishSynthetic(NameSym classNameSym) {
        if (this.varType == null) {
            VariableSym.panic();
        }
        SyntaxData data = new SyntaxData();
        data.addKid(classNameSym);
        this.varType.symData = data;
        this.varType.buildSelf();
    }

    protected void setupSynthetic(Sym offsetSym) {
        this.symAccess = (char)(this.symAccess | 0x1000);
        this.symStart = offsetSym.symStart;
        this.symEnd = offsetSym.symEnd;
        this.symFile = offsetSym.symFile;
        TypeSym typeSym = (TypeSym)SymFactory.createNode(this.symFile, 27);
        SymFactory.setupSynthetic(typeSym, this, offsetSym.symStart);
        this.varType = typeSym;
    }

    protected void useType(TypeSym base) {
        if (this.varType == null) {
            VariableSym.panic();
        }
        TypeSym typeSym = this.varType;
        typeSym.symStart = base.symStart;
        typeSym.symEnd = base.symEnd;
        typeSym.treeChildren = base.treeChildren;
        typeSym.typeBaseDimension = base.typeBaseDimension;
        typeSym.typeXtraDimension = this.varXDimension;
        typeSym.typeToken = base.typeToken;
    }

    private void separateSelf(TypeSym typeSym) {
        TreeSym parent;
        VardeclSym oldOwning = this.getOwningDeclarationSym();
        if (oldOwning == null) {
            VariableSym.panic("No owning declaration");
        }
        if ((parent = (TreeSym)oldOwning.getParentSym()) == null) {
            VariableSym.errorNoParent();
        }
        int index = parent.indexOf(oldOwning);
        VardeclSym owning = (VardeclSym)SymFactory.createNode(this.symFile, oldOwning.symKind);
        owning.symAccess = this.symAccess;
        owning.symFormat = (char)(owning.symFormat | 2);
        this.varXDimension = 0;
        this.varType = null;
        this.removeSelf();
        owning.add(typeSym);
        owning.add(this);
        this.buildSelf();
        this.useType(typeSym);
        parent.linkChild(index + 1, owning);
    }

    private void separateSelfImpl() {
        List variables;
        int variableCount;
        TreeSym parent;
        VardeclSym oldOwning = this.getOwningDeclarationSym();
        if (oldOwning == null) {
            VariableSym.unsupported("No owning declaration");
        }
        if ((parent = (TreeSym)oldOwning.getParentSym()) == null) {
            VariableSym.errorNoParent();
        }
        if ((variableCount = (variables = oldOwning.getVariables()).size()) < 2) {
            return;
        }
        int variableIndex = variables.indexOf(this);
        if (variableIndex == -1) {
            VariableSym.panic();
        }
        if (variableIndex > 0) {
            VardeclSym owningClone = (VardeclSym)oldOwning.cloneSelf(this.symFile);
            owningClone.addSelfBefore(oldOwning);
            List cloneVariables = owningClone.getVariables();
            int i = variableCount - 1;
            while (i >= variableIndex) {
                cloneVariables.remove(i);
                --i;
            }
        }
        if (variableIndex != variableCount - 1) {
            VardeclSym owningClone = (VardeclSym)oldOwning.cloneSelf(this.symFile);
            owningClone.addSelfAfter(oldOwning);
            List cloneVariables = owningClone.getVariables();
            int i = variableIndex;
            while (i >= 0) {
                cloneVariables.remove(i);
                --i;
            }
        }
        int i = variableCount - 1;
        while (i >= 0) {
            if (i != variableIndex) {
                variables.remove(i);
            }
            --i;
        }
    }
}

