/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.Collection;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymSavepoint;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.parser.java.v2.write.SourceTransactionListener;

final class SymTransaction
extends TreeSym
implements SourceTransaction,
TextBufferListener {
    protected TextBuffer realTextBuffer;
    protected TextBuffer copyTextBuffer;
    protected TextBuffer transTextBuffer;
    public SyntaxData transData;
    private final TextEdit transEditFront;
    private TextEdit transEditBack;
    private SourceTransactionListener[] listeners;

    private void $init$() {
        this.transEditBack = this.transEditFront = new TextEdit(0, 0, null);
        this.listeners = SourceTransactionListener.EMPTY_ARRAY;
        this.symKind = (byte)78;
    }

    SymTransaction(FileSym fileSym, TextBuffer textBuffer) {
        this.$init$();
        if (fileSym == null) {
            throw new IllegalArgumentException();
        }
        this.symParent = fileSym;
        this.symFile = fileSym;
        this.transData = new SyntaxData();
        if (textBuffer == null) {
            throw new IllegalArgumentException("File has no text buffer");
        }
        this.realTextBuffer = textBuffer;
    }

    public final boolean flag_saving() {
        return this.testSymFlag((byte)-128);
    }

    public boolean hasOutstandingChanges() {
        return this.transData.kidCount > 0;
    }

    public boolean savepointInProgress() {
        return this.flag_saving();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSavepoint() {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            if (this.savepointInProgress()) {
                return;
            }
            this.savepoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceSavepoint savepoint() {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            if ((this.symFlags & 0xFFFFFF80) != 0) {
                SymTransaction.panic("Savepoint already in progress");
            }
            this.symFlags = (byte)(this.symFlags | 0xFFFFFF80);
            this.symFile.symFlags = (byte)(this.symFile.symFlags | 0xFFFFFF80);
            try {
                if (this.transData.kidCount == 0) {
                    SymSavepoint symSavepoint = (SymSavepoint)this.getLastChild((byte)77);
                    return symSavepoint;
                }
                int lastSavepoint = this.lastIndexOf((byte)77);
                SymSavepoint savepoint = new SymSavepoint(this);
                this.symFile.clearCompiledInfo();
                savepoint.preprocessSelf();
                int childCount = this.treeChildren.length;
                int i = lastSavepoint + 1;
                while (i < childCount) {
                    this.transData.addKid(this.treeChildren[i]);
                    ++i;
                }
                savepoint.symData = this.transData;
                savepoint.buildSelf();
                savepoint.processSelf();
                savepoint.lastIncludedEdit = this.transEditBack;
                savepoint.symData = this.transData;
                savepoint.buildSelf();
                if (this.transData.kidCount > 0) {
                    SymTransaction.panic();
                }
                this.transData.addKid(savepoint);
                this.buildSelf();
                this.symFile.clearCompiledInfo();
                SymSavepoint symSavepoint = savepoint;
                return symSavepoint;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
            {
                finally {
                    this.symFile.symFlags = (byte)(this.symFile.symFlags & 0x7F);
                    this.symFlags = (byte)(this.symFlags & 0x7F);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(SourceSavepoint target) {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            SymSavepoint savepointSym = (SymSavepoint)target;
            int savepointIndex = this.indexOf(savepointSym);
            if (savepointIndex == -1) {
                throw new IllegalArgumentException();
            }
            int count = this.transData.kidCount;
            Sym[] kids = this.transData.kids;
            this.transData = new SyntaxData();
            int i = count - 1;
            while (i >= 0) {
                SymOperation op = (SymOperation)kids[i];
                op.undoSelf();
                --i;
            }
            int count2 = this.treeChildren.length;
            int i2 = count2 - 1;
            while (i2 > savepointIndex) {
                SymSavepoint savepoint = (SymSavepoint)this.treeChildren[i2];
                savepoint.undoSelf();
                --i2;
            }
            this.transData.kidCount = 0;
            TextEdit.wa$next(savepointSym.lastIncludedEdit, null);
            this.symFile.clearFormatInfo();
            this.symFile.adjustOffsets();
            Sym[] newArray = new Sym[savepointIndex + 1];
            System.arraycopy(this.treeChildren, 0, newArray, 0, savepointIndex + 1);
            this.treeChildren = newArray;
            this.symFile.buildSelf();
            this.symFile.clearCompiledInfo();
        }
    }

    public void rollback() {
        this.rollback((SymSavepoint)this.treeChildren[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UndoableEdit commit() {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            this.realTextBuffer.beginEdit();
            try {
                this.savepoint();
                SymTransaction.performTextEdits(this.realTextBuffer, this.transEditFront);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            UndoableEdit edit = this.realTextBuffer.endEdit();
            this.close(true);
            this.symFile.notify(this);
            UndoableEdit undoableEdit = edit;
            return undoableEdit;
        }
    }

    public void abort() {
        try {
            this.rollback();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        this.close(false);
    }

    protected TextBuffer getTextBuffer() {
        return this.transTextBuffer;
    }

    public Collection getChanges() {
        return InternalConstants.kEmptyList;
    }

    public Collection getChanges(SourceSavepoint from, SourceSavepoint to) {
        return InternalConstants.kEmptyList;
    }

    protected void begin() {
        boolean acquiredWriteLock = false;
        try {
            this.realTextBuffer.writeLock();
            acquiredWriteLock = true;
        }
        finally {
            if (!acquiredWriteLock) {
                this.closeTransaction();
            }
        }
        boolean transactionBegan = false;
        try {
            this.copyTextBuffer = SymTransaction.acquireTextBuffer();
            char[] chars = this.realTextBuffer.getChars(0, this.realTextBuffer.getLength());
            this.copyTextBuffer.insert(0, chars);
            this.copyTextBuffer.addTextBufferListener(this);
            this.transTextBuffer = this.copyTextBuffer;
            SymSavepoint savepoint = new SymSavepoint(this);
            savepoint.lastIncludedEdit = this.transEditBack;
            this.treeChildren = new Sym[]{savepoint};
            transactionBegan = true;
        }
        finally {
            if (!transactionBegan) {
                this.close(false);
            }
        }
    }

    private void close(boolean commit) {
        try {
            this.realTextBuffer.writeUnlock();
            this.transTextBuffer = null;
            if (this.copyTextBuffer != null) {
                this.copyTextBuffer.removeTextBufferListener(this);
                SymTransaction.releaseTextBuffer(this.copyTextBuffer);
                this.copyTextBuffer = null;
            }
            int count = this.listeners.length;
            int i = count - 1;
            while (i >= 0) {
                this.listeners[i].closeUpdate(this, commit);
                --i;
            }
            this.listeners = SourceTransactionListener.EMPTY_ARRAY;
        }
        finally {
            this.closeTransaction();
        }
    }

    private void closeTransaction() {
        SymTransaction transaction = this.symFile.getTransactionSym();
        if (transaction != this) {
            SymTransaction.panic();
        }
        this.symFile.closeTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SymOperation newOperation(byte op) {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            SymOperation operation = new SymOperation(this, op);
            this.transData.addKid(operation);
            SymOperation symOperation = operation;
            return symOperation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOperation(SymOperation op) {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            int count = this.listeners.length;
            int i = count - 1;
            while (i >= 0) {
                this.listeners[i].changeUpdate(this, null);
                --i;
            }
        }
    }

    public void buildSelf() {
        this.symData = this.transData;
        super.buildSelf();
        this.transData.kidCount = 0;
    }

    private int findListener(SourceTransactionListener listener) {
        int count = this.listeners.length;
        int i = 0;
        while (i < count) {
            if (this.listeners[i] == listener) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SourceTransactionListener listener) {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            int index = this.findListener(listener);
            if (index != -1) {
                return;
            }
            int count = this.listeners.length;
            SourceTransactionListener[] newArray = new SourceTransactionListener[count + 1];
            if (count > 0) {
                System.arraycopy(this.listeners, 0, newArray, 0, count);
            }
            newArray[count] = listener;
            this.listeners = newArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SourceTransactionListener listener) {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            int index = this.findListener(listener);
            if (index == -1) {
                return;
            }
            int count = this.listeners.length;
            if (count == 1) {
                this.listeners = SourceTransactionListener.EMPTY_ARRAY;
            } else {
                SourceTransactionListener[] newArray = new SourceTransactionListener[count - 1];
                if (index != 0) {
                    System.arraycopy(this.listeners, 0, newArray, 0, index);
                }
                if (index != count - 1) {
                    System.arraycopy(this.listeners, index + 1, newArray, index, count - 1 - index);
                }
                this.listeners = newArray;
            }
        }
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] data) {
        TextEdit edit = new TextEdit(offset, data, null);
        TextEdit.wa$next(this.transEditBack, edit);
        this.transEditBack = edit;
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] data) {
        TextEdit edit = new TextEdit(offset, count, null);
        TextEdit.wa$next(this.transEditBack, edit);
        this.transEditBack = edit;
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
    }

    private static void performTextEdits(TextBuffer textBuffer, TextEdit front) {
        TextEdit te = front;
        while (te != null) {
            if (TextEdit.ra$insertedData(te) != null) {
                textBuffer.insert(TextEdit.ra$offset(te), TextEdit.ra$insertedData(te));
            } else {
                textBuffer.remove(TextEdit.ra$offset(te), TextEdit.ra$count(te));
            }
            te = TextEdit.ra$next(te);
        }
    }

    protected static class TextEdit {
        private final int offset;
        private final int count;
        private final char[] insertedData;
        private TextEdit next;

        private void $init$() {
            this.next = null;
        }

        private TextEdit(int offset, char[] insertedData) {
            this.$init$();
            this.offset = offset;
            this.count = 0;
            this.insertedData = insertedData;
        }

        private TextEdit(int offset, int count) {
            this.$init$();
            this.offset = offset;
            this.count = count;
            this.insertedData = null;
        }

        static char[] ra$insertedData(TextEdit textEdit) {
            return textEdit.insertedData;
        }

        static int ra$offset(TextEdit textEdit) {
            return textEdit.offset;
        }

        static int ra$count(TextEdit textEdit) {
            return textEdit.count;
        }

        static TextEdit ra$next(TextEdit textEdit) {
            return textEdit.next;
        }

        TextEdit(int n, int n2, 1 var3_3) {
            this(n, n2);
        }

        static void wa$next(TextEdit textEdit, TextEdit textEdit2) {
            textEdit.next = textEdit2;
        }

        TextEdit(int n, char[] cArray, 1 var3_3) {
            this(n, cArray);
        }

        public final class 1 {
        }
    }
}

