/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.PackageSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.write.SourceComparator;
import oracle.javatools.util.ArraySortedSet;

public final class RootSym
extends TreeSym {
    private void $init$() {
        this.symFlags = (byte)(this.symFlags | 1);
        this.symFlags = (byte)(this.symFlags | 2);
    }

    public SourcePackage getSourcePackage() {
        return this.getPackageSym();
    }

    public PackageSym getPackageSym() {
        return (PackageSym)this.getChild((byte)21);
    }

    public void setSourcePackage(SourcePackage packageD) {
        this.setPackageSym((PackageSym)packageD);
    }

    public void setPackageSym(PackageSym packageSym) {
        this.setSym((byte)21, packageSym);
    }

    public void setPackageName(String name) {
        PackageSym packageSym = this.getPackageSym();
        if (packageSym != null) {
            packageSym.setName(name);
        } else {
            PackageSym newPackage = (PackageSym)this.symFile.factory.createPackageDeclaration(name);
            this.linkChild(0, newPackage);
        }
    }

    public List getSourceImports() {
        return this.getChildren((byte)14);
    }

    public Set getSourceImportNames() {
        return new ImportSet(null);
    }

    public List getSourceClasses() {
        return this.getChildren((byte)3);
    }

    public SourceClass getSourceClass(String name) {
        for (ClassSym thing : this.getSourceClasses()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public SourceName getSqlContext() {
        return null;
    }

    public Collection getClasses() {
        return this.getObjects((byte)3);
    }

    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 3: 
            case 14: 
            case 21: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }

    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 21: {
                return 0;
            }
            case 14: {
                int firstImport;
                int lastImport = this.lastIndexOf((byte)14);
                if (lastImport == -1) {
                    int lastPackage = this.lastIndexOf((byte)21);
                    if (lastPackage != -1) {
                        return lastPackage + 1;
                    }
                    return 0;
                }
                Comparator hasNameC = SourceComparator.hasNameComparator();
                int target = firstImport = this.indexOf((byte)14);
                while (target <= lastImport) {
                    int result = hasNameC.compare(sym, this.treeChildren[target]);
                    if (result == 0) {
                        return -1;
                    }
                    if (result < 0) break;
                    ++target;
                }
                return target;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    protected JavaElement resolveImpl(CompilerDriver compiler) {
        return null;
    }

    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (!compiler.preloadClasses()) {
            return this.getCompiledObject();
        }
        compiler.resolve(this);
        JavaElement out = super.compileImpl(compiler);
        compiler.compile(this);
        return out;
    }

    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    public RootSym() {
        this.$init$();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImportSet
    extends AbstractSet {
        @Override
        public Iterator iterator() {
            return new ImportSetIterator();
        }

        @Override
        public boolean isEmpty() {
            return RootSym.this.getChild((byte)14) != null;
        }

        @Override
        public int size() {
            Set set = this.toStrings();
            return set.size();
        }

        private Set toStrings() {
            ImportSetIterator i = new ImportSetIterator();
            while (i.hasNext()) {
                i.next();
            }
            return ImportSetIterator.ra$processed(i);
        }

        @Override
        public boolean add(String value) {
            if (this.contains(value)) {
                return false;
            }
            SourceFactory factory = RootSym.this.symFile.getFactory();
            ImportSym importSym = (ImportSym)factory.createImportDeclaration(value);
            importSym.addSelf(RootSym.this);
            return true;
        }

        public boolean contains(String value) {
            for (ImportSym importSym : RootSym.this.getSourceImports()) {
                if (!value.equals(importSym.getName())) continue;
                return true;
            }
            return false;
        }

        public boolean remove(String value) {
            boolean found = false;
            Iterator iterator = RootSym.this.getSourceImports().iterator();
            while (iterator.hasNext()) {
                ImportSym importSym = (ImportSym)iterator.next();
                if (!value.equals(importSym.getName())) continue;
                iterator.remove();
                found = true;
            }
            return found;
        }

        @Override
        public boolean add(Object o) {
            return this.add((String)o);
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((String)o);
        }

        @Override
        public boolean remove(Object o) {
            return this.remove((String)o);
        }

        @Override
        public boolean containsAll(Collection c) {
            Set set = this.toStrings();
            return set.containsAll(c);
        }

        @Override
        public void clear() {
            RootSym.this.getSourceImports().clear();
        }

        private ImportSet() {
        }

        ImportSet(1 var2_2) {
            this();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ImportSetIterator
        implements Iterator {
            private final ArraySortedSet processed;
            private String next;
            private int iteratorNext;

            private void $init$() {
                this.processed = new ArraySortedSet();
                this.next = null;
                this.iteratorNext = -1;
            }

            ImportSetIterator() {
                this.$init$();
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.iteratorNext < RootSym.this.treeChildren.length;
            }

            public Object next() {
                if (!this.hasNext()) {
                    return null;
                }
                this.advance();
                return this.next;
            }

            @Override
            public void remove() {
                --this.iteratorNext;
                ImportSet.this.remove(this.next);
                this.advance();
            }

            private void advance() {
                int count = RootSym.this.treeChildren.length;
                if (count <= this.iteratorNext) {
                    return;
                }
                ++this.iteratorNext;
                while (this.iteratorNext < RootSym.this.treeChildren.length) {
                    Sym sym = RootSym.this.treeChildren[this.iteratorNext];
                    if (sym.symKind == 14) {
                        ImportSym importSym = (ImportSym)sym;
                        this.next = importSym.getName();
                        if (!this.processed.contains(this.next)) break;
                    }
                    ++this.iteratorNext;
                }
                if (this.next != null) {
                    this.processed.add(this.next);
                }
            }

            static ArraySortedSet ra$processed(ImportSetIterator importSetIterator) {
                return importSetIterator.processed;
            }
        }

        public final class 1 {
        }
    }
}

