/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.Collection;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaType;

public abstract class ObjectSym
extends TreeSym {
    public char objectFlags;
    public char objectXaccess;
    public char objectImplicit;

    public JavaType getResolvedType() {
        TypeSym typeSym = this.getTypeSym();
        if (typeSym == null) {
            return null;
        }
        JavaType returnType = typeSym.getResolvedType();
        if (returnType == null) {
            return null;
        }
        return returnType;
    }

    public JavaType guessResolvedType() {
        return this.getResolvedType();
    }

    public JavaElement getCompiledObject() {
        return this;
    }

    public final int getModifiers() {
        return this.symAccess | this.objectImplicit;
    }

    public Collection getDeclaredAnnotations() {
        return this.getObjects((byte)1);
    }

    public Collection getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    public final JavaAnnotation getDeclaredAnnotation(JavaType annotationType) {
        return CommonUtilities.getDeclaredAnnotation((JavaHasAnnotations)((Object)this), annotationType);
    }

    public JavaAnnotation getAnnotation(JavaType annotationType) {
        return this.getDeclaredAnnotation(annotationType);
    }

    public final boolean isDeprecated() {
        if (!this.isProcessed()) {
            this.resolve();
        }
        return (this.objectXaccess & '\u0001') != 0;
    }

    public final boolean isHidden() {
        if (!this.isProcessed()) {
            this.resolve();
        }
        return (this.objectXaccess & 0x2000) != 0;
    }

    public final boolean isProcessed() {
        return (this.objectFlags & '\u0001') != 0;
    }

    public final void setProcessed() {
        this.objectFlags = (char)(this.objectFlags | '\u0001');
    }

    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.objectFlags = '\u0000';
    }

    public Sym cloneSelf(FileSym targetFile) {
        ObjectSym sym = (ObjectSym)super.cloneSelf(targetFile);
        sym.objectXaccess = this.objectXaccess;
        sym.objectImplicit = this.objectImplicit;
        return sym;
    }

    protected void adjustSelfImpl(Sym other) {
        super.adjustSelfImpl(other);
        if (other instanceof ObjectSym) {
            ObjectSym otherSym = (ObjectSym)other;
            this.objectImplicit = otherSym.objectImplicit;
        }
    }
}

