/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.MethodObj;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.ThrowsClauseSym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.util.Conversions;

public class MethodSym
extends MemberSym
implements SourceMethod {
    public short methodXDimension;

    private void $init$() {
        this.methodXDimension = 0;
    }

    public int getElementKind() {
        return 8;
    }

    public boolean isConstructor() {
        return this.symKind == 6;
    }

    public List getSourceParameters() {
        FormalsSym formals = this.getFormalsSym();
        if (formals != null) {
            return formals.getSourceParameters();
        }
        return InternalConstants.kEmptyList;
    }

    public List getSourceExceptions() {
        ThrowsClauseSym throwsSym = this.getThrowsSym();
        if (throwsSym != null) {
            return throwsSym.getSourceExceptions();
        }
        return InternalConstants.kEmptyList;
    }

    public SourceTypeReference getSourceReturnType() {
        return this.getTypeSym();
    }

    public void setSourceReturnType(SourceTypeReference type) {
        if (this.isConstructor()) {
            MethodSym.unsupported("Constructor has no return type");
        }
        this.setTypeSym((TypeSym)type);
    }

    public String getName() {
        if (this.isConstructor()) {
            return "<init>";
        }
        return super.getName();
    }

    public SourceFormalParameterList getFormalParameterList() {
        return this.getFormalsSym();
    }

    public SourceThrowsClause getThrowsClause() {
        return this.getThrowsSym();
    }

    public FormalsSym getFormalsSym() {
        return (FormalsSym)this.getChildOrCreateSkeleton((byte)12);
    }

    public ThrowsClauseSym getThrowsSym() {
        return (ThrowsClauseSym)this.getChildOrCreateSkeleton((byte)24);
    }

    public Expr getDefaultValueSym() {
        return (Expr)this.getChild((byte)83);
    }

    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    public final JavaTypeVariable getTypeParameter(String name) {
        return CommonUtilities.getTypeParameter(this, name);
    }

    public JavaMethod getMethodErasure() {
        return this;
    }

    public JavaType getReturnType() {
        return this.getResolvedType();
    }

    public Collection getParameters() {
        JavaType grandClass;
        ClassSym owningClass;
        FormalsSym formalsSym = this.getFormalsSym();
        if (formalsSym == null) {
            return InternalConstants.kEmptyList;
        }
        List parameters = formalsSym.getParameters();
        if (this.isConstructor() && (owningClass = this.getOwningClassSym()) != null && (grandClass = MethodSym.getOuterClassOfNonstaticInner(owningClass)) != null) {
            ArrayList<QuickLocalVariable> adjustedParameters = new ArrayList<QuickLocalVariable>();
            QuickLocalVariable thisDollarZero = QuickLocalVariable.createLocalVariable(grandClass, "this$0");
            thisDollarZero.setOwner(this);
            adjustedParameters.add(thisDollarZero);
            adjustedParameters.addAll(parameters);
            return adjustedParameters;
        }
        return parameters;
    }

    public JavaType[] getParameterTypes() {
        return CommonUtilities.getParameterTypes(this);
    }

    public Collection getExceptions() {
        ThrowsClauseSym throwsSym = this.getThrowsSym();
        if (throwsSym != null) {
            return throwsSym.getExceptions();
        }
        return InternalConstants.kEmptyList;
    }

    public boolean hasSubsignatureOf(JavaMethod other) {
        return Conversions.hasSubsignatureOf(this, other);
    }

    public Collection getOverriddenMethods() {
        return this.getMethodObj().getOverriddenMethods();
    }

    public Object getDefaultValue() {
        Expr e = this.getDefaultValueSym();
        if (e != null) {
            return e.getConstantValue();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof JavaMethod) {
            return CommonUtilities.equals(this, (JavaMethod)o);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    public String printCompiledInfo() {
        return this.getUniqueIdentifier();
    }

    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 27: {
                return this.isConstructor() ^ true;
            }
            case 2: 
            case 12: 
            case 20: 
            case 24: 
            case 26: {
                return true;
            }
        }
        if (target.is((byte)83)) {
            return true;
        }
        return super.isValidChild(target, argument);
    }

    protected boolean isValidAccess(char access) {
        ClassSym classSym;
        int allowed = this.isConstructor() ? 135 : ((classSym = this.getOwningClassSym()) != null && classSym.isInterface() ? 1153 : 3583);
        return super.isValidAccess((char)(access & ~allowed));
    }

    protected void linkSelfTrigger(TreeSym parent, byte filter) {
        super.linkSelfTrigger(parent, filter);
        if (!this.isConstructor()) {
            return;
        }
        ClassSym classSym = this.getOwningClassSym();
        if (classSym != null) {
            String className = classSym.getName();
            String thisName = this.getName();
            if (!thisName.equals(className)) {
                this.setName(className);
            }
        }
    }

    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 26: {
                int typeIndex = this.indexOf((byte)27);
                if (typeIndex != -1) {
                    return typeIndex;
                }
            }
            case 27: {
                int nameIndex = this.indexOf((byte)20);
                if (nameIndex != -1) {
                    return nameIndex;
                }
            }
            case 20: {
                int formalsIndex = this.indexOf((byte)12);
                if (formalsIndex != -1) {
                    return formalsIndex;
                }
            }
            case 12: {
                int throwsIndex = this.indexOf((byte)24);
                if (throwsIndex != -1) {
                    return throwsIndex;
                }
            }
            case 24: {
                int blockIndex = this.indexOf((byte)2);
                if (blockIndex == -1) break;
                return blockIndex;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    public void buildSelf() {
        super.buildSelf();
        if (this.isVarargs()) {
            VariableSym variableSym = (VariableSym)this.getFormalsSym().getLastChild((byte)13);
            variableSym.symAccess = (char)(variableSym.symAccess | 0x80);
            TypeSym typeSym = variableSym.getTypeSym();
            if (typeSym != null) {
                typeSym.symAccess = (char)(typeSym.symAccess | 0x80);
            }
        }
        if (this.methodXDimension > 0) {
            TypeSym typeSym = this.getTypeSym();
            typeSym.typeXtraDimension = this.methodXDimension;
        }
    }

    public Sym cloneSelf(FileSym targetFile) {
        MethodSym sym = (MethodSym)super.cloneSelf(targetFile);
        sym.methodXDimension = this.methodXDimension;
        return sym;
    }

    protected void add(Sym child, byte filter) {
        FormalsSym formals;
        if (!this.isValidChild(child, filter) && (formals = this.getFormalsSym()).isValidChild(child, filter)) {
            formals.add(child, filter);
            return;
        }
        super.add(child, filter);
    }

    protected Sym createSkeleton(byte symKind) {
        Sym sym = super.createSkeleton(symKind);
        if (symKind == 12) {
            sym.symFlags = (byte)(sym.symFlags & 0xFFFFFFFB);
        }
        return sym;
    }

    protected void setupSkeleton() {
        this.getFormalsSym();
        this.getThrowsSym();
    }

    public MethodObj getMethodObj() {
        if (this.hasObjData()) {
            return (MethodObj)this.symData;
        }
        MethodObj methodObj = new MethodObj();
        methodObj.objSym = this;
        this.symData = methodObj;
        return methodObj;
    }

    protected JavaElement resolveImpl(CompilerDriver compiler) {
        compiler.resolve(this);
        return this;
    }

    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    public void print(PrintWriter out, int argument) {
        switch (argument) {
            default: {
                this.print_javadoc(out);
                this.print_annotations(out);
                this.print_modifiers(out);
                this.print_ty_parameters(out);
                if (this.symKind != 6) {
                    MethodSym.print(this.getTypeSym(), out, argument);
                    out.print(' ');
                }
                MethodSym.print(this.getNameSym(), out, argument);
                this.getFormalsSym().print_signature(out, true);
                MethodSym.print(this.getThrowsSym(), out);
                SourceBlock block = this.getBlock();
                if (block != null) {
                    block.print(out, argument);
                    break;
                }
                out.println(';');
                break;
            }
            case 1: {
                MethodSym.print(this.getNameSym(), out, argument);
                this.getFormalsSym().print_signature(out, false);
                break;
            }
            case 2: {
                this.print_modifiers(out);
                this.print_ty_parameters(out);
                if (this.symKind != 6) {
                    MethodSym.print(this.getTypeSym(), out, argument);
                    out.print(' ');
                }
                MethodSym.print(this.getNameSym(), out, argument);
                this.getFormalsSym().print_signature(out, true);
                MethodSym.print(this.getThrowsSym(), out);
                break;
            }
        }
    }

    public MethodSym() {
        this.$init$();
    }
}

