/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.internal.compiler.ClassObj;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.InterfacesSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.SuperClauseSym;
import oracle.javatools.parser.java.v2.internal.symbol.SuperclassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.util.Conversions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassSym
extends MemberSym
implements SourceClass {
    public TypeSym tySuper;

    private void $init$() {
        this.symFlags = (byte)(this.symFlags | 1);
    }

    @Override
    public int getTypeKind() {
        return ClassSym.access2ty(this.symAccess);
    }

    @Override
    public void setTypeKind(int tyk) {
        char access = this.symAccess;
        access = (char)(access & 0xFFFF9DFF);
        access = (char)(access | ClassSym.ty2access((byte)tyk));
        this.setAccess(access);
    }

    @Override
    public boolean isClass() {
        return this.isInterface() ^ true;
    }

    @Override
    public boolean isInterface() {
        return (this.symAccess & 0x200) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.symAccess & 0x4000) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.symAccess & 0x2000) != 0;
    }

    @Override
    public boolean isExported() {
        Sym parentSym = this.getParentSym();
        if (parentSym != null) {
            switch (parentSym.symKind) {
                case 4: 
                case 11: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isMemberClass() {
        Sym parentSym = this.getParentSym();
        if (parentSym != null) {
            return parentSym.symKind == 4;
        }
        return false;
    }

    @Override
    public boolean isInnerClass() {
        return this.isMemberClass();
    }

    public final boolean flag_anonymous() {
        return this.testSymFlag((byte)-128);
    }

    @Override
    public boolean isAnonymous() {
        return this.flag_anonymous();
    }

    @Override
    public String getUnqualifiedName() {
        return this.getName();
    }

    @Override
    public String getQualifiedName() {
        String ownerName;
        String thisName = this.getName();
        ClassSym owningClass = this.getOwningClassSym();
        if (owningClass != null && (ownerName = owningClass.getQualifiedName()).length() > 0) {
            return ownerName + '.' + thisName;
        }
        String packageName = this.getPackageName();
        if (packageName.length() == 0) {
            return thisName;
        }
        return packageName + '.' + thisName;
    }

    @Override
    public String getVMName() {
        String ownerVMName;
        int length;
        String thisName = this.getName();
        ClassSym owningClass = this.getOwningClassSym();
        if (owningClass != null && (length = (ownerVMName = owningClass.getVMName()).length()) > 0) {
            return ownerVMName + '$' + thisName;
        }
        String packageName = this.getPackageName();
        if (packageName.length() == 0) {
            return thisName;
        }
        return packageName.replace('.', '/') + '/' + thisName;
    }

    @Override
    public String getRawName() {
        return this.getQualifiedName();
    }

    public String getSourceName() {
        return this.getQualifiedName();
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public SourcePackage getSourcePackage() {
        return this.symFile.getSourcePackage();
    }

    @Override
    public String getPackageName() {
        SourcePackage packageSym = this.symFile.getSourcePackage();
        if (packageSym != null) {
            return packageSym.getName();
        }
        return "";
    }

    @Override
    public SourceTypeReference getSourceSuperclass() {
        SuperclassSym superSym = this.getSuperclassSym();
        if (superSym != null) {
            return superSym.getSourceSuperclass();
        }
        return null;
    }

    @Override
    public void setSourceSuperclass(SourceTypeReference type) {
        this.getSuperclassSym().setSourceSuperclass(type);
    }

    @Override
    public List getSourceInterfaces() {
        return this.getInterfacesSym().getSourceInterfaces();
    }

    @Override
    public List getSourceMembers() {
        return this.getBodySym().getSourceMembers();
    }

    @Override
    public Collection getSourceMemberVariables() {
        return this.getBodySym().getSourceMemberVariables();
    }

    @Override
    public SourceMemberVariable getSourceMemberVariable(String name) {
        return this.getBodySym().getSourceMemberVariable(name);
    }

    @Override
    public List getSourceEnumConstants() {
        return this.getBodySym().getSourceEnumConstants();
    }

    @Override
    public List getSourceFieldDeclarations() {
        return this.getBodySym().getSourceFieldDeclarations();
    }

    @Override
    public Collection getSourceFieldVariables() {
        return this.getBodySym().getSourceFieldVariables();
    }

    @Override
    public SourceFieldVariable getSourceFieldVariable(String name) {
        return this.getBodySym().getSourceFieldVariable(name);
    }

    @Override
    public List getSourceMethods() {
        return this.getBodySym().getSourceMethods();
    }

    @Override
    public Collection getSourceMethods(String name) {
        return this.getBodySym().getSourceMethods(name);
    }

    @Override
    public SourceMethod getSourceMethod(String name, JavaType[] targetTypes) {
        JavaMethod target = this.getDeclaredMethod(name, targetTypes);
        if (target != null) {
            return (SourceMethod)target.getSourceElement();
        }
        return null;
    }

    @Override
    public List getSourceConstructors() {
        return this.getBodySym().getSourceConstructors();
    }

    @Override
    public SourceMethod getSourceConstructor(JavaType[] targetTypes) {
        JavaMethod target = this.getDeclaredConstructor(targetTypes);
        if (target != null) {
            return (SourceMethod)target.getSourceElement();
        }
        return null;
    }

    @Override
    public List getSourceClasses() {
        return this.getBodySym().getSourceClasses();
    }

    @Override
    public SourceClass getSourceClass(String name) {
        return this.getBodySym().getSourceClass(name);
    }

    @Override
    public List getSourceInitializers() {
        return this.getBodySym().getSourceInitializers();
    }

    @Override
    public SourceClassBody getSourceBody() {
        return this.getBodySym();
    }

    public SourceClassBody getBody() {
        return this.getSourceBody();
    }

    public ClassBodySym getBodySym() {
        return (ClassBodySym)this.getChild((byte)4);
    }

    @Override
    public SourceSuperclassClause getSuperclassClause() {
        return this.getSuperclassSym();
    }

    @Override
    public SourceInterfacesClause getInterfacesClause() {
        return this.getInterfacesSym();
    }

    public SuperclassSym getSuperclassSym() {
        return (SuperclassSym)this.getChildOrCreateSkeleton((byte)22);
    }

    public InterfacesSym getInterfacesSym() {
        return (InterfacesSym)this.getChildOrCreateSkeleton((byte)15);
    }

    public SuperClauseSym getSuperSym() {
        String message = "Deprecated. Get the superclass or the interfaces clause instead!";
        throw new UnsupportedOperationException("Deprecated. Get the superclass or the interfaces clause instead!");
    }

    @Override
    public int getElementKind() {
        return 3;
    }

    @Override
    public URL getURL() {
        return this.symFile.getURL();
    }

    @Override
    public final JavaClass getClosestClass() {
        return this.getTypeErasure();
    }

    @Override
    public final JavaClass getTypeErasure() {
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public JavaType getComponentType() {
        return null;
    }

    @Override
    public int getArrayDimensions() {
        return 0;
    }

    @Override
    public JavaType getBaseComponentType() {
        return null;
    }

    @Override
    public SourceMember getOwningMember() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.is((byte)79)) {
                return (SourceMember)((Object)sym);
            }
            sym = sym.symParent;
        }
        return null;
    }

    @Override
    public JavaPackage getPackage() {
        JavaProvider provider = this.symFile.getProvider();
        if (provider == null) {
            return null;
        }
        String packageString = this.getPackageName();
        return provider.getPackage(packageString);
    }

    @Override
    public JavaType getResolvedType() {
        return this;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        return QuickUnresolvedType.createUnresolvedType(this);
    }

    @Override
    public JavaType getSuperclass() {
        ClassObj obj = this.getClassObj();
        if (!obj.isResolved()) {
            this.resolve();
        }
        return obj.getSuperclass();
    }

    @Override
    public Collection getInterfaces() {
        JavaType resolved;
        if (this.tySuper != null && (resolved = this.tySuper.getResolvedType()) != null && resolved.getElementKind() == 3 && resolved.isInterface()) {
            return Arrays.asList(resolved);
        }
        InterfacesSym interfacesSym = this.getInterfacesSym();
        return interfacesSym.getInterfaces();
    }

    @Override
    public Set getHierarchy() {
        return this.getClassObj().getHierarchy();
    }

    @Override
    public boolean isAssignableFrom(JavaType subject) {
        return Conversions.applyAssignmentConversion(subject, this, false, null);
    }

    @Override
    public boolean isSubtypeOf(JavaType supertype) {
        return Conversions.isSubtypeOf(this, supertype);
    }

    @Override
    public Collection getDeclaredFields() {
        return this.getBodySym().getSourceMemberVariables();
    }

    @Override
    public JavaField getDeclaredField(String name) {
        return CommonUtilities.getDeclaredField(this, name);
    }

    @Override
    public Collection getDeclaredMethods() {
        return this.getBodySym().getDeclaredMethods();
    }

    @Override
    public Collection getDeclaredMethods(String name) {
        return CommonUtilities.getDeclaredMethods(this, name);
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaType[] targetTypes) {
        return CommonUtilities.getDeclaredMethod(this, name, targetTypes);
    }

    @Override
    public Collection getDeclaredConstructors() {
        return this.getBodySym().getDeclaredConstructors();
    }

    @Override
    public JavaMethod getDeclaredConstructor(JavaType[] targetTypes) {
        return CommonUtilities.getDeclaredConstructor(this, targetTypes);
    }

    @Override
    public JavaMethod getClinitMethod() {
        ClassObj obj = this.getClassObj();
        if (!obj.isResolved()) {
            this.resolve();
        }
        return obj.getClinitMethod();
    }

    @Override
    public JavaClass getDeclaredClass(String name) {
        return CommonUtilities.getDeclaredClass(this, name);
    }

    @Override
    public Collection getDeclaredClasses() {
        return this.getBodySym().getDeclaredClasses();
    }

    @Override
    public final JavaTypeVariable getTypeParameter(String name) {
        return CommonUtilities.getTypeParameter(this, name);
    }

    @Override
    public Collection getFields() {
        return CommonUtilities.getFields(this);
    }

    @Override
    public JavaField getField(String name) {
        return CommonUtilities.getField(this, name);
    }

    @Override
    public Collection getMethods() {
        return CommonUtilities.getMethods(this);
    }

    @Override
    public Collection getMethods(String name) {
        return CommonUtilities.getMethods(this, name);
    }

    @Override
    public JavaMethod getMethod(String name, JavaType[] targetTypes) {
        return CommonUtilities.getMethod(this, name, targetTypes);
    }

    @Override
    public Collection getClasses() {
        return CommonUtilities.getClasses(this);
    }

    @Override
    public JavaClass getClass(String name) {
        return CommonUtilities.getClass(this, name);
    }

    @Override
    public final Collection getAnnotations() {
        return CommonUtilities.getAnnotations(this);
    }

    @Override
    public final JavaAnnotation getAnnotation(JavaType annotationType) {
        return CommonUtilities.getAnnotation(this, annotationType);
    }

    @Override
    public CompiledTmpVariable getThisValue() {
        return this.getClassObj().getThisValue();
    }

    public JavaVariable getThisVariable() {
        return this.getClassObj().getThisVariable();
    }

    public JavaVariable getSuperVariable() {
        return this.getClassObj().getSuperVariable();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JavaType) {
            return CommonUtilities.equals(this, (JavaType)o);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    @Override
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        if (this.tySuper != null) {
            this.tySuper.clearCompiledInfo();
        }
    }

    @Override
    public String printCompiledInfo() {
        return super.printCompiledInfo() + this.getDescriptor();
    }

    @Override
    protected void add(Sym child, byte filter) {
        ClassBodySym body;
        if (!this.isValidChild(child, filter) && (body = this.getBodySym()).isValidChild(child, filter)) {
            body.add(child, filter);
            return;
        }
        super.add(child, filter);
    }

    @Override
    protected Sym createSkeleton(byte symKind) {
        Sym sym = super.createSkeleton(symKind);
        if (symKind == 4) {
            sym.symFlags = (byte)(sym.symFlags & 0xFFFFFFFB);
        }
        return sym;
    }

    @Override
    protected void setupSkeleton() {
        Sym bodySym = this.getChildOrCreateSkeleton((byte)4);
        bodySym.buildSelf();
        this.getSuperclassClause();
        this.getInterfacesClause();
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 20: {
                int typeParameterIndex = this.indexOf((byte)26);
                if (typeParameterIndex != -1) {
                    return typeParameterIndex;
                }
            }
            case 26: {
                int superIndex = this.indexOf((byte)22);
                if (superIndex != -1) {
                    return superIndex;
                }
            }
            case 22: {
                int interfacesIndex = this.indexOf((byte)15);
                if (interfacesIndex != -1) {
                    return interfacesIndex;
                }
            }
            case 15: {
                int bodyIndex = this.indexOf((byte)4);
                if (bodyIndex == -1) break;
                return bodyIndex;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 4: 
            case 15: 
            case 20: 
            case 22: 
            case 26: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }

    @Override
    protected boolean isValidAccess(char access) {
        if (this.isAnonymous()) {
            return access == '\u0000';
        }
        int allowed = 10241;
        allowed = (access & 0x200) != 0 ? (int)((char)(allowed | 0x608)) : ((access & 0x4000) != 0 ? (int)((char)(allowed | 0x4010)) : (int)((char)(allowed | 0x418)));
        ClassSym owningSym = this.getOwningClassSym();
        if (owningSym != null) {
            if (!owningSym.isInterface()) {
                allowed = (char)(allowed | 6);
            }
        } else {
            allowed = (char)(allowed & 0xFFFFFFF7);
        }
        return super.isValidAccess((char)(access & ~allowed));
    }

    @Override
    protected void setAccess(char access) {
        char oldAccess = this.symAccess;
        if (access == oldAccess) {
            return;
        }
        byte savedTyk = ClassSym.access2ty(oldAccess);
        byte newTyk = ClassSym.access2ty(access);
        this.setAccessImpl(access);
        if (savedTyk != newTyk) {
            switch (newTyk) {
                case 0: {
                    this.objectImplicit = '\u0000';
                    break;
                }
                case 3: {
                    this.objectImplicit = (char)9728;
                    break;
                }
                case 2: {
                    this.objectImplicit = (char)16384;
                    break;
                }
                case 1: {
                    this.objectImplicit = (char)1536;
                    break;
                }
            }
        }
        this.setAccessTrigger(oldAccess);
    }

    @Override
    protected void setNameTrigger(String newValue) {
        super.setNameTrigger(newValue);
        for (SourceMethod method : this.getSourceConstructors()) {
            if (!method.isConstructor()) continue;
            method.setName(newValue);
        }
    }

    @Override
    protected void linkSelfTrigger(TreeSym parent, byte filter) {
        ClassBodySym bodySym = this.getBodySym();
        if (bodySym != null) {
            bodySym.buildDefaultConstructor();
        }
        super.linkSelfTrigger(parent, filter);
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        super.linkChildTrigger(added, filter);
        if (added.symKind == 4) {
            added.buildSelf();
            this.buildSelf();
        }
    }

    @Override
    public void buildSelf() {
        super.buildSelf();
        ClassBodySym bodySym = this.getBodySym();
        bodySym.buildEnumMethods(this);
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        ClassSym sym = (ClassSym)super.cloneSelf(targetFile);
        if (this.tySuper != null) {
            sym.tySuper = (TypeSym)this.tySuper.cloneSelf(targetFile);
        }
        return sym;
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (compiler.inUsageMode()) {
            JavaElement result = super.compileImpl(compiler);
            compiler.compile(this);
            return result;
        }
        this.resolveImpl(compiler);
        for (Sym sym : this.getSourceClasses()) {
            sym.resolve(compiler);
        }
        JavaElement result = super.compileImpl(compiler);
        compiler.compile(this);
        return result;
    }

    @Override
    public JavaElement resolveImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    public ClassObj getClassObj() {
        if (this.hasObjData()) {
            return (ClassObj)this.symData;
        }
        ClassObj classObj = new ClassObj();
        classObj.objSym = this;
        this.symData = classObj;
        return classObj;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int argument) {
        switch (argument) {
            default: {
                this.print_javadoc(out);
            }
            case 2: {
                this.print_annotations(out);
                this.print_modifiers(out);
                out.print(JavaConstants.TY_words[ClassSym.access2ty(this.symAccess)]);
                out.print(' ');
            }
            case 1: 
        }
        ClassSym.print(this.getNameSym(), out);
        switch (argument) {
            default: {
                this.print_ty_parameters(out);
                ClassSym.print(this.getSuperclassSym(), out);
                ClassSym.print(this.getInterfacesSym(), out);
                out.println();
                ClassSym.print(this.getBodySym(), out);
                out.println();
                break;
            }
            case 1: {
                this.print_ty_parameters(out, 1);
                break;
            }
            case 2: {
                this.print_ty_parameters(out);
                break;
            }
        }
    }

    @Override
    public Collection<UnresolvedType> getUnresolvedInterfaces() {
        ArrayList<UnresolvedType> list = new ArrayList<UnresolvedType>();
        List sourceInterfaces = this.getSourceInterfaces();
        for (SourceTypeReference ref : sourceInterfaces) {
            list.add(ref.getUnresolvedType());
        }
        return list.isEmpty() ? Collections.EMPTY_LIST : list;
    }

    public ClassSym() {
        this.$init$();
    }
}

