/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymData;
import oracle.javatools.parser.java.v2.internal.symbol.WhitespaceSym;

public class SyntaxData
extends SymData
implements InternalConstants {
    public short stackDepth;
    public boolean flag_noProcess;
    public boolean flag_repushed;
    public Sym[] kids;
    public int kidCount;
    public WhitespaceSym precedingWhitespace;

    private void $init$() {
        this.stackDepth = 0;
        this.flag_noProcess = false;
        this.flag_repushed = false;
        this.kids = Sym.EMPTY_ARRAY;
        this.kidCount = 0;
        this.precedingWhitespace = null;
    }

    public int getBindingType() {
        return 1;
    }

    public Sym getChild(int sy) {
        int i = 0;
        while (i < this.kidCount) {
            Sym child = this.kids[i];
            if (child.symKind == sy) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public void addKid(Sym kid) {
        if (kid == null) {
            return;
        }
        this.ensureCapacity(this.kidCount + 1);
        this.kids[this.kidCount++] = kid;
    }

    public void addKids(Sym[] input) {
        int count = input.length;
        if (count == 0) {
            return;
        }
        this.ensureCapacity(this.kidCount + count);
        int i = 0;
        while (i < count) {
            this.kids[this.kidCount++] = input[i];
            ++i;
        }
    }

    private void ensureCapacity(int targetCount) {
        if (targetCount <= this.kids.length) {
            return;
        }
        int kidCount = this.kidCount;
        int newCount = kidCount == 0 ? 2 : kidCount * 2;
        while (newCount < targetCount) {
            newCount *= 2;
        }
        Sym[] newArray = new Sym[newCount];
        Sym[] oldArray = this.kids;
        if (kidCount != 0) {
            System.arraycopy(oldArray, 0, newArray, 0, kidCount);
        }
        this.kids = newArray;
    }

    public void sortKids() {
        if (this.kidCount < 2) {
            return;
        }
        ArrayList<Sym> list = new ArrayList<Sym>();
        int i = 0;
        while (i < this.kidCount) {
            list.add(this.kids[i]);
            ++i;
        }
        Collections.sort(list);
        Iterator iterator = list.iterator();
        Sym lastSym = null;
        while (iterator.hasNext()) {
            Sym currentSym = (Sym)iterator.next();
            if (lastSym != null && lastSym.compareTo(currentSym) == 0) {
                iterator.remove();
            }
            lastSym = currentSym;
        }
    }

    public SyntaxData() {
        this.$init$();
    }
}

