/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import oracle.javatools.parser.java.v2.internal.format.BufferedEmitter;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;

final class LineWrappingEmitter
extends BufferedEmitter {
    int resetCounter;
    private int zeroIndex;
    private int[] wrapColumns;
    private int[] columnAdjusts;
    private int wrapCount;
    private int totalAdjust;
    private short wrapLineWidth;
    private int lastWrapBoundary;
    private int lastWrapBoundaryAlign;
    private int lastWrapBoundaryHeight;

    private void $init$() {
        this.resetCounter = 0;
        this.zeroIndex = 0;
        this.wrapColumns = new int[2];
        this.columnAdjusts = new int[2];
        this.wrapCount = 0;
        this.totalAdjust = 0;
        this.wrapLineWidth = (short)76;
    }

    void init(Sym s) {
        super.init(s);
        int width = this.formatter.preferences.getInt(50);
        this.wrapLineWidth = LineWrappingEmitter.int2unsignedShort(width);
        this.wrapCount = 0;
        this.totalAdjust = 0;
        this.resetCounter = 0;
        this.lastWrapBoundary = -1;
        this.lastWrapBoundaryAlign = -1;
        this.lastWrapBoundaryHeight = -1;
    }

    boolean isWrapCapable() {
        return true;
    }

    int getColumn() {
        int length = this.buffer.length();
        return length - this.zeroIndex - this.totalAdjust;
    }

    int getColumnStamp() {
        return this.resetCounter;
    }

    int getColumn_forIndentationUse() {
        return this.unadjusted2indent(this.getColumn());
    }

    private void beforeNewline() {
        this.performLineWrapping();
    }

    private void afterNewline() {
        ++this.resetCounter;
        this.wrapCount = 0;
        this.totalAdjust = 0;
        this.zeroIndex = LineWrappingEmitter.lastIndexOfNewline(this.buffer) + 1;
        this.clearWrapBoundary();
    }

    final void clearWrapBoundary() {
        this.lastWrapBoundary = -1;
        this.lastWrapBoundaryAlign = -1;
        this.lastWrapBoundaryHeight = -1;
    }

    private int adjust(int unadjusted) {
        int column = unadjusted;
        int i = 0;
        while (i < this.wrapCount) {
            if (this.wrapColumns[i] > unadjusted) break;
            column += this.columnAdjusts[i];
            ++i;
        }
        return column;
    }

    private int unadjusted2indent(int unadjusted) {
        int distance;
        int adjustedColumn = this.adjust(unadjusted);
        int adjustedIndex = adjustedColumn + this.zeroIndex;
        int lastNewline = LineWrappingEmitter.lastIndexOfNewline(this.buffer, adjustedIndex);
        int firstChar = lastNewline + 1;
        int indent = distance = adjustedIndex - firstChar;
        if (this.buffer.length() <= firstChar) {
            return indent;
        }
        int i = 0;
        while (i < distance) {
            char ch = this.buffer.charAt(lastNewline + 1 + i);
            if (ch != '\t') break;
            indent += this.tabSize - 1;
            ++i;
        }
        return indent;
    }

    void markWrapBoundary(int height) {
        int a = this.lastWrapBoundaryHeight;
        if (a >= 0) {
            if (this.shouldLineWrap()) {
                this.performLineWrapping();
            } else {
                int b = height;
                if (b > a) {
                    return;
                }
            }
        }
        this.lastWrapBoundary = this.getColumn();
        this.lastWrapBoundaryAlign = this.formatter.getIndent();
        this.lastWrapBoundaryHeight = height;
    }

    private boolean shouldLineWrap() {
        if (this.lastWrapBoundary == -1) {
            return false;
        }
        int lineZero = LineWrappingEmitter.lastIndexOfNewline(this.buffer) + 1;
        int lineColumn = this.buffer.length() - lineZero;
        return this.wrapLineWidth <= lineColumn;
    }

    void forceLineWrapping() {
        this.performLineWrappingImpl(this.buffer.length(), this.formatter.getIndent());
    }

    private void performLineWrapping() {
        int charCount;
        if (this.lastWrapBoundary == -1) {
            return;
        }
        int lineZero = LineWrappingEmitter.lastIndexOfNewline(this.buffer) + 1;
        int lineLength = charCount = this.buffer.length() - lineZero;
        int i = 0;
        while (i < charCount) {
            char ch = this.buffer.charAt(lineZero + i);
            if (ch == '\t') {
                lineLength += this.tabSize - 1;
            }
            ++i;
        }
        if (this.wrapLineWidth <= lineLength) {
            int adjustedBoundary;
            int length = this.buffer.length();
            int target = adjustedBoundary = this.adjust(this.lastWrapBoundary) + this.zeroIndex;
            while (target < length && Character.isWhitespace(this.buffer.charAt(target))) {
                ++target;
            }
            if (target < length) {
                this.performLineWrappingImpl(target, this.lastWrapBoundaryAlign);
            }
        }
    }

    private void performLineWrappingImpl(int target, int indentValue) {
        String saved = this.buffer.substring(target);
        this.buffer.setLength(target);
        int wrapColumn = this.getColumn();
        super.emit('\n');
        this.emitIndent(indentValue);
        int thisAdjust = this.buffer.length() - target;
        if (saved.length() > 0) {
            super.emit(saved);
        }
        if (this.wrapColumns.length <= this.wrapCount) {
            int[] newColumns = new int[this.wrapCount * 2];
            System.arraycopy(this.wrapColumns, 0, newColumns, 0, this.wrapCount);
            this.wrapColumns = newColumns;
            int[] newAdjusts = new int[this.wrapCount * 2];
            System.arraycopy(this.columnAdjusts, 0, newAdjusts, 0, this.wrapCount);
            this.columnAdjusts = newAdjusts;
        }
        this.wrapColumns[this.wrapCount] = wrapColumn;
        this.columnAdjusts[this.wrapCount] = thisAdjust;
        ++this.wrapCount;
        this.totalAdjust += thisAdjust;
    }

    void emitIndent(int column) {
        int indent = this.unadjusted2indent(column);
        this.emitIndentImpl(indent, this.formatter.flag_docindent);
    }

    void emit(String s) {
        boolean newline;
        boolean bl = newline = s.indexOf(10) >= 0;
        if (newline) {
            this.beforeNewline();
        }
        super.emit(s);
        if (newline) {
            this.afterNewline();
        }
    }

    void emit(char ch) {
        boolean newline;
        boolean bl = newline = ch == '\n';
        if (newline) {
            this.beforeNewline();
        }
        super.emit(ch);
        if (newline) {
            this.afterNewline();
        }
    }

    public static int lastIndexOfNewline(StringBuffer b) {
        int lf = b.lastIndexOf("\n");
        if (lf >= 0) {
            return lf;
        }
        return b.lastIndexOf("\r");
    }

    public static int lastIndexOfNewline(StringBuffer b, int fromIndex) {
        int lf = b.lastIndexOf("\n", fromIndex);
        if (lf >= 0) {
            return lf;
        }
        int cr = b.lastIndexOf("\r", fromIndex);
        if (cr >= 0) {
            if (cr + 1 < b.length() && b.charAt(cr + 1) == '\n') {
                return LineWrappingEmitter.lastIndexOfNewline(b, cr - 1);
            }
            return cr;
        }
        return -1;
    }

    LineWrappingEmitter() {
        this.$init$();
    }
}

