/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.util.IdentityHashMap;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.BlanklineSym;
import oracle.javatools.parser.java.v2.internal.symbol.CommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.SqljSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.WhitespaceSym;
import oracle.javatools.parser.java.v2.scanner.TokenArray;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

abstract class FormatLayer1
extends FormatUtilities {
    private short stackTop;
    private int enterDepth;
    private FormatInfo[] stack;
    private short lastToken;
    TokenArray tokens;
    SourcePreferences preferences;
    Emitter emitter;
    private IdentityHashMap handledWhitespace;
    private int newlinesPending;
    private int newlinesEmitted;
    private int blanklineSyms;
    private boolean flag_space;
    private boolean flag_init;
    boolean flag_justindent;
    boolean flag_docindent;
    boolean flag_lessindentonce;
    private int indentNumSpaces;
    private boolean wrapAlign;
    private int alignmentMark_height;
    private int markBoundary_height;

    private void $init$() {
        this.stackTop = 0;
        this.enterDepth = 0;
        this.stack = new FormatInfo[]{new FormatInfo(null), new FormatInfo(null)};
        this.lastToken = 0;
        this.newlinesPending = 0;
        this.newlinesEmitted = 0;
        this.blanklineSyms = 0;
        this.flag_space = false;
        this.flag_init = false;
        this.flag_justindent = false;
        this.flag_docindent = false;
        this.flag_lessindentonce = false;
        this.indentNumSpaces = 0;
        this.wrapAlign = true;
        this.alignmentMark_height = -1;
        this.markBoundary_height = -1;
    }

    public void init(Sym s) {
        if (this.flag_init) {
            FormatLayer1.panic("Traversal already in progress");
        }
        this.stackTop = 0;
        this.enterDepth = 0;
        this.lastToken = 0;
        this.newlinesPending = 0;
        this.newlinesEmitted = 1;
        this.handledWhitespace = new IdentityHashMap(this.tokens.tokenCount);
        this.flag_justindent = false;
        this.flag_docindent = false;
        this.flag_lessindentonce = false;
        this.alignmentMark_height = -1;
        this.markBoundary_height = -1;
        this.indentNumSpaces = this.preferences.getInt(0);
        if (this.indentNumSpaces < 0) {
            this.indentNumSpaces = 0;
        }
        try {
            this.emitter.init(s);
        }
        finally {
            this.flag_init = true;
        }
        this.wrapAlign = this.preferences.getBoolean(51);
    }

    public void fini(Sym s) {
        if (!this.flag_init) {
            FormatLayer1.panic("No traversal in progress");
        }
        this.flush();
        try {
            this.emitter.fini(s);
        }
        finally {
            this.flag_init = false;
        }
    }

    protected final int newlines() {
        return this.newlinesPending + this.newlinesEmitted;
    }

    public final void print(Sym sym) {
        FormatLayer1.panic();
    }

    final void print(TreeSym sym) {
        int count = sym.treeChildren.length;
        int i = 0;
        while (i < count) {
            Sym child = sym.treeChildren[i];
            this.handle(child);
            ++i;
        }
    }

    public final void print(NameSym sym) {
        this.print(sym.getText());
    }

    public final void print(SqljSym sym) {
        this.print(sym.getText());
        this.ensureNewlines(1);
    }

    public final void print(CommentSym sym) {
        if (sym.flag_lineStart()) {
            this.ensureNewlines(1);
            this.flushNewlines(1);
        }
        int savedUnflushed = this.newlinesPending;
        try {
            this.newlinesPending = 0;
            if (this.newlines() == 0 && !this.flag_justindent) {
                this.flag_space = true;
            }
            this.print(sym.getText());
        }
        finally {
            this.newlinesPending = savedUnflushed;
        }
        if (sym.tokenValue == 24 || sym.flag_lineEnd()) {
            this.ensureNewlines(1);
            this.flushNewlines(1);
        }
    }

    public final void print(BlanklineSym sym) {
        int blanklinePreserveCount = this.preferences.getInt(7);
        ++this.blanklineSyms;
        if (this.blanklineSyms > blanklinePreserveCount) {
            this.blanklineSyms = blanklinePreserveCount;
        }
        if (this.blanklineSyms > 0) {
            this.ensureNewlines(this.blanklineSyms + 1);
            this.flushNewlines(this.blanklineSyms + 1);
        }
    }

    public final void enter(Sym s) {
        TreeSym parentSym;
        int previousIndex;
        if (this.enterDepth > 0 && (previousIndex = s.symSiblingIndex - 1) >= 0 && (parentSym = (TreeSym)s.symParent) != null) {
            Sym sibling;
            if (parentSym.treeChildren.length <= previousIndex) {
                FormatLayer1.panic();
            }
            if ((sibling = parentSym.treeChildren[previousIndex]).is((byte)88)) {
                this.handle(sibling);
            }
        }
        if (this.flag_docindent) {
            this.checkIndent();
        }
        if (s.symKind != 11) {
            ++this.enterDepth;
        }
        if ((s.symFormat & 4) != 0) {
            this.flush();
        }
        this.emitter.enter(s);
    }

    public final void leave(Sym s) {
        if (this.enterDepth > 0 && s instanceof TreeSym) {
            TreeSym ts = (TreeSym)s;
            int count = ts.treeChildren.length;
            if (count > 0) {
                Sym last = ts.treeChildren[count - 1];
                if (last.symKind == 69) {
                    this.handle(last);
                }
            }
        }
        int symEnd = s.getEndIndex();
        if (s.symKind != 11) {
            --this.enterDepth;
        }
        this.emitter.leave(s);
    }

    private void handleImpl(Sym s) {
        if (s instanceof WhitespaceSym) {
            if (this.handledWhitespace.containsKey(s)) {
                return;
            }
            this.handledWhitespace.put(s, null);
        }
        s.print((FormatDriver)this);
    }

    final void handle(Sym s) {
        if (s == null) {
            return;
        }
        if (s.isSynthetic()) {
            return;
        }
        int id = this.push();
        try {
            this.handleImpl(s);
        }
        finally {
            this.pop(id);
        }
    }

    final void handle(Sym s, byte decoration) {
        if (s == null) {
            return;
        }
        int id = this.push(decoration);
        try {
            switch (decoration) {
                case 1: {
                    if (s.symKind == 29) {
                        boolean newlineBlockBraces = this.preferences.getBoolean(23);
                        if (!newlineBlockBraces) break;
                        boolean indentControlBlocks = this.preferences.getBoolean(5);
                        if (indentControlBlocks) {
                            this.indent(1);
                        }
                        this.ensureNewlines(1);
                        break;
                    }
                    this.indent(1);
                    this.println();
                    break;
                }
                case 3: {
                    this.indent(1);
                    break;
                }
            }
            this.handleImpl(s);
        }
        finally {
            this.pop(id);
        }
    }

    final void handleComment(Sym s) {
        TreeSym parentSym;
        int previousIndex = s.symSiblingIndex - 1;
        if (previousIndex >= 0 && (parentSym = (TreeSym)s.symParent) != null) {
            Sym sibling;
            if (parentSym.treeChildren.length <= previousIndex) {
                FormatLayer1.panic();
            }
            if ((sibling = parentSym.treeChildren[previousIndex]).is((byte)88)) {
                this.handle(sibling);
            }
        }
    }

    final void indent(int increment) {
        int newIndent = FormatInfo.ra$indent(this.stack[this.stackTop]) + increment * this.indentNumSpaces;
        if (newIndent < 0) {
            newIndent = 0;
        } else if (newIndent > 127) {
            newIndent = 127;
        }
        FormatInfo.wa$indent(this.stack[this.stackTop], (byte)newIndent);
    }

    final int getIndent() {
        int alignment;
        if (FormatInfo.ra$alignmentStamp(this.stack[this.stackTop]) == this.emitter.getColumnStamp() && (alignment = FormatInfo.ra$alignment(this.stack[this.stackTop])) > 0) {
            return alignment;
        }
        byte indent = FormatInfo.ra$indent(this.stack[this.stackTop]);
        if (!this.flag_lessindentonce) {
            return indent;
        }
        return indent - this.indentNumSpaces;
    }

    final int push() {
        return this.push((byte)0);
    }

    private int push(byte decoration) {
        if (this.stack.length == this.stackTop + 1) {
            FormatInfo[] newStack = new FormatInfo[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        short s = this.stackTop;
        this.stackTop = (short)(s + 1);
        short height = s;
        if (this.stack[this.stackTop] == null) {
            this.stack[this.stackTop] = new FormatInfo(null);
        }
        FormatInfo info = this.stack[this.stackTop];
        FormatInfo.wa$decoration(info, decoration);
        FormatInfo.wa$indent(info, FormatInfo.ra$indent(this.stack[height]));
        FormatInfo.wa$alignment(info, FormatInfo.ra$alignment(this.stack[height]));
        FormatInfo.wa$alignmentStamp(info, FormatInfo.ra$alignmentStamp(this.stack[height]));
        FormatInfo.wa$saved_alignmentMark_height(info, -1);
        return height;
    }

    final void pop(int height) {
        if (height < 0 || this.stackTop < height) {
            FormatLayer1.panic();
        }
        this.stackTop = (short)height;
        if (this.stackTop < 0) {
            FormatLayer1.panic();
        }
    }

    final void markWrapAlignment() {
        if (!this.wrapAlign) {
            return;
        }
        if (0 <= this.alignmentMark_height && this.alignmentMark_height < this.stackTop) {
            FormatInfo.wa$saved_alignmentMark_height(this.stack[this.stackTop], this.alignmentMark_height);
        }
        this.alignmentMark_height = this.stackTop;
    }

    final void markWrapBoundary(int wrap) {
        int tri = this.preferences.getInt(wrap);
        if (tri == 0) {
            return;
        }
        if (tri != 2) {
            this.markBoundary_height = this.stackTop;
        } else {
            this.emitter.forceLineWrapping();
            this.flag_justindent = true;
        }
    }

    final void println(short tk) {
        this.print(tk);
        this.println();
    }

    final void print(short tk, char ws) {
        this.print(tk);
        this.print(ws);
    }

    private final void checkWrapBoundary() {
        if (this.markBoundary_height >= 0) {
            boolean lineStart;
            boolean bl = lineStart = this.newlines() > 0 || this.flag_justindent;
            if (!lineStart) {
                this.emitter.markWrapBoundary(this.markBoundary_height);
            }
            this.markBoundary_height = -1;
        }
    }

    private final void checkWrapAlignment() {
        if (this.alignmentMark_height >= 0) {
            int column = this.emitter.getColumn();
            int i = this.stackTop;
            while (this.alignmentMark_height >= 0) {
                byte before = FormatInfo.ra$indent(this.stack[this.alignmentMark_height]);
                int delta = column - before;
                while (i >= this.alignmentMark_height) {
                    FormatInfo.wa$alignment(this.stack[i], FormatInfo.ra$indent(this.stack[i]) + delta);
                    FormatInfo.wa$alignmentStamp(this.stack[i], this.emitter.getColumnStamp());
                    --i;
                }
                FormatInfo.wa$alignment(this.stack[this.alignmentMark_height], column);
                FormatInfo.wa$alignmentStamp(this.stack[this.alignmentMark_height], this.emitter.getColumnStamp());
                int nextHeight = FormatInfo.ra$saved_alignmentMark_height(this.stack[this.alignmentMark_height]);
                if (this.alignmentMark_height <= nextHeight) {
                    FormatLayer1.panic();
                }
                this.alignmentMark_height = nextHeight;
            }
            this.alignmentMark_height = -1;
        }
    }

    final void checkIndent() {
        this.flush();
        if (this.newlines() > 0) {
            this.emitter.emitIndent(this.getIndent());
            this.newlinesEmitted = 0;
            this.newlinesPending = 0;
            this.blanklineSyms = 0;
            this.flag_justindent = true;
        }
    }

    private final void checkSpace(int tk) {
        if (this.flag_justindent) {
            return;
        }
        if (this.newlines() == 0 && !this.flag_space) {
            boolean space = false;
            if (32 <= this.lastToken && this.lastToken < 81) {
                switch (this.lastToken) {
                    case 39: {
                        space = this.preferences.getBoolean(34);
                        break;
                    }
                    case 75: {
                        space = this.preferences.getBoolean(36);
                        break;
                    }
                    case 55: {
                        if (tk == 72) break;
                        space = this.preferences.getBoolean(47);
                        break;
                    }
                    case 50: {
                        if (tk == 71) break;
                        space = this.preferences.getBoolean(48);
                        break;
                    }
                    case 69: {
                        break;
                    }
                    case 38: {
                        space = this.preferences.getBoolean(40);
                        break;
                    }
                    default: {
                        if (FormatLayer1.asg_op(this.lastToken) == 0) break;
                        space = this.preferences.getBoolean(45);
                        break;
                    }
                }
            }
            if (!space) {
                switch (tk) {
                    case 39: {
                        space = this.preferences.getBoolean(33);
                        break;
                    }
                    case 75: {
                        space = this.preferences.getBoolean(35);
                        break;
                    }
                    case 72: {
                        if (this.lastToken == 55) break;
                        space = this.preferences.getBoolean(47);
                        break;
                    }
                    case 71: {
                        if (this.lastToken == 50) break;
                        space = this.preferences.getBoolean(48);
                        break;
                    }
                    case 49: {
                        space = this.preferences.getBoolean(49);
                        break;
                    }
                    default: {
                        if (FormatLayer1.asg_op(tk) == 0) break;
                        space = this.preferences.getBoolean(45);
                        break;
                    }
                }
            }
            if (this.lastToken == 119 || tk == 119) {
                space = true;
            }
            this.flag_space = space;
        }
        if (this.flag_space) {
            this.emitter.emit(' ');
        }
        this.flag_space = false;
    }

    final void print(String s) {
        if (s.length() == 0) {
            return;
        }
        this.checkIndent();
        this.checkWrapBoundary();
        this.checkSpace(4);
        this.checkWrapAlignment();
        this.emitter.emit(s);
        this.flag_lessindentonce = false;
        this.flag_justindent = false;
        this.lastToken = (short)4;
    }

    final void print(short tk) {
        this.checkIndent();
        this.checkWrapBoundary();
        this.checkSpace(tk);
        this.checkWrapAlignment();
        this.emitter.emit(tk);
        this.flag_lessindentonce = false;
        this.flag_justindent = false;
        this.lastToken = tk;
    }

    final void print(char ws) {
        switch (ws) {
            case ' ': {
                this.flag_space = true;
                break;
            }
            case '\n': {
                this.println();
                break;
            }
            default: {
                this.checkIndent();
                this.emitter.emit(ws);
                this.flag_justindent = false;
            }
        }
    }

    final void println() {
        this.flag_space = false;
        ++this.newlinesPending;
        this.lastToken = (short)5;
    }

    final void ensureNewlines(int count) {
        int newlines = this.newlines();
        if (count <= newlines) {
            return;
        }
        this.flag_space = false;
        this.newlinesPending += count - newlines;
        this.lastToken = (short)5;
    }

    private void flushNewlines(int count) {
        if (this.newlinesEmitted >= count) {
            return;
        }
        int diff = count - this.newlinesEmitted;
        if (this.newlinesPending < diff) {
            FormatLayer1.panic("Insufficient newlines");
        }
        int i = 0;
        while (i < diff) {
            this.emitter.emit('\n');
            ++i;
        }
        this.newlinesEmitted += diff;
        this.newlinesPending -= diff;
        this.alignmentMark_height = -1;
    }

    private void flush() {
        if (this.newlinesPending > 0) {
            int i = 0;
            while (i < this.newlinesPending) {
                this.emitter.emit('\n');
                ++i;
            }
            this.newlinesEmitted += this.newlinesPending;
            this.newlinesPending = 0;
            this.alignmentMark_height = -1;
        }
    }

    protected final void printTypeArgumentsStart() {
        if (this.flag_space) {
            this.emitter.emit(' ');
            this.flag_space = false;
        }
        this.print('<');
    }

    FormatLayer1() {
        this.$init$();
    }

    private static class FormatInfo {
        private int decoration;
        private byte indent;
        private int alignment;
        private int alignmentStamp;
        private int saved_alignmentMark_height;

        private void $init$() {
            this.decoration = 0;
            this.indent = 0;
            this.alignment = 0;
            this.alignmentStamp = 0;
            this.saved_alignmentMark_height = -1;
        }

        private FormatInfo() {
            this.$init$();
        }

        static byte ra$indent(FormatInfo formatInfo) {
            return formatInfo.indent;
        }

        static void wa$alignment(FormatInfo formatInfo, int n) {
            formatInfo.alignment = n;
        }

        static void wa$alignmentStamp(FormatInfo formatInfo, int n) {
            formatInfo.alignmentStamp = n;
        }

        static int ra$saved_alignmentMark_height(FormatInfo formatInfo) {
            return formatInfo.saved_alignmentMark_height;
        }

        static void wa$saved_alignmentMark_height(FormatInfo formatInfo, int n) {
            formatInfo.saved_alignmentMark_height = n;
        }

        FormatInfo(1 var1_1) {
            this();
        }

        static void wa$decoration(FormatInfo formatInfo, int n) {
            formatInfo.decoration = n;
        }

        static void wa$indent(FormatInfo formatInfo, byte by) {
            formatInfo.indent = by;
        }

        static int ra$alignment(FormatInfo formatInfo) {
            return formatInfo.alignment;
        }

        static int ra$alignmentStamp(FormatInfo formatInfo) {
            return formatInfo.alignmentStamp;
        }

        public final class 1 {
        }
    }
}

