/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.format.FormatConstants;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.internal.util.TokenMap;
import oracle.javatools.parser.java.v2.util.OffsetPair;

public final class DamageCalculation
extends CommonUtilities
implements FormatConstants {
    private DamageCalculation() {
    }

    public static void preprocess(SymOperation[] ops) {
        int count = ops.length;
        int i = 0;
        while (i < count) {
            SymOperation op = ops[i];
            if (op.opTarget != null) {
                op.opTarget.symFormat = (char)(op.opTarget.symFormat | '\u0001');
            }
            if (op.opNewSym != null) {
                op.opNewSym.symFormat = (char)(op.opNewSym.symFormat | '\u0001');
            }
            if (op.opParent != null) {
                op.opParent.symFormat = (char)(op.opParent.symFormat | '\u0001');
            }
            switch (op.opKind) {
                case 4: 
                case 5: 
                case 6: {
                    op.opTarget.unsaveText();
                }
            }
            ++i;
        }
    }

    public static FormatRegion[] process(SymOperation[] ops, TokenMap tokenMap) {
        ArrayList<FormatRegion> regions = new ArrayList<FormatRegion>();
        ProcessingData data = new ProcessingData(null);
        int count = ops.length;
        int i = 0;
        while (i < count) {
            SymOperation op = ops[i];
            Object target = null;
            switch (op.opKind) {
                case 3: {
                    DamageCalculation.preprocessUnlink(op.opTarget, data);
                    break;
                }
                case 2: {
                    DamageCalculation.preprocessUnlink(op.opTarget, data);
                    DamageCalculation.preprocessLink(op.opNewSym, data);
                    break;
                }
                case 1: {
                    DamageCalculation.preprocessLink(op.opNewSym, data);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    DamageCalculation.preprocessReplace(op.opTarget, data);
                    break;
                }
                case 7: {
                    if (count > 1) {
                        DamageCalculation.panic("Format special doesn't work if count > 1");
                    }
                    FormatRegion region = (FormatRegion)op.getBinding(6);
                    try {
                        region.alignSelf(tokenMap, true);
                        regions.add(region);
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                default: {
                    DamageCalculation.notImplementedYet();
                }
            }
            ++i;
        }
        DamageCalculation.processRemoves(data, regions, tokenMap);
        DamageCalculation.processInserts(data, regions, tokenMap);
        DamageCalculation.processReplaces(data, regions, tokenMap);
        DamageCalculation.coalesceRegions(regions);
        int size = regions.size();
        if (size == 0) {
            return FormatRegion.EMPTY_ARRAY;
        }
        return regions.toArray(new FormatRegion[size]);
    }

    private static void preprocessLink(Sym s, ProcessingData data) {
        if (s.is((byte)85)) {
            return;
        }
        if (s.getParentSym() == null) {
            return;
        }
        if (s.is((byte)87) && s.symKind != 63) {
            DocSym docSym = (DocSym)s;
            DocCommentSym dc = docSym.getOwningDocCommentSym();
            if (dc != null) {
                ProcessingData.mav$replaceSyms(data).add(dc);
            }
        } else {
            ProcessingData.mav$insertSyms(data).add(s);
        }
    }

    private static void preprocessUnlink(Sym s, ProcessingData data) {
        if (s.is((byte)85)) {
            return;
        }
        if (s.is((byte)87) && s.symKind != 63) {
            DocSym docSym = (DocSym)s;
            DocCommentSym dc = docSym.getOwningDocCommentSym();
            if (dc != null) {
                ProcessingData.mav$replaceSyms(data).add(dc);
            }
        } else {
            int startIndex = s.getStartIndex();
            if (startIndex == -1) {
                return;
            }
            ProcessingData.mav$removeSyms(data).add(s);
        }
    }

    private static void preprocessReplace(Sym s, ProcessingData data) {
        if (s.is((byte)87) && s.symKind != 63) {
            DocSym docSym = (DocSym)s;
            s = docSym.getOwningDocCommentSym();
        }
        if (s != null) {
            ProcessingData.mav$replaceSyms(data).add(s);
        }
    }

    private static void processRemoves(ProcessingData data, ArrayList regions, TokenMap tokenMap) {
        ArrayList removeSyms = ProcessingData.mav$removeSyms(data);
        if (removeSyms.isEmpty()) {
            return;
        }
        ArrayList selectedRemoves = new ArrayList();
        selectedRemoves.addAll(removeSyms);
        Collections.sort(selectedRemoves);
        DamageCalculation.removeDescendants(selectedRemoves);
        int count = selectedRemoves.size();
        int i = 0;
        while (i < count) {
            block6: {
                int endIndex;
                Sym sym = (Sym)selectedRemoves.get(i);
                int startIndex = sym.getStartIndex();
                if (startIndex >= 0 && (endIndex = sym.getEndIndex()) >= startIndex) {
                    Arrays.fill(tokenMap.forwardMap, startIndex, endIndex + 1, -1);
                    OffsetPair symIndices = OffsetPair.createFromStartAndEnd(startIndex, endIndex);
                    FormatRegion symRegion = new FormatRegion(symIndices, null);
                    try {
                        symRegion.alignSelf(tokenMap, true);
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        break block6;
                    }
                    regions.add(symRegion);
                }
            }
            ++i;
        }
        for (Sym sym : removeSyms) {
            sym.clearOffsets();
        }
    }

    private static void processInserts(ProcessingData data, ArrayList regions, TokenMap tokenMap) {
        ArrayList insertSyms = ProcessingData.mav$insertSyms(data);
        if (insertSyms.isEmpty()) {
            return;
        }
        ArrayList<Sym> selectedInserts = new ArrayList<Sym>();
        for (Sym thing : insertSyms) {
            Sym mappedThing = thing.getMapping();
            if (mappedThing == null) continue;
            selectedInserts.add(mappedThing);
        }
        Collections.sort(selectedInserts);
        DamageCalculation.removeDescendants(selectedInserts);
        int count = selectedInserts.size();
        int i = 0;
        while (i < count) {
            block8: {
                int endIndex;
                Sym sym = (Sym)selectedInserts.get(i);
                int startIndex = sym.getStartIndex();
                if (startIndex >= 0 && (endIndex = sym.getEndIndex()) >= startIndex) {
                    if (startIndex > 0) {
                        --startIndex;
                    }
                    if (endIndex + 1 < tokenMap.backwardMap.length) {
                        ++endIndex;
                    }
                    OffsetPair symIndices = OffsetPair.createFromStartAndEnd(startIndex, endIndex);
                    FormatRegion symRegion = new FormatRegion(null, symIndices);
                    try {
                        symRegion.alignSelf(tokenMap, false);
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        break block8;
                    }
                    regions.add(symRegion);
                }
            }
            ++i;
        }
    }

    private static void processReplaces(ProcessingData data, ArrayList regions, TokenMap tokenMap) {
        ArrayList replaceSyms = ProcessingData.mav$replaceSyms(data);
        if (replaceSyms.isEmpty()) {
            return;
        }
        int count = replaceSyms.size();
        int i = 0;
        while (i < count) {
            int endIndex;
            Sym thing = (Sym)replaceSyms.get(i);
            int startIndex = thing.getStartIndex();
            if (startIndex >= 0 && (endIndex = thing.getEndIndex()) >= startIndex) {
                int mappedStartIndex = -1;
                int mappedEndIndex = -1;
                Sym mappedThing = thing.getMapping();
                if (mappedThing != null) {
                    mappedStartIndex = mappedThing.getStartIndex();
                    mappedEndIndex = mappedThing.getEndIndex();
                }
                if (mappedStartIndex < 0) {
                    mappedStartIndex = tokenMap.mapForward(startIndex);
                    mappedEndIndex = tokenMap.mapForward(endIndex);
                }
                if (mappedStartIndex >= 0 && mappedEndIndex >= 0) {
                    OffsetPair symIndices = OffsetPair.createFromStartAndEnd(startIndex, endIndex);
                    OffsetPair mappedIndices = OffsetPair.createFromStartAndEnd(mappedStartIndex, mappedEndIndex);
                    FormatRegion symRegion = new FormatRegion(symIndices, mappedIndices);
                    regions.add(symRegion);
                }
            }
            ++i;
        }
    }

    private static void coalesceRegions(ArrayList regions) {
        Collections.sort(regions, new FormatRegionComparator(null));
        Iterator iterator = regions.iterator();
        FormatRegion lastRegion = null;
        while (iterator.hasNext()) {
            FormatRegion region = (FormatRegion)iterator.next();
            if (lastRegion != null) {
                int lastStart = lastRegion.toIndices.getStartOffset();
                int thisStart = region.toIndices.getStartOffset();
                int lastEnd = lastRegion.toIndices.getEndOffset();
                int thisEnd = region.toIndices.getEndOffset();
                if (lastStart < thisStart && thisEnd < lastEnd) {
                    iterator.remove();
                    continue;
                }
                if (thisStart <= lastEnd) {
                    lastRegion.toIndices.setStartAndEnd(lastStart, thisEnd);
                    int lastFromStart = lastRegion.fromIndices.getStartOffset();
                    int thisFromStart = region.fromIndices.getStartOffset();
                    int resultFromStart = Math.min(lastFromStart, thisFromStart);
                    int lastFromEnd = lastRegion.fromIndices.getEndOffset();
                    int thisFromEnd = region.fromIndices.getEndOffset();
                    int resultFromEnd = Math.max(lastFromEnd, thisFromEnd);
                    lastRegion.fromIndices.setStartAndEnd(resultFromStart, resultFromEnd);
                    iterator.remove();
                    continue;
                }
            }
            lastRegion = region;
        }
    }

    private static void removeDescendants(ArrayList list) {
        Iterator iterator = list.iterator();
        Sym lastSym = null;
        while (iterator.hasNext()) {
            Sym sym = (Sym)iterator.next();
            if (lastSym != null && lastSym.symStart <= sym.symStart && sym.symEnd <= lastSym.symEnd) {
                iterator.remove();
                continue;
            }
            lastSym = sym;
        }
    }

    private static final class ProcessingData {
        private ArrayList insertSyms;
        private ArrayList removeSyms;
        private ArrayList replaceSyms;

        private void $init$() {
            this.insertSyms = new ArrayList();
            this.removeSyms = new ArrayList();
            this.replaceSyms = new ArrayList();
        }

        private ArrayList insertSyms() {
            return this.insertSyms;
        }

        private ArrayList removeSyms() {
            return this.removeSyms;
        }

        private ArrayList replaceSyms() {
            return this.replaceSyms;
        }

        private ProcessingData() {
            this.$init$();
        }

        static ArrayList mav$replaceSyms(ProcessingData processingData) {
            return processingData.replaceSyms();
        }

        static ArrayList mav$insertSyms(ProcessingData processingData) {
            return processingData.insertSyms();
        }

        static ArrayList mav$removeSyms(ProcessingData processingData) {
            return processingData.removeSyms();
        }

        ProcessingData(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FormatRegionComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            return this.compare((FormatRegion)one, (FormatRegion)two);
        }

        public int compare(FormatRegion one, FormatRegion two) {
            int end2;
            int start2;
            if (one == two) {
                return 0;
            }
            int start1 = one.toIndices.getStartOffset();
            if (start1 != (start2 = two.toIndices.getStartOffset())) {
                return start1 - start2;
            }
            int end1 = one.toIndices.getEndOffset();
            if (end1 != (end2 = two.toIndices.getEndOffset())) {
                return end1 - end2;
            }
            return 0;
        }

        private FormatRegionComparator() {
        }

        FormatRegionComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

