/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;

abstract class BufferedEmitter
extends Emitter {
    private final StringWriter writer;
    private final PrintWriter printer;
    final StringBuffer buffer;
    protected byte tabSize;
    protected boolean replaceWithTabs;

    private void $init$() {
        this.writer = new StringWriter();
        this.printer = new PrintWriter(this.writer);
        this.buffer = this.writer.getBuffer();
        this.tabSize = (byte)4;
        this.replaceWithTabs = false;
    }

    public TextBuffer getOutputBuffer() {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        String text = this.getBuffer().toString();
        textBuffer.insert(0, text.toCharArray());
        return textBuffer;
    }

    final StringBuffer getBuffer() {
        return this.buffer;
    }

    public final String toString() {
        return this.getBuffer().toString();
    }

    void init(Sym s) {
        this.buffer.setLength(0);
        int size = this.formatter.preferences.getInt(2);
        this.tabSize = BufferedEmitter.int2unsignedByte(size);
        this.replaceWithTabs = this.formatter.preferences.getBoolean(1);
    }

    void fini(Sym s) {
        int length = this.buffer.length();
        int i = length - 1;
        while (i >= 0) {
            char ch = this.buffer.charAt(i);
            if (ch == '\n') {
                while (i >= 1 && this.buffer.charAt(i - 1) == ' ') {
                    this.buffer.deleteCharAt(--i);
                }
            }
            --i;
        }
    }

    private void emitImpl(String s) {
        this.printer.print(s);
    }

    final void emitIndentImpl(int spaces, boolean docindent) {
        if (this.replaceWithTabs && this.tabSize > 0) {
            while (spaces >= this.tabSize) {
                this.printer.print('\t');
                spaces -= this.tabSize;
            }
        }
        int i = 0;
        while (i < spaces) {
            this.printer.print(' ');
            ++i;
        }
        if (docindent) {
            this.printer.print(" * ");
        }
    }

    abstract void emitIndent(int var1);

    void emit(String s) {
        this.emitImpl(s);
    }

    void emit(short tk) {
        this.emitImpl(BufferedEmitter.tk2text(tk));
    }

    void emit(char ch) {
        if (ch == '\n') {
            this.printer.println();
        } else {
            this.printer.print(ch);
        }
    }

    BufferedEmitter() {
        this.$init$();
    }
}

