/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ContextImageA;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.TryStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ContextImageB
extends ContextImageA {
    private static final int PASS_1 = 1;
    private static final int PASS_2 = 2;
    private static final int PASS_3 = 3;

    ContextImageB(CompilerDriver compiler, JavaClass caller) {
        super(compiler, caller);
    }

    ContextImageB(CompilerDriver compiler, Sym cookie) {
        super(compiler, cookie);
    }

    ContextImageB(CompilerContext other) {
        super(other);
    }

    protected final boolean findVisibleMethod(JavaType targetClass, String name) {
        Collection declaredMethods;
        if (targetClass == null) {
            return false;
        }
        if ("<init>".equals(name)) {
            ContextImageB.panic(this.symCookie);
        }
        if ((declaredMethods = targetClass.getDeclaredMethods(name)).size() > 0) {
            return true;
        }
        for (JavaClass type : targetClass.getHierarchy()) {
            for (JavaMethod thing : type.getDeclaredMethods(name)) {
                if (!this.processVisible(thing)) continue;
                return true;
            }
        }
        return false;
    }

    protected final JavaMethod findSingleMethod(JavaType targetClass, String name) {
        if (targetClass == null) {
            return null;
        }
        ArrayList visible = ContextImageB.allocArrayList();
        try {
            if ("<init>".equals(name)) {
                visible.addAll(targetClass.getDeclaredConstructors());
            } else {
                visible.addAll(targetClass.getDeclaredMethods(name));
                for (JavaClass type : targetClass.getHierarchy()) {
                    for (JavaMethod thing : type.getDeclaredMethods(name)) {
                        if (!this.processVisible(thing)) continue;
                        visible.add(thing);
                    }
                }
            }
            if (visible.isEmpty()) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            this.findMostSpecificMethod(visible);
            if (visible.isEmpty()) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            if (visible.size() == 1) {
                JavaMethod javaMethod = (JavaMethod)visible.get(0);
                return javaMethod;
            }
            JavaMethod javaMethod = this.chooseMostSpecificMethod(visible);
            return javaMethod;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            ContextImageB.freeArrayList(visible);
        }
    }

    protected final JavaMethod findMethod(JavaType targetClass, String name, JavaType[] arguments) {
        return this.findMethod(targetClass, name, null, arguments);
    }

    protected final JavaMethod findMethod(JavaType targetClass, String name, JavaType[] typeArguments, JavaType[] arguments) {
        ArrayList potential = ContextImageB.allocArrayList();
        try {
            this.findPotentiallyApplicable(targetClass, name, typeArguments, arguments, potential);
            JavaMethod javaMethod = this.processMethods(potential, typeArguments, arguments);
            return javaMethod;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            ContextImageB.freeArrayList(potential);
        }
    }

    protected final JavaMethod findImportedMethod(String name, JavaType[] arguments) {
        this.flag_instance = false;
        JavaType[] tArguments = JavaType.EMPTY_ARRAY;
        ArrayList potential = ContextImageB.allocArrayList();
        try {
            this.processImportedMethods(name, tArguments, arguments, potential);
            JavaMethod javaMethod = this.processMethods(potential, tArguments, arguments);
            return javaMethod;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            ContextImageB.freeArrayList(potential);
        }
    }

    protected final boolean checkException(Sym scope, JavaType thrown) {
        byte scopeType = scope.symKind;
        switch (scopeType) {
            case 6: 
            case 19: {
                SourceMethod methodSym = (SourceMethod)((Object)scope);
                for (JavaType declared : methodSym.getExceptions()) {
                    if (!thrown.isSubtypeOf(declared)) continue;
                    return true;
                }
                this.error((short)43, thrown);
                return true;
            }
            case 2: {
                Sym grandparent;
                Sym parent = scope.getParentSym();
                if (parent != null && parent.symKind == 29 && (grandparent = parent.getParentSym()) != null && grandparent.symKind == 44) {
                    TryStmt tryStmt = (TryStmt)grandparent;
                    for (CatchStmt catchStmt : tryStmt.getCatchClauses()) {
                        JavaType caughtType;
                        FormalParameterSym variableSym = catchStmt.getCatchVariableSym();
                        if (variableSym == null || (caughtType = variableSym.getResolvedType()) == null || !thrown.isSubtypeOf(caughtType)) continue;
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                this.error((short)43, thrown);
                return true;
            }
        }
        return false;
    }

    protected final List<ImportSym> getValidStaticImports(FileSym sourceFile) {
        List importSyms = sourceFile.getSourceImports();
        ArrayList<ImportSym> staticImportList = new ArrayList<ImportSym>();
        for (ImportSym importSym : importSyms) {
            if (!importSym.isStatic() || importSym.isInvalid()) continue;
            staticImportList.add(importSym);
        }
        return staticImportList;
    }

    protected final JavaMethod processMethods(ArrayList potential, JavaType[] typeArguments, JavaType[] arguments) {
        JavaMethod method;
        if (typeArguments == null) {
            typeArguments = JavaType.EMPTY_ARRAY;
        }
        if ((method = this.processMethodsImpl(potential, typeArguments, arguments)) == null) {
            return null;
        }
        if (!method.hasTypeParameters()) {
            return method;
        }
        if (typeArguments.length == 0 && (typeArguments = this.inferTypeArguments(method, arguments)) == null) {
            return method;
        }
        if (method.hasActualTypeArguments()) {
            ContextImageB.panic("But it already has actual type arguments.");
        }
        return ContextImageB.createParameterizedMethod(this.compiler.provider, method, typeArguments);
    }

    private final JavaMethod processMethodsImpl(ArrayList potential, JavaType[] tArguments, JavaType[] arguments) {
        if (potential.isEmpty()) {
            return null;
        }
        ArrayList applicable = ContextImageB.allocArrayList();
        try {
            if (applicable.isEmpty()) {
                this.findApplicable(1, tArguments, arguments, potential, applicable);
            }
            if (applicable.isEmpty()) {
                this.findApplicable(2, tArguments, arguments, potential, applicable);
            }
            if (applicable.isEmpty()) {
                this.findApplicable(3, tArguments, arguments, potential, applicable);
            }
            if (applicable.isEmpty()) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            if (applicable.size() == 1) {
                JavaMethod javaMethod = (JavaMethod)applicable.get(0);
                return javaMethod;
            }
            this.findMostSpecificMethod(applicable);
            if (applicable.size() == 1) {
                JavaMethod javaMethod = (JavaMethod)applicable.get(0);
                return javaMethod;
            }
            JavaMethod result = this.chooseMostSpecificMethod(applicable);
            if (result != null) {
                JavaMethod javaMethod = result;
                return javaMethod;
            }
            this.error((short)35);
            JavaMethod javaMethod = null;
            return javaMethod;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            ContextImageB.freeArrayList(applicable);
        }
    }

    private void findPotentiallyApplicable(JavaType targetClass, String targetName, JavaType[] typeArguments, JavaType[] arguments, ArrayList output) {
        if (targetClass == null) {
            return;
        }
        if (typeArguments == null) {
            typeArguments = JavaType.EMPTY_ARRAY;
        }
        this.findPotentiallyApplicableImpl(targetClass, targetName, typeArguments, arguments, output);
        if ("<init>".equals(targetName)) {
            return;
        }
        for (JavaClass type : targetClass.getHierarchy()) {
            this.findPotentiallyApplicableImpl(type, targetName, typeArguments, arguments, output);
        }
    }

    private void findPotentiallyApplicableImpl(JavaType targetClass, String targetName, JavaType[] tArguments, JavaType[] arguments, ArrayList output) {
        if (targetClass.hasTypeParameters() && !targetClass.hasActualTypeArguments()) {
            targetClass = CommonUtilities.createTypeErasedClass(targetClass);
        }
        int argCount = arguments.length;
        int typeArgCount = tArguments.length;
        boolean isConstructor = "<init>".equals(targetName);
        Iterator methods = isConstructor ? targetClass.getDeclaredConstructors().iterator() : targetClass.getDeclaredMethods(targetName).iterator();
        while (methods.hasNext()) {
            int arity;
            JavaMethod method = (JavaMethod)methods.next();
            boolean isVarargs = method.isVarargs();
            int parameterCount = method.getParameters().size();
            if (!isVarargs ? parameterCount != argCount : argCount < (arity = parameterCount - 1)) continue;
            int typeParameterCount = method.getTypeParameters().size();
            if (typeArgCount > 0 && typeParameterCount != typeArgCount || !isConstructor && !this.flag_instance && !method.isStatic() || !this.processVisible(method)) continue;
            output.add(method);
        }
    }

    private void processImportedMethods(String name, JavaType[] tArguments, JavaType[] arguments, ArrayList output) {
        FileSym sourceFile = this.symCookie.symFile;
        if (sourceFile == null) {
            return;
        }
        List<ImportSym> importSyms = this.getValidStaticImports(sourceFile);
        if (importSyms.size() == 0) {
            return;
        }
        HashSet<String> signatures = new HashSet<String>();
        ArrayList tmp = ContextImageB.allocArrayList();
        try {
            for (ImportSym importSym : importSyms) {
                String fqname;
                int lastDot;
                String importedName;
                if (!importSym.isNarrow() || !(importedName = (lastDot = (fqname = importSym.getName()).lastIndexOf(46)) == -1 ? fqname : fqname.substring(lastDot + 1)).equals(name)) continue;
                this.processImportedMethods(importSym, name, tArguments, arguments, signatures, tmp, output);
            }
            HashSet<String> importKeys = new HashSet<String>();
            for (ImportSym importSym : importSyms) {
                String importName;
                if (importSym.isNarrow() || importKeys.contains(importName = importSym.getName())) continue;
                importKeys.add(importName);
                this.processImportedMethods(importSym, name, tArguments, arguments, signatures, tmp, output);
            }
        }
        finally {
            ContextImageB.freeArrayList(tmp);
        }
    }

    private void processImportedMethods(ImportSym importSym, String name, JavaType[] tArguments, JavaType[] arguments, HashSet<String> signatures, ArrayList tmp, ArrayList output) {
        importSym.resolve();
        JavaClass qualifying = importSym.getQualifyingType();
        if (qualifying == null) {
            return;
        }
        tmp.clear();
        this.findPotentiallyApplicableImpl(qualifying, name, tArguments, arguments, tmp);
        if (tmp.isEmpty()) {
            return;
        }
        for (JavaMethod method : tmp) {
            String signature = method.getSignature();
            if (signatures.contains(signature)) continue;
            signatures.add(signature);
            output.add(method);
            importSym.setUsed();
            ArrayList importList = importSym.getImportObj().importList;
            if (importList == null || importList.contains(method)) continue;
            importList.add(method);
        }
    }

    private void findApplicable(int pass, JavaType[] typeArguments, JavaType[] arguments, ArrayList input, ArrayList output) {
        int typeArgCount = typeArguments.length;
        int argCount = arguments.length;
        Iterator iterator = input.iterator();
        block0: while (iterator.hasNext()) {
            Collection typeParameterCollection;
            JavaMethod method = (JavaMethod)iterator.next();
            if (typeArgCount > 0 && pass == 1 && (typeParameterCollection = method.getTypeParameters()).size() != typeArgCount) {
                iterator.remove();
                continue;
            }
            Collection parameterCollection = method.getParameters();
            int parameterCount = parameterCollection.size();
            boolean isVararg = method.isVarargs();
            int arity = isVararg && pass == 3 ? parameterCount - 1 : parameterCount;
            if (arity != argCount && pass < 3) continue;
            Iterator parameters = parameterCollection.iterator();
            JavaVariable parameter = null;
            int a = 0;
            while (a < argCount) {
                JavaType argument;
                if (parameters.hasNext()) {
                    parameter = (JavaVariable)parameters.next();
                }
                if ((argument = arguments[a]) != null) {
                    boolean allowBoxing;
                    JavaType parameterType = parameter.getResolvedType();
                    if (pass == 3 && parameterType != null && parameter.isVarargs()) {
                        if (parameterType.isArray()) {
                            parameterType = parameterType.getComponentType();
                        } else {
                            IllegalStateException e = new IllegalStateException("Varargs parameter not an array type");
                            e.printStackTrace();
                        }
                    }
                    if (parameterType == null) {
                        iterator.remove();
                        continue block0;
                    }
                    boolean bl = allowBoxing = 2 <= pass;
                    if (!ContextImageB.applyMethodConversion(argument, parameterType, allowBoxing, this.compiler.provider)) continue block0;
                }
                ++a;
            }
            output.add(method);
        }
    }

    private void findMostSpecificMethod(ArrayList methods) {
        HashSet<JavaMethod> losers = new HashSet<JavaMethod>();
        for (JavaMethod favorite : methods) {
            if (losers.contains(favorite)) continue;
            for (JavaMethod contender : methods) {
                boolean favored;
                if (losers.contains(contender) || favorite.equals(contender) || !(favored = ContextImageB.isMoreSpecific(favorite, contender))) continue;
                losers.add(contender);
            }
        }
        methods.removeAll(losers);
    }

    private JavaMethod chooseMostSpecificMethod(ArrayList methods) {
        Iterator iterator = methods.iterator();
        JavaMethod output = null;
        while (iterator.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            if ((javaMethod.getModifiers() & 0x400) != 0) continue;
            if (output != null) {
                return null;
            }
            output = javaMethod;
        }
        if (output != null) {
            return output;
        }
        return (JavaMethod)methods.get(0);
    }

    private JavaType[] inferTypeArguments(JavaMethod method, JavaType[] arguments) {
        if (arguments.length == 0) {
            return null;
        }
        Collection typeParameters = method.getTypeParameters();
        int tpCount = typeParameters.size();
        if (tpCount == 0) {
            ContextImageB.panic("No parameters");
        }
        JavaType[] tpArray = typeParameters.toArray(new JavaType[tpCount]);
        JavaType[] constraints = new JavaType[tpCount];
        JavaType[] parameters = method.getParameterTypes();
        int loopCount = parameters.length;
        if (method.isVarargs()) {
            --loopCount;
        }
        int i = 0;
        while (i < loopCount) {
            this.inferFromOneArgument(parameters[i], arguments[i], tpArray, constraints);
            ++i;
        }
        int i2 = 0;
        while (i2 < tpCount) {
            if (constraints[i2] == null) {
                constraints[i2] = tpArray[i2];
            }
            ++i2;
        }
        return constraints;
    }

    private void inferFromOneArgument(JavaType parameter, JavaType argument, JavaType[] typeParameters, JavaType[] constraints) {
        JavaType a;
        if (argument == null || parameter == null) {
            return;
        }
        if (!this.involvesTypeParameters(parameter, typeParameters)) {
            return;
        }
        if (argument.isPrimitive()) {
            if ("N".equals(argument.getDescriptor())) {
                return;
            }
            a = ContextImageB.applyBoxingConversion((PrimitiveType)argument, this.compiler.provider);
        } else {
            a = argument;
        }
        this.inferFromOneArgumentImpl(parameter, a, typeParameters, constraints);
    }

    private boolean inferFromOneArgumentImpl(JavaType f, JavaType a, JavaType[] tArray, JavaType[] constraints) {
        if (f == null || a == null) {
            return false;
        }
        block0 : switch (f.getElementKind()) {
            case 11: {
                JavaWildcardType wildcardType = (JavaWildcardType)f;
                Collection bounds = wildcardType.getUpperBounds();
                if (bounds.isEmpty()) {
                    bounds = wildcardType.getLowerBounds();
                }
                if (bounds.isEmpty()) break;
                block5: for (JavaType boundType : bounds) {
                    int count = tArray.length;
                    int i = 0;
                    while (i < count) {
                        if (boundType.equals(tArray[i])) {
                            constraints[i] = a;
                            continue block5;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 10: {
                int count = tArray.length;
                int i = 0;
                while (i < count) {
                    if (f.equals(tArray[i])) {
                        constraints[i] = a;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                JavaClass g;
                if (f.isArray() && a.isArray()) {
                    return this.inferFromOneArgumentImpl(f.getComponentType(), a.getComponentType(), tArray, constraints);
                }
                if (!f.hasActualTypeArguments() || this.inferFromClass(f, g = f.getTypeErasure(), a, tArray, constraints)) break;
                for (JavaType supertype : a.getHierarchy()) {
                    if (this.inferFromClass(f, g, supertype, tArray, constraints)) break block0;
                }
                break;
            }
        }
        return false;
    }

    private boolean inferFromClass(JavaType f, JavaType g, JavaType a, JavaType[] tArray, JavaType[] constraints) {
        boolean match = g.equals(a.getTypeErasure());
        if (a.hasActualTypeArguments() && match) {
            Iterator fActuals = f.getActualTypeArguments().iterator();
            Iterator aActuals = a.getActualTypeArguments().iterator();
            while (fActuals.hasNext() && aActuals.hasNext()) {
                JavaType u = (JavaType)fActuals.next();
                JavaType v = (JavaType)aActuals.next();
                this.inferFromOneArgumentImpl(u, v, tArray, constraints);
            }
        }
        return match;
    }

    private boolean involvesTypeParameters(JavaType f, JavaType[] tArray) {
        switch (f.getElementKind()) {
            case 10: {
                int count = tArray.length;
                int i = 0;
                while (i < count) {
                    if (f.equals(tArray[i])) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
            case 11: {
                JavaWildcardType fw = (JavaWildcardType)f;
                for (JavaType bound : fw.getUpperBounds()) {
                    if (!this.involvesTypeParameters(bound, tArray)) continue;
                    return true;
                }
                for (JavaType bound : fw.getLowerBounds()) {
                    if (!this.involvesTypeParameters(bound, tArray)) continue;
                    return true;
                }
                break;
            }
            case 3: {
                if (f.isPrimitive()) {
                    return false;
                }
                if (f.isArray()) {
                    return this.involvesTypeParameters(f.getComponentType(), tArray);
                }
                for (JavaType y : f.getActualTypeArguments()) {
                    if (!this.involvesTypeParameters(y, tArray)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }
}

