/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer4;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceVariable;

abstract class CompilerLayer5j
extends CompilerLayer4 {
    public JavaElement resolve(DocReferenceSym sym) {
        if (sym.refParameterName != null) {
            return this.resolveParameterReference(sym);
        }
        return this.resolveMemberReference(sym);
    }

    private JavaElement resolveParameterReference(DocReferenceSym sym) {
        block4: {
            int length;
            String name = sym.refParameterName;
            if (name == null || name.length() == 0) {
                return null;
            }
            if (name.charAt(0) == '<' && name.charAt((length = name.length()) - 1) == '>') {
                String target = name.substring(1, length - 1);
                JavaType type = this.resolveType(sym, target);
                if (type != null && type.getElementKind() == 10) {
                    this.recordUsage(sym, type);
                    return type;
                }
                this.error(sym, (short)72, name);
                return null;
            }
            MemberSym member = sym.getOwningMemberSym();
            if (member.symKind != 6 && member.symKind != 19) break block4;
            MethodSym method = (MethodSym)member;
            for (FormalParameterSym parameter : method.getSourceParameters()) {
                if (!name.equals(parameter.getName())) continue;
                this.recordUsage(sym, parameter);
                return parameter;
            }
            this.error(sym, (short)72, name);
        }
        return null;
    }

    private JavaElement resolveMemberReference(DocReferenceSym sym) {
        CompilerContext savedContext = this.context;
        try {
            JavaElement element;
            List variables;
            MemberSym owner;
            this.context = this.newContext(sym);
            this.context.suppressErrors = true;
            String typeName = sym.refClassName;
            String memberName = sym.refMemberName;
            if (typeName == null && memberName == null && sym.getOwningTag().getName().equals("@value") && (owner = sym.getOwningMemberSym()) != null && owner.isStatic() && owner.isFinal() && owner.getSymbolKind() == 9 && (variables = ((SourceFieldDeclaration)((Object)owner)).getVariables()) != null && variables.size() > 0) {
                SourceVariable variable = (SourceVariable)variables.get(0);
                memberName = variable.getName();
                typeName = owner.getOwningClass().getName();
            }
            JavaType type = null;
            if (typeName != null) {
                type = this.resolveType(sym, typeName);
                if (type == null) {
                    JavaElement javaElement = this.error(sym, (short)72, typeName);
                    return javaElement;
                }
                this.recordUsage(sym, type);
                if (memberName == null) {
                    JavaType javaType = type;
                    return javaType;
                }
            } else if (memberName == null) {
                JavaElement javaElement = this.error(sym, (short)50);
                return javaElement;
            }
            if (memberName.length() == 0) {
                JavaElement javaElement = this.error(sym, (short)50);
                return javaElement;
            }
            List parameters = sym.refMethodParameters;
            JavaType[] arguments = null;
            if (parameters != null) {
                int count = parameters.size();
                arguments = count > 0 ? new JavaType[count] : JavaType.EMPTY_ARRAY;
                int i = 0;
                while (i < count) {
                    JavaType argumentType = this.resolveType(this.context.symCookie, (String)parameters.get(i));
                    if (argumentType != null) {
                        this.recordUsage(sym, argumentType);
                        arguments[i] = argumentType;
                    }
                    ++i;
                }
            }
            if ((element = type != null ? this.processQualifiedReference(type, memberName, arguments) : this.processUnqualifiedReference(memberName, arguments)) == null) {
                this.error(sym, (short)72, memberName);
            } else {
                this.recordUsage(sym, element);
            }
            JavaElement javaElement = element;
            return javaElement;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.context = savedContext;
        }
    }

    private JavaElement processUnqualifiedReference(String name, JavaType[] arguments) {
        Sym scope = this.context.cleanScope();
        while (scope != null) {
            if (scope.symKind == 3) {
                ClassSym classSym = (ClassSym)scope;
                if (arguments == null && this.context.findVisibleVariable(classSym, name)) {
                    return this.context.findMemberVariable(classSym, name);
                }
                boolean constructorCall = name.equals(classSym.getName());
                String methodName = name;
                if (constructorCall) {
                    methodName = "<init>";
                }
                if (constructorCall || this.context.findVisibleMethod(classSym, methodName)) {
                    if (arguments != null) {
                        return this.context.findMethod(classSym, methodName, arguments);
                    }
                    return this.context.findSingleMethod(classSym, methodName);
                }
            }
            scope = this.context.nextScope();
        }
        return null;
    }

    private JavaElement processQualifiedReference(JavaType type, String name, JavaType[] arguments) {
        if (type != null) {
            JavaVariable found;
            if (arguments == null && (found = this.context.findMemberVariable(type, name)) != null) {
                return found;
            }
            boolean constructorCall = name.equals(type.getName());
            String methodName = name;
            if (constructorCall) {
                methodName = "<init>";
            }
            if (arguments != null) {
                return this.context.findMethod(type, methodName, arguments);
            }
            return this.context.findSingleMethod(type, methodName);
        }
        return null;
    }

    CompilerLayer5j() {
    }
}

