/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SignatureHasType
extends AbstractElement
implements JavaHasType,
UnresolvedType {
    private final JavaProvider provider;
    private final byte ch;
    protected byte bound;
    private final JavaIsGeneric owningGeneric;
    private final String name;
    protected short array;
    protected List<JavaHasType> arguments;
    protected List<InnerType> inners;

    private void $init$() {
        this.bound = 0;
        this.array = 0;
        this.arguments = Collections.EMPTY_LIST;
        this.inners = Collections.EMPTY_LIST;
    }

    public SignatureHasType(char ch, String name, JavaProvider provider) {
        this.$init$();
        this.ch = (byte)ch;
        this.name = name;
        this.owningGeneric = null;
        this.provider = provider;
    }

    public SignatureHasType(char ch, JavaProvider provider) {
        this.$init$();
        this.ch = (byte)ch;
        this.name = null;
        this.owningGeneric = null;
        this.provider = provider;
    }

    SignatureHasType(String name, JavaIsGeneric owner, JavaProvider provider) {
        this.$init$();
        this.ch = (byte)84;
        this.name = name;
        this.owningGeneric = owner;
        this.provider = provider;
    }

    public void pushTypeArgument(SignatureHasType argument) {
        if (this.inners.isEmpty()) {
            if (this.arguments == Collections.EMPTY_LIST) {
                this.arguments = new ArrayList<JavaHasType>();
            }
            this.arguments.add(argument);
        } else {
            int innerLength = this.inners.size();
            InnerType inner = this.inners.get(innerLength - 1);
            if (inner.arguments == Collections.EMPTY_LIST) {
                inner.arguments = new ArrayList<JavaHasType>();
            }
            inner.arguments.add(argument);
        }
    }

    public void pushInnerType(String name) {
        if (this.inners == Collections.EMPTY_LIST) {
            this.inners = new ArrayList<InnerType>();
        }
        InnerType type = new InnerType(name, null);
        this.inners.add(type);
    }

    @Override
    public JavaFile getFile() {
        return null;
    }

    @Override
    public int getElementKind() {
        return 1;
    }

    @Override
    public int getModifiers() {
        return 4096;
    }

    @Override
    public JavaElement getOwner() {
        return null;
    }

    @Override
    public JavaType getResolvedType() {
        JavaType type;
        block0 : switch (this.ch) {
            case 84: {
                type = this.resolveTypeVariable(this.name);
                break;
            }
            case 42: {
                type = CommonUtilities.createWildcardType((byte)3, null, this.provider);
                break;
            }
            default: {
                type = this.name != null ? this.provider.getClassByVMName(this.name) : PrimitiveType.PRIMITIVE_alpha[this.ch - 65];
                type = this.resolveTypeArguments(type, this.arguments);
                for (InnerType inner : this.inners) {
                    JavaType innerType;
                    if (type == null) break block0;
                    JavaClass genericInner = type.getClass(InnerType.ra$name(inner));
                    type = innerType = this.resolveTypeArguments(genericInner, inner.arguments);
                }
            }
        }
        if (this.array > 0) {
            type = CommonUtilities.createArrayType(this.provider, type, this.array);
        }
        if (this.bound == 0) {
            return type;
        }
        return CommonUtilities.createWildcardType(this.bound, type, this.provider);
    }

    private JavaType resolveTypeArguments(JavaType type, List<JavaHasType> arguments) {
        if (type == null) {
            return null;
        }
        if (arguments.isEmpty()) {
            return type;
        }
        if (!type.hasTypeParameters()) {
            return type;
        }
        int count = arguments.size();
        JavaType[] array = new JavaType[count];
        Iterator<JavaHasType> iterator = arguments.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            SignatureHasType thing = (SignatureHasType)iterator.next();
            array[i++] = thing.getResolvedType();
        }
        try {
            JavaType javaType = CommonUtilities.createParameterizedType(this.provider, type, array);
            return javaType;
        }
        catch (IllegalArgumentException e) {
            Logger log = JavaParser.getLogger();
            String message = "Failed for: " + type.getQualifiedName();
            log.log(Level.INFO, message, e);
            JavaType javaType = type;
            return javaType;
        }
    }

    private JavaTypeVariable resolveTypeVariable(String name) {
        JavaIsGeneric generic = this.owningGeneric;
        while (generic != null) {
            JavaTypeVariable found = generic.getTypeParameter(name);
            if (found != null) {
                return found;
            }
            generic = generic.getOwningClass();
        }
        return null;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        return this;
    }

    private String getUnresolvedName(boolean simplified) {
        String searchString = null;
        switch (this.ch) {
            case 84: {
                searchString = this.name;
                break;
            }
            case 42: {
                searchString = "java.lang.Object";
                break;
            }
            default: {
                if (this.name != null) {
                    if (simplified) {
                        int lastDollar;
                        int lastSlash = this.name.lastIndexOf(47);
                        if (lastSlash <= (lastDollar = this.name.lastIndexOf(36))) {
                            searchString = this.name.substring(lastDollar + 1);
                            break;
                        }
                        searchString = this.name.substring(lastSlash + 1);
                        break;
                    }
                    searchString = this.name;
                    searchString = searchString.replace('/', '.');
                    searchString = searchString.replace('$', '.');
                    break;
                }
                PrimitiveType primitive = PrimitiveType.PRIMITIVE_alpha[this.ch - 65];
                searchString = primitive.getName();
                break;
            }
        }
        int i = 0;
        while (i < this.array) {
            searchString = searchString + "[]";
            ++i;
        }
        return searchString;
    }

    @Override
    public String getSimplifiedName() {
        return this.getUnresolvedName(true);
    }

    @Override
    public String toString() {
        return this.getUnresolvedName(false);
    }

    private class InnerType {
        private final String name;
        protected List<JavaHasType> arguments;

        private void $init$() {
            this.arguments = Collections.EMPTY_LIST;
        }

        private InnerType(String name) {
            this.$init$();
            this.name = name;
        }

        static String ra$name(InnerType innerType) {
            return innerType.name;
        }

        InnerType(String string, 1 var3_3) {
            this(string);
        }

        public final class 1 {
        }
    }
}

