/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.SignatureHasType;
import oracle.javatools.parser.java.v2.common.SignatureParser;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickSignatureParser
extends SignatureParser<SignatureHasType> {
    private final JavaProvider provider;
    private final JavaIsGeneric owningGeneric;

    protected QuickSignatureParser(String text, JavaIsGeneric owningGeneric, JavaProvider provider) {
        super(text);
        this.owningGeneric = owningGeneric;
        this.provider = provider;
    }

    @Override
    protected SignatureHasType getUnboundedWildcard() {
        return new SignatureHasType('*', this.provider);
    }

    @Override
    protected SignatureHasType getBoundedWildcard(boolean extendsBound, SignatureHasType bound) {
        bound.bound = (byte)(extendsBound ? 1 : 2);
        return bound;
    }

    @Override
    protected void addTypeArgument(SignatureHasType baseType, SignatureHasType typeArgument) {
        baseType.pushTypeArgument(typeArgument);
    }

    @Override
    protected SignatureHasType getClassType(char ch, String name) {
        return new SignatureHasType(ch, name, this.provider);
    }

    @Override
    protected void pushInnerClassType(SignatureHasType baseType, String name) {
        baseType.pushInnerType(name);
    }

    @Override
    protected SignatureHasType getTypeVariable(String name) {
        return new SignatureHasType(name, this.owningGeneric, this.provider);
    }

    @Override
    protected SignatureHasType getArrayType(SignatureHasType type) {
        type.array = (short)(type.array + 1);
        return type;
    }

    @Override
    protected SignatureHasType getPrimitiveType(PrimitiveType primitive) {
        return new SignatureHasType(primitive.getDescriptor().charAt(0), this.provider);
    }
}

