/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Collection;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.AbstractMethod;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

public final class QuickMethod
extends AbstractMethod {
    private final JavaClass methodOwning;
    private final char methodAccess;
    private final JavaType methodReturnType;
    private final String methodName;
    private final Collection methodParameters;
    private final Collection methodExceptions;

    public static QuickMethod createMethod(JavaClass owning, char access, JavaType returnType, String name, Collection parameters, Collection exceptions) {
        return new QuickMethod(owning, access, returnType, name, parameters, exceptions);
    }

    public int getModifiers() {
        return this.methodAccess;
    }

    public JavaType getResolvedType() {
        return this.methodReturnType;
    }

    public UnresolvedType getUnresolvedType() {
        if (this.methodReturnType != null) {
            return this.methodReturnType.getUnresolvedType();
        }
        return QuickUnresolvedType.EMPTY_UNRESOLVED_TYPE;
    }

    public String getName() {
        return this.methodName;
    }

    public Collection getParameters() {
        return this.methodParameters;
    }

    public Collection getExceptions() {
        return this.methodExceptions;
    }

    public JavaClass getOwningClass() {
        return this.methodOwning;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    private QuickMethod(JavaClass owning, char access, JavaType returnType, String name, Collection parameters, Collection exceptions) {
        if (returnType == null) {
            returnType = PrimitiveType.PRIMITIVE_objects[9];
        }
        if (parameters == null) {
            parameters = JavaConstants.kEmptyCollection;
        }
        if (exceptions == null) {
            exceptions = JavaConstants.kEmptyCollection;
        }
        this.methodOwning = owning;
        this.methodAccess = access;
        this.methodReturnType = returnType;
        this.methodName = name;
        this.methodParameters = parameters;
        this.methodExceptions = exceptions;
        if (!parameters.isEmpty()) {
            for (Object o : parameters) {
                if (!(o instanceof QuickLocalVariable)) continue;
                QuickLocalVariable tmp = (QuickLocalVariable)o;
                tmp.setOwner(this);
            }
        }
    }
}

