/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.HashMap;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;

public final class PrimitiveType
extends AbstractClass
implements JavaConstants {
    public static final PrimitiveType[] PRIMITIVE_objects = new PrimitiveType[10];
    public static final PrimitiveType[] PRIMITIVE_lookup = new PrimitiveType[146 - 96];
    public static final PrimitiveType[] PRIMITIVE_alpha = new PrimitiveType[26];
    private static final HashMap PRIMITIVE_hashtable;
    private static final HashMap PRIMITIVE_unboxing;
    private static final int NARROWING_BIT = 16;
    private static final int WIDENING_BIT = 8;
    private static final int MASK_ID = 15;
    private static final int FL_INTEGER = 16;
    private static final int FL_NUMERIC = 32;
    private static int[] PRIMITIVE_flags;
    public final byte primCode;

    static {
        byte i = 0;
        while (i < 10) {
            String desc;
            char ch;
            PrimitiveType primitive;
            PrimitiveType.PRIMITIVE_objects[i] = primitive = new PrimitiveType(i);
            short tk = JavaConstants.PRIMITIVE_tokens[i];
            if (96 <= tk && tk < 146) {
                PrimitiveType.PRIMITIVE_lookup[tk - 96] = primitive;
            }
            if ('A' <= (ch = (desc = JavaConstants.PRIMITIVE_descriptors[i]).charAt(0)) && ch <= 'Z') {
                PrimitiveType.PRIMITIVE_alpha[ch - 65] = primitive;
            }
            i = (byte)(i + 1);
        }
        PRIMITIVE_hashtable = new HashMap();
        int i2 = 0;
        while (i2 < 10) {
            short tk = JavaConstants.PRIMITIVE_tokens[i2];
            if (96 <= tk && tk < 146) {
                String kw = JavaTokens.KW_words[tk - 96];
                PRIMITIVE_hashtable.put(kw, PRIMITIVE_objects[i2]);
            }
            i2 = (byte)(i2 + 1);
        }
        PRIMITIVE_unboxing = new HashMap();
        int i3 = 0;
        while (i3 < 10) {
            String autobox = JavaConstants.PRIMITIVE_autoboxes[i3];
            if (autobox != null) {
                PRIMITIVE_unboxing.put(autobox, PRIMITIVE_objects[i3]);
            }
            i3 = (byte)(i3 + 1);
        }
        PRIMITIVE_flags = new int[]{0, 64049, 717874, 456755, 978996, 2023477, 4112422, 8290343, 0, 0};
    }

    public static PrimitiveType lookupPrimitive(String name) {
        Object found = PRIMITIVE_hashtable.get(name);
        if (found == null) {
            return null;
        }
        return (PrimitiveType)found;
    }

    public static PrimitiveType applyUnboxingConversion(JavaType input) {
        String name = input.getVMName();
        if (!name.startsWith("java/lang/")) {
            return null;
        }
        return (PrimitiveType)PRIMITIVE_unboxing.get(name);
    }

    public static boolean isNumeric(PrimitiveType subject) {
        int flags = PRIMITIVE_flags[subject.primCode];
        return (flags & 0x20) != 0;
    }

    public static boolean applyWideningConversion(PrimitiveType subject, PrimitiveType target) {
        if (subject == null) {
            return false;
        }
        if (subject.primCode == target.primCode) {
            return true;
        }
        if (!PrimitiveType.isNumeric(subject) || !PrimitiveType.isNumeric(target)) {
            return false;
        }
        int subjectFlags = PRIMITIVE_flags[subject.primCode];
        int assignableBit = 1 << 8 + target.primCode;
        return (subjectFlags & assignableBit) != 0;
    }

    public static boolean applyNarrowingConversion(PrimitiveType subject, PrimitiveType target) {
        if (subject == null) {
            return false;
        }
        if (subject.primCode == target.primCode) {
            return true;
        }
        if (!PrimitiveType.isNumeric(subject) || !PrimitiveType.isNumeric(target)) {
            return false;
        }
        int subjectFlags = PRIMITIVE_flags[subject.primCode];
        int assignableBit = 1 << 16 + target.primCode;
        return (subjectFlags & assignableBit) != 0;
    }

    public boolean isNumeric() {
        return 1 <= this.primCode && this.primCode <= 7;
    }

    public boolean isIntegral() {
        return 1 <= this.primCode && this.primCode <= 5;
    }

    public boolean isFloatingPoint() {
        return this.primCode == 6 || this.primCode == 7;
    }

    public JavaFile getFile() {
        return null;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getVMName() {
        return this.getName();
    }

    public String getName() {
        short tk = JavaConstants.PRIMITIVE_tokens[this.primCode];
        if (tk != 15) {
            return JavaTokens.KW_words[tk - 96];
        }
        return "null";
    }

    public String getDescriptor() {
        return JavaConstants.PRIMITIVE_descriptors[this.primCode];
    }

    public String getTypeSignature() {
        return this.getDescriptor();
    }

    public String getSignature() {
        return this.getDescriptor();
    }

    public int getModifiers() {
        return 17;
    }

    public boolean isPrimitive() {
        return true;
    }

    protected PrimitiveType(byte code) {
        this.primCode = code;
    }
}

