/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.common.AbstractField;
import oracle.javatools.parser.java.v2.common.AbstractMethod;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

final class ArrayType
extends AbstractClass
implements JavaConstants {
    private final JavaProvider provider;
    private final JavaType arrayComponent;
    private JavaField[] arrayFields;
    private JavaMethod[] arrayMethods;
    private Collection arrayInterfaces;

    private void $init$() {
        this.arrayFields = null;
        this.arrayMethods = null;
        this.arrayInterfaces = null;
    }

    public ArrayType(JavaProvider provider, JavaType componentType) {
        this.$init$();
        this.provider = provider;
        this.arrayComponent = componentType;
    }

    public JavaFile getFile() {
        return null;
    }

    public boolean isArray() {
        return true;
    }

    public JavaType getComponentType() {
        return this.arrayComponent;
    }

    public int getArrayDimensions() {
        JavaType type = this.arrayComponent;
        if (type == null) {
            return 1;
        }
        int count = 1;
        JavaType nextType = type.getComponentType();
        while (nextType != null && nextType != type) {
            if (++count > 255) {
                return 255;
            }
            type = nextType;
            nextType = type.getComponentType();
        }
        return count;
    }

    public JavaType getBaseComponentType() {
        JavaType type = this.arrayComponent;
        if (type == null) {
            return null;
        }
        int count = 1;
        JavaType nextType = type.getComponentType();
        while (nextType != null) {
            if (nextType == type) {
                return null;
            }
            if (++count > 255) {
                return null;
            }
            type = nextType;
            nextType = type.getComponentType();
        }
        return type;
    }

    public JavaClass getTypeErasure() {
        if (this.arrayComponent == null) {
            return null;
        }
        JavaClass componentErasure = this.arrayComponent.getTypeErasure();
        if (componentErasure == this.arrayComponent) {
            return this;
        }
        return new ArrayType(this.provider, componentErasure);
    }

    public String getName() {
        if (this.arrayComponent != null) {
            return this.arrayComponent.getName() + "[]";
        }
        return "Object[]";
    }

    public String getUnqualifiedName() {
        if (this.arrayComponent != null) {
            return this.arrayComponent.getUnqualifiedName() + "[]";
        }
        return "Object[]";
    }

    public String getQualifiedName() {
        if (this.arrayComponent != null) {
            return this.arrayComponent.getQualifiedName() + "[]";
        }
        return "java.lang.Object[]";
    }

    public String getVMName() {
        if (this.arrayComponent != null) {
            return this.arrayComponent.getVMName() + "[]";
        }
        return "java/lang/Object[]";
    }

    public String getDescriptor() {
        if (this.arrayComponent != null) {
            return '[' + this.arrayComponent.getDescriptor();
        }
        return "[Ljava/lang/Object;";
    }

    public String getTypeSignature() {
        if (this.arrayComponent != null) {
            return '[' + this.arrayComponent.getTypeSignature();
        }
        return this.getDescriptor();
    }

    public String getSignature() {
        if (this.arrayComponent != null) {
            return '[' + this.arrayComponent.getSignature();
        }
        return this.getDescriptor();
    }

    public JavaType getSuperclass() {
        if (this.provider != null) {
            return this.provider.getClassByVMName("java/lang/Object");
        }
        return null;
    }

    public Collection getInterfaces() {
        if (this.arrayInterfaces == null) {
            if (this.provider != null) {
                ArrayList<JavaClass> list = new ArrayList<JavaClass>();
                int count = JavaConstants.ARRAY_implements.length;
                int i = 0;
                while (i < count) {
                    JavaClass type = this.provider.getClassByVMName(JavaConstants.ARRAY_implements[i]);
                    if (type != null) {
                        list.add(type);
                    }
                    ++i;
                }
                if (!list.isEmpty()) {
                    this.arrayInterfaces = list;
                }
            }
            if (this.arrayInterfaces == null) {
                this.arrayInterfaces = JavaConstants.kEmptyCollection;
            }
        }
        return this.arrayInterfaces;
    }

    public Collection getDeclaredFields() {
        if (this.arrayFields == null) {
            JavaField[] fields = new JavaField[]{new ArrayLength(null)};
            this.arrayFields = fields;
        }
        return Arrays.asList(this.arrayFields);
    }

    public Collection getDeclaredMethods() {
        if (this.arrayMethods == null) {
            JavaMethod[] methods = new JavaMethod[]{new ArrayClone(null)};
            this.arrayMethods = methods;
        }
        return Arrays.asList(this.arrayMethods);
    }

    static JavaProvider ra$provider(ArrayType arrayType) {
        return arrayType.provider;
    }

    private class ArrayLength
    extends AbstractField {
        public JavaClass getOwningClass() {
            return ArrayType.this;
        }

        public JavaType getResolvedType() {
            return PrimitiveType.PRIMITIVE_objects[4];
        }

        public UnresolvedType getUnresolvedType() {
            return this.getResolvedType().getUnresolvedType();
        }

        public String getName() {
            return "length";
        }

        public int getModifiers() {
            return 17;
        }

        private ArrayLength() {
        }

        ArrayLength(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ArrayClone
    extends AbstractMethod {
        public JavaClass getOwningClass() {
            return ArrayType.this;
        }

        public JavaType getResolvedType() {
            if (ArrayType.ra$provider(ArrayType.this) != null) {
                return ArrayType.ra$provider(ArrayType.this).getClassByVMName("java/lang/Object");
            }
            return null;
        }

        public UnresolvedType getUnresolvedType() {
            JavaType type = this.getResolvedType();
            if (type != null) {
                return type.getUnresolvedType();
            }
            return QuickUnresolvedType.EMPTY_UNRESOLVED_TYPE;
        }

        public String getName() {
            return "clone";
        }

        public String getDescriptor() {
            return "()Ljava/lang/Object;";
        }

        public int getModifiers() {
            return 17;
        }

        private ArrayClone() {
        }

        ArrayClone(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

