/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;

public abstract class AbstractField
extends AbstractElement
implements JavaField {
    public abstract int getModifiers();

    public abstract JavaClass getOwningClass();

    public abstract String getName();

    public abstract JavaType getResolvedType();

    public JavaFile getFile() {
        JavaClass owning = this.getOwningClass();
        if (owning != null) {
            return owning.getFile();
        }
        return null;
    }

    public int getElementKind() {
        return 5;
    }

    public JavaElement getOwner() {
        return this.getOwningClass();
    }

    public boolean isVarargs() {
        return false;
    }

    public Object getConstantValue() {
        return null;
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    public boolean equals(Object o) {
        if (o instanceof JavaField) {
            return CommonUtilities.equals(this, (JavaField)o);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    public String printCompiledInfo() {
        JavaClass owningClass = this.getOwningClass();
        if (owningClass == null) {
            return "<unknown>" + '.' + this.getName();
        }
        return owningClass.getVMName() + '.' + this.getName();
    }
}

