/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import oracle.javatools.parser.java.v2.classfile.Convert;
import oracle.javatools.parser.java.v2.classfile.Name;

public final class NamePool {
    public static final NamePool global = new NamePool();
    private static final int NAME_MAX_COUNT = 65536;
    private static final int HASH_SIZE = 16384;
    private static final int HASH_MASK = 16383;
    public byte[] data;
    private int byteCount;
    private final Name[] hashtable;
    public int count;

    private void $init$() {
        this.data = new byte[65536];
        this.byteCount = 0;
        this.hashtable = new Name[16384];
        this.count = 0;
    }

    private static int hashValue(byte[] data, int offset, int len) {
        int h = 0;
        int i = 0;
        while (i < len) {
            h = h * 1664525 + data[offset + i];
            ++i;
        }
        return h;
    }

    synchronized int hashValue(Name n) {
        return NamePool.hashValue(this.data, n.index, n.length);
    }

    private boolean equals(int offset, byte[] cs, int otherOffset, int length) {
        int i = 0;
        while (i < length) {
            if (this.data[offset + i] != cs[otherOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(Name one, Name other) {
        if (one == null || other == null) {
            return false;
        }
        if (one.owningPool == other.owningPool) {
            return one.index == other.index;
        }
        if (one.length != other.length) {
            return false;
        }
        return one.owningPool.equals(one.index, one.length, other.owningPool, other.index);
    }

    private synchronized boolean equals(int offset, int length, NamePool other, int otherOffset) {
        int i = 0;
        while (i < length) {
            if (this.data[offset + i] != other.data[otherOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized Name fromUTF(byte[] cs, int offset, int len) {
        int h = NamePool.hashValue(cs, offset, len) & 0x3FFF;
        Name n = this.hashtable[h];
        while (!(n == null || n.length == len && this.equals(n.index, cs, offset, len))) {
            n = n.next;
        }
        if (n == null) {
            n = new Name(this, this.byteCount, len);
            n.next = this.hashtable[h];
            this.hashtable[h] = n;
            int i = 0;
            while (i < len) {
                if (this.byteCount == this.data.length) {
                    byte[] newdata = new byte[this.data.length * 2];
                    System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                    this.data = newdata;
                }
                this.data[this.byteCount++] = cs[offset + i];
                ++i;
            }
            if (len == 0) {
                ++this.byteCount;
            }
        }
        return n;
    }

    public Name fromUTF(byte[] cs) {
        return this.fromUTF(cs, 0, cs.length);
    }

    public Name fromSource(byte[] cs, int offset, int len) {
        int slen = Convert.source2ascii_inplace(cs, offset, len);
        return this.fromUTF(Convert.ascii, 0, slen);
    }

    public Name fromString(String s) {
        byte[] source = Convert.string2source(s);
        Name n = this.fromSource(source, 0, source.length);
        n.string = s;
        return n;
    }

    synchronized byte[] toUTF(Name n) {
        byte[] ascii = new byte[n.length];
        System.arraycopy(this.data, n.index, ascii, 0, n.length);
        return ascii;
    }

    synchronized byte[] toSource(Name n) {
        return Convert.string2source(this.toString(n));
    }

    synchronized String toString(Name n) {
        return Convert.ascii2string(this.data, n.index, n.length);
    }

    public NamePool() {
        this.$init$();
    }
}

