/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.io.PrintStream;
import java.net.URL;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.classfile.ClassConstants;
import oracle.javatools.parser.java.v2.classfile.Name;
import oracle.javatools.parser.java.v2.classfile.NamePool;
import oracle.javatools.parser.java.v2.classfile.NameType;
import oracle.javatools.parser.java.v2.common.CommonUtilities;

public final class ClassFile
implements ClassConstants {
    private static final ClassField[] EMPTY_FIELD_ARRAY = new ClassField[0];
    private static final ClassMethod[] EMPTY_METHOD_ARRAY = new ClassMethod[0];
    private static final ClassAnnotation[] EMPTY_ANNOTATION_ARRAY = new ClassAnnotation[0];
    private static final ComponentValue[] EMPTY_VALUE_ARRAY = new ComponentValue[0];
    private static final ClassAnnotation[][] EMPTY_ANNOTATION_ARRAY_ARRAY = new ClassAnnotation[0][];
    private static final int PROCESSED = Integer.MIN_VALUE;
    private static final int DEPRECATED = 65536;
    private static final int HIDDEN_ATTR = 0x20000000;
    private static final Name[] ATTRIBUTE_names;
    private static final byte[] ATTRIBUTE_indices;
    private static final Name kInitS;
    private static final Name kClinitS;
    private static final Name kJavaLangObjectS;
    private byte[] buffer;
    private int bp;
    private int[] poolIdx;
    private Object[] poolObj;
    private int implBp;
    private int fieldBp;
    private int methodBp;
    private int attrBp;
    private URL url;
    private int modifiers;
    private Name thisClassName;
    private Name sourceFilename;
    private Name classSignature;
    private NameType baseClass;
    private NameType[] baseInterfaces;
    private ClassField[] fields;
    private ClassMethod clinit;
    private ClassMethod[] methods;
    private ClassMethod[] constructors;
    private NameType outerClass;
    private NameType[] innerClasses;
    private ClassAnnotation[] classAnnotations;
    public static int ___constant_pool;
    public static final int ___inner_classes = 0;
    private static final int kMember_AttrPos = 6;

    static {
        int count = 18;
        ATTRIBUTE_names = new Name[18];
        int max = 0;
        int i = 0;
        while (i < 18) {
            Name name = NamePool.global.fromString(ClassConstants.ATTRIBUTE_words[i]);
            if (max < name.index) {
                max = name.index;
            }
            ClassFile.ATTRIBUTE_names[i] = name;
            ++i;
        }
        ATTRIBUTE_indices = new byte[max + 1];
        int i2 = 0;
        while (i2 < 18) {
            Name name = ATTRIBUTE_names[i2];
            ClassFile.ATTRIBUTE_indices[name.index] = (byte)(i2 + 1);
            ++i2;
        }
        kInitS = NamePool.global.fromString("<init>");
        kClinitS = NamePool.global.fromString("<clinit>");
        kJavaLangObjectS = NamePool.global.fromString("java/lang/Object");
        ___constant_pool = 0;
    }

    private static final byte name2attribute(Name name) {
        int index = name.index;
        if (0 <= index && index < ATTRIBUTE_indices.length) {
            return ATTRIBUTE_indices[index];
        }
        return 0;
    }

    private void $init$() {
        this.implBp = 0;
        this.fieldBp = 0;
        this.methodBp = 0;
        this.attrBp = 0;
        this.sourceFilename = null;
        this.classSignature = null;
        this.baseClass = null;
        this.baseInterfaces = null;
        this.fields = null;
        this.clinit = null;
        this.methods = null;
        this.constructors = null;
        this.outerClass = null;
        this.innerClasses = null;
        this.classAnnotations = null;
    }

    public ClassFile(byte[] buffer, URL url) {
        block2: {
            this.$init$();
            this.buffer = buffer;
            this.url = url;
            try {
                this.readHeader();
                this.indexFields();
                this.indexMethods();
                this.readClassAttributes();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (url == null) break block2;
                System.err.println("Error when processing " + url);
            }
        }
    }

    public ClassFile(byte[] buffer) {
        this(buffer, null);
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getSignature() {
        if (this.classSignature != null) {
            return this.classSignature.toString();
        }
        return null;
    }

    public boolean isDeprecated() {
        this.readClassAttributes();
        return (this.modifiers & 0x10000) != 0;
    }

    public boolean isHidden() {
        this.readClassAttributes();
        return (this.modifiers & 0x20000000) != 0;
    }

    public String getFullClassName() {
        return this.thisClassName.toString();
    }

    public NameType getBaseClass() {
        return this.baseClass;
    }

    public NameType[] getBaseInterfaces() {
        if (this.baseInterfaces == null) {
            this.readBaseInterfaces();
        }
        return this.baseInterfaces;
    }

    public NameType getOuterClass() {
        if (this.outerClass == null) {
            this.readClassAttributes();
        }
        return this.outerClass;
    }

    public ClassField[] getDeclaredFields() {
        if (this.fields == null) {
            this.readFields();
        }
        return this.fields;
    }

    public ClassMethod[] getDeclaredMethods() {
        if (this.methods == null) {
            this.readMethods();
        }
        return this.methods;
    }

    public ClassMethod[] getDeclaredConstructors() {
        if (this.constructors == null) {
            this.readMethods();
        }
        return this.constructors;
    }

    public ClassMethod getClinitMethod() {
        if (this.methods == null) {
            this.readMethods();
        }
        return this.clinit;
    }

    public NameType[] getDeclaredInnerClasses() {
        if (this.innerClasses == null) {
            this.readClassAttributes();
        }
        return this.innerClasses;
    }

    public ClassAnnotation[] getDeclaredAnnotations() {
        if (this.classAnnotations == null) {
            this.readClassAttributes();
        }
        return this.classAnnotations;
    }

    public String getSourceFilename() {
        if (this.sourceFilename == null) {
            return null;
        }
        return this.sourceFilename.toString();
    }

    public URL getURL() {
        return this.url;
    }

    private void readHeader() {
        int magic = this.nextInt();
        if (magic != -889275714) {
            this.fileError("Bad magic number");
        }
        char minorVersion = this.nextChar();
        char majorVersion = this.nextChar();
        if (majorVersion * 100 + minorVersion < 4503) {
            this.fileError("Wrong version");
        }
        this.indexConstantPool();
        this.modifiers = this.nextChar();
        this.thisClassName = (Name)this.readPoolObject(this.nextChar());
        this.baseClass = this.readPoolClass(this.nextChar());
        this.implBp = this.bp;
        char interfaceCount = this.nextChar();
        this.bp += 2 * interfaceCount;
        this.fieldBp = this.bp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexFields() {
        ClassFile classFile = this;
        synchronized (classFile) {
            int fieldCount = this.nextChar();
            int i = 0;
            while (i < fieldCount) {
                this.skipFieldOrMethod();
                ++i;
            }
            this.methodBp = this.bp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexMethods() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.methodBp == 0) {
                this.indexFields();
            }
            this.bp = this.methodBp;
            int methodCount = this.nextChar();
            int i = 0;
            while (i < methodCount) {
                this.skipFieldOrMethod();
                ++i;
            }
            this.attrBp = this.bp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBaseInterfaces() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.baseInterfaces != null) {
                return;
            }
            int savedBp = this.bp;
            this.bp = this.implBp;
            int interfaceCount = this.nextChar();
            NameType[] newBaseInterfaces = new NameType[interfaceCount];
            int i = 0;
            while (i < interfaceCount) {
                NameType n = this.readPoolClass(this.nextChar());
                if (n == null) {
                    String message = "Invalid reference found in: " + this.url;
                    this.fileError(message);
                } else {
                    newBaseInterfaces[i] = n;
                }
                ++i;
            }
            this.bp = savedBp;
            this.baseInterfaces = newBaseInterfaces;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFields() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.fields != null) {
                return;
            }
            int savedBp = this.bp;
            this.bp = this.fieldBp;
            int fieldCount = this.nextChar();
            ClassField[] newFields = ClassFile.createFieldArray(fieldCount);
            int i = 0;
            while (i < fieldCount) {
                newFields[i] = new ClassField(null);
                ++i;
            }
            if (this.methodBp == 0) {
                this.methodBp = this.bp;
            } else {
                this.bp = savedBp;
            }
            this.fields = newFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMethods() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.methods != null) {
                return;
            }
            int savedBp = this.bp;
            if (this.methodBp == 0) {
                this.indexFields();
            }
            this.bp = this.methodBp;
            int methodCount = this.nextChar();
            if (methodCount == 0) {
                this.methods = EMPTY_METHOD_ARRAY;
                this.constructors = EMPTY_METHOD_ARRAY;
                this.clinit = null;
            } else {
                ClassMethod[] allMethods = new ClassMethod[methodCount];
                int nConstructors = 0;
                int nClInit = 0;
                int i = 0;
                while (i < methodCount) {
                    ClassMethod m;
                    allMethods[i] = m = new ClassMethod(null);
                    if (m.isConstructor()) {
                        ++nConstructors;
                    } else if (m.isClinit()) {
                        ++nClInit;
                    }
                    ++i;
                }
                ClassMethod[] newMethods = ClassFile.createMethodArray(methodCount - nConstructors - nClInit);
                ClassMethod[] newConstructors = ClassFile.createMethodArray(nConstructors);
                ClassMethod newClinit = null;
                int m = 0;
                int c = 0;
                int i2 = 0;
                while (i2 < methodCount) {
                    ClassMethod method = allMethods[i2];
                    if (method.isConstructor()) {
                        newConstructors[c++] = method;
                    } else if (method.isClinit()) {
                        if (newClinit != null) {
                            // empty if block
                        }
                        newClinit = method;
                    } else {
                        newMethods[m++] = method;
                    }
                    ++i2;
                }
                this.constructors = newConstructors;
                this.clinit = newClinit;
                this.methods = newMethods;
            }
            if (this.attrBp == 0) {
                this.attrBp = this.bp;
            } else {
                this.bp = savedBp;
            }
        }
    }

    private void readInnerClasses() {
        int count = this.nextChar();
        NameType[] preliminary = new NameType[count];
        int actual = 0;
        while (count-- > 0) {
            NameType inner = this.readPoolClass(this.nextChar());
            NameType outer = this.readPoolClass(this.nextChar());
            this.bp += 2;
            char flags = this.nextChar();
            if (outer != null && outer.name.index == this.thisClassName.index) {
                preliminary[actual++] = inner;
                continue;
            }
            if (inner == null || inner.name.index != this.thisClassName.index) continue;
            int tmpMods = this.modifiers & 0xFFFFFFFE;
            this.outerClass = outer;
            this.modifiers = tmpMods | flags & 0xF;
        }
        if (actual == 0) {
            this.innerClasses = NameType.EMPTY_ARRAY;
        } else {
            this.innerClasses = new NameType[actual];
            System.arraycopy(preliminary, 0, this.innerClasses, 0, actual);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClassAttributes() {
        if ((this.modifiers & Integer.MIN_VALUE) != 0) {
            return;
        }
        ClassFile classFile = this;
        synchronized (classFile) {
            int savedBp = this.bp;
            if (this.attrBp == 0) {
                this.indexMethods();
            }
            try {
                this.bp = this.attrBp;
                int attrCount = this.nextChar();
                int i = 0;
                while (i < attrCount) {
                    char attrIndex = this.nextChar();
                    int attrLen = this.nextInt();
                    int attrSavedBp = this.bp;
                    Name attrName = this.readPoolName(attrIndex);
                    byte attribute = ClassFile.name2attribute(attrName);
                    switch (attribute) {
                        case 4: {
                            this.modifiers |= 0x10000;
                            break;
                        }
                        case 18: {
                            this.modifiers |= 0x20000000;
                            break;
                        }
                        case 15: {
                            this.classSignature = this.readPoolExternal(this.nextChar());
                            break;
                        }
                        case 17: {
                            this.modifiers |= 0x1000;
                            break;
                        }
                        case 11: 
                        case 13: {
                            this.classAnnotations = this.readAnnotations(this.classAnnotations);
                            int endBp = attrSavedBp + attrLen;
                            if (this.bp != endBp) {
                                this.fileError("Invalid annotations length");
                            }
                            this.bp = endBp;
                            break;
                        }
                        case 16: {
                            this.sourceFilename = this.readPoolName(this.nextChar());
                            break;
                        }
                        case 7: {
                            this.readInnerClasses();
                            break;
                        }
                        default: {
                            this.bp += attrLen;
                            break;
                        }
                    }
                    ++i;
                }
                if (this.innerClasses == null) {
                    this.innerClasses = NameType.EMPTY_ARRAY;
                }
                if (this.classAnnotations == null) {
                    this.classAnnotations = EMPTY_ANNOTATION_ARRAY;
                }
                this.modifiers |= Integer.MIN_VALUE;
            }
            finally {
                this.bp = savedBp;
            }
        }
    }

    private void indexConstantPool() {
        int entryCount = this.nextChar();
        this.poolIdx = new int[entryCount];
        this.poolObj = new Object[entryCount];
        int i = 1;
        while (i < entryCount) {
            this.poolIdx[i++] = this.bp;
            byte tag = this.buffer[this.bp++];
            switch (tag) {
                case 1: 
                case 2: {
                    char len = this.nextChar();
                    this.bp += len;
                    break;
                }
                case 7: 
                case 8: {
                    this.bp += 2;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.bp += 4;
                    break;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++i;
                    break;
                }
                default: {
                    this.fileError("Bad constant pool tag: " + tag);
                    break;
                }
            }
        }
    }

    private Object readPoolObject(int poolIndex) {
        Object o;
        if (poolIndex < 0 || this.poolObj.length <= poolIndex) {
            this.fileError("Invalid pool index");
        }
        if (this.poolObj[poolIndex] != null) {
            return this.poolObj[poolIndex];
        }
        int byteIndex = this.poolIdx[poolIndex];
        if (byteIndex == 0) {
            return null;
        }
        this.poolObj[poolIndex] = o = this.readPoolObjectImpl(byteIndex);
        return o;
    }

    private Object readPoolObjectImpl(int byteIndex) {
        byte tag = this.buffer[byteIndex];
        switch (tag) {
            case 1: {
                return NamePool.global.fromUTF(this.buffer, byteIndex + 3, this.getChar(byteIndex + 1));
            }
            case 7: {
                return this.readPoolExternal(this.getChar(byteIndex + 1));
            }
            case 2: {
                this.fileError("Can't read unicode");
                break;
            }
            case 8: {
                Name n = (Name)this.readPoolObject(this.getChar(byteIndex + 1));
                return n.toString();
            }
            case 3: {
                int i = this.getInt(byteIndex + 1);
                return new Integer(i);
            }
            case 4: {
                float f = Float.intBitsToFloat(this.getInt(byteIndex + 1));
                return new Float(f);
            }
            case 5: {
                long l = this.getLong(byteIndex + 1);
                return new Long(l);
            }
            case 6: {
                double d = Double.longBitsToDouble(this.getLong(byteIndex + 1));
                return new Double(d);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.fileError("Shouldn't be handling these attributes: " + tag);
                break;
            }
            default: {
                this.fileError("Bad constant pool tag: " + tag);
                break;
            }
        }
        return null;
    }

    private Object readPoolConstant(int poolIndex, char descriptor) {
        switch (descriptor) {
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 's': {
                return this.readPoolObject(poolIndex);
            }
            case 'c': {
                Name name = this.readPoolName(poolIndex);
                return NameType.getTypeFor(name);
            }
            case '@': 
            case '[': 
            case 'e': {
                CommonUtilities.panic("May not read a '" + descriptor + "' directly from the pool.");
                return null;
            }
        }
        Integer i = (Integer)this.readPoolObject(poolIndex);
        switch (descriptor) {
            case 'S': {
                return new Short((short)i.intValue());
            }
            case 'C': {
                return new Character((char)i.intValue());
            }
            case 'B': {
                return new Byte((byte)i.intValue());
            }
            case 'Z': {
                if (i == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        this.fileError("Invalid type for a ConstantValue attribute");
        return null;
    }

    private Name readPoolName(int poolIndex) {
        return (Name)this.readPoolObject(poolIndex);
    }

    private Name readPoolExternal(int poolIndex) {
        if (this.poolObj[poolIndex] == null) {
            int byteIndex = this.poolIdx[poolIndex];
            if (this.buffer[byteIndex] == 1) {
                this.poolObj[poolIndex] = NamePool.global.fromUTF(this.buffer, byteIndex + 3, this.getChar(byteIndex + 1));
            } else {
                ClassFile.internalError("readExternal");
            }
        }
        return (Name)this.poolObj[poolIndex];
    }

    private NameType readPoolClass(int poolIndex) {
        Name name;
        if (poolIndex == 0) {
            return null;
        }
        int byteIndex = this.poolIdx[poolIndex];
        if (this.buffer[byteIndex] != 7) {
            this.fileError("readClassAtIndex");
        }
        if ((name = (Name)this.readPoolObject(poolIndex)) != null) {
            return NameType.getTypeFor(name);
        }
        return null;
    }

    private byte nextByte() {
        return this.buffer[this.bp++];
    }

    private char nextChar() {
        int b = this.bp;
        char ch = (char)((this.buffer[b] & 0xFF) << 8 | this.buffer[b + 1] & 0xFF);
        this.bp += 2;
        return ch;
    }

    private int nextInt() {
        int b = this.bp;
        int i = (this.buffer[b] & 0xFF) << 24 | (this.buffer[b + 1] & 0xFF) << 16 | (this.buffer[b + 2] & 0xFF) << 8 | this.buffer[b + 3] & 0xFF;
        this.bp += 4;
        return i;
    }

    private char getChar(int b) {
        return (char)((this.buffer[b] & 0xFF) << 8 | this.buffer[b + 1] & 0xFF);
    }

    private int getInt(int b) {
        return (this.buffer[b] & 0xFF) << 24 | (this.buffer[b + 1] & 0xFF) << 16 | (this.buffer[b + 2] & 0xFF) << 8 | this.buffer[b + 3] & 0xFF;
    }

    private long getLong(int b) {
        long hi = this.getInt(b);
        long lo = this.getInt(b + 4);
        return hi << 32 | lo;
    }

    public final void dump(PrintStream out) {
        String filename;
        int mods = this.getModifiers();
        ClassFile.dumpModifiers(out, mods, true, false);
        if ((mods & 0x2000) != 0) {
            out.print("@interface ");
        } else if ((mods & 0x200) != 0) {
            out.print("interface ");
        } else if ((mods & 0x4000) != 0) {
            out.print("enum ");
        } else {
            out.print("class ");
        }
        out.println(this.getFullClassName());
        out.println("  extends " + this.getBaseClass().toString());
        NameType[] interfaces = this.getBaseInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            out.println("  implements " + interfaces[i].toString());
            ++i;
        }
        String signature = this.getSignature();
        if (signature != null) {
            out.println("  signature: " + signature);
        }
        if ((filename = this.getSourceFilename()) != null) {
            out.println("SourceFile: " + filename);
        }
        ClassFile.dumpAnnotations(out, this.getDeclaredAnnotations());
        out.println();
        this.dumpConstantPool(out);
        this.readClassAttributes();
        this.dumpAttributes(this.attrBp);
        out.println("Fields:");
        ClassField[] fields = this.getDeclaredFields();
        int i2 = 0;
        while (i2 < fields.length) {
            fields[i2].dump(out);
            ++i2;
        }
        out.println();
        out.println("Constructors:");
        ClassMethod[] constructors = this.getDeclaredConstructors();
        int i3 = 0;
        while (i3 < constructors.length) {
            constructors[i3].dump(out);
            ++i3;
        }
        out.println();
        out.println("Methods:");
        ClassMethod[] methods = this.getDeclaredMethods();
        int i4 = 0;
        while (i4 < methods.length) {
            methods[i4].dump(out);
            ++i4;
        }
        out.println();
    }

    private void dumpConstantPool(PrintStream out) {
        out.println("Constant pool:");
        int i = 1;
        while (i < this.poolIdx.length) {
            out.print(i + "\t");
            this.dumpPoolObject(out, i);
            out.println();
            int byteIndex = this.poolIdx[i];
            byte tag = this.buffer[byteIndex];
            if (tag == 5 || tag == 6) {
                ++i;
            }
            ++i;
        }
        out.println();
    }

    private void dumpPoolObject(PrintStream out, int poolIndex) {
        int byteIndex = this.poolIdx[poolIndex];
        byte tag = this.buffer[byteIndex];
        switch (tag) {
            case 1: {
                out.print("(Utf8) ");
                break;
            }
            case 7: {
                char ref = this.getChar(byteIndex + 1);
                out.print("(Class) #" + ref + ": ");
                break;
            }
            case 2: {
                out.print("(Unicode) ??");
                return;
            }
            case 8: {
                char ref = this.getChar(byteIndex + 1);
                out.print("(String) #" + ref + ": ");
                break;
            }
            case 3: {
                out.print("(Integer) ");
                break;
            }
            case 4: {
                out.print("(Float) ");
                break;
            }
            case 5: {
                out.print("(Long) ");
                break;
            }
            case 6: {
                out.print("(Double) ");
                break;
            }
            case 12: {
                char nameref = this.getChar(byteIndex + 1);
                char typeref = this.getChar(byteIndex + 3);
                out.print("(NameandTypeRef) ");
                out.print("#" + nameref + " #" + typeref + ": ");
                break;
            }
            case 9: {
                out.print("(Fieldref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                out.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            case 10: {
                out.print("(Methodref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                out.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            case 11: {
                out.print("(InterfaceMethodref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                out.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            default: {
                this.fileError("Bad constant pool tag: " + tag);
                break;
            }
        }
        this.dumpPoolObjectImpl(out, poolIndex);
    }

    private void dumpPoolObjectImpl(PrintStream out, int poolIndex) {
        block6: {
            int byteIndex = this.poolIdx[poolIndex];
            byte tag = this.buffer[byteIndex];
            switch (tag) {
                case 7: {
                    char ref = this.getChar(byteIndex + 1);
                    this.dumpPoolObjectImpl(out, ref);
                    return;
                }
                case 8: {
                    char ref = this.getChar(byteIndex + 1);
                    this.dumpPoolObjectImpl(out, ref);
                    return;
                }
                case 12: {
                    char nameref = this.getChar(byteIndex + 1);
                    char typeref = this.getChar(byteIndex + 3);
                    this.dumpPoolObjectImpl(out, nameref);
                    out.print(", ");
                    this.dumpPoolObjectImpl(out, typeref);
                    return;
                }
                case 9: 
                case 10: 
                case 11: {
                    char classref = this.getChar(byteIndex + 1);
                    char nametyperef = this.getChar(byteIndex + 3);
                    this.dumpPoolObjectImpl(out, classref);
                    out.print(".");
                    this.dumpPoolObjectImpl(out, nametyperef);
                    return;
                }
            }
            Object o = this.readPoolObject(poolIndex);
            if (o == null) break block6;
            out.print(o);
        }
    }

    private static void dumpModifiers(PrintStream out, int modifiers, boolean isClass, boolean isField) {
        if ((modifiers & 1) != 0) {
            out.print("public ");
        }
        if ((modifiers & 2) != 0) {
            out.print("private ");
        }
        if ((modifiers & 4) != 0) {
            out.print("protected ");
        }
        if ((modifiers & 8) != 0) {
            out.print("static ");
        }
        if ((modifiers & 0x10) != 0) {
            out.print("final ");
        }
        if (!isClass && (modifiers & 0x20) != 0) {
            out.print("synchronized ");
        }
        if (isField) {
            if ((modifiers & 0x40) != 0) {
                out.print("volatile ");
            }
            if ((modifiers & 0x80) != 0) {
                out.print("transient ");
            }
        }
        if ((modifiers & 0x100) != 0) {
            out.print("native ");
        }
        if ((modifiers & 0x400) != 0) {
            out.print("abstract ");
        }
        if ((modifiers & 0x800) != 0) {
            out.print("strictfp ");
        }
        if ((modifiers & 0x1000) != 0) {
            out.print("(synthetic) ");
        }
        if ((modifiers & 0x2000) != 0) {
            out.print("(annotation) ");
        }
        if ((modifiers & 0x4000) != 0) {
            out.print("(enum) ");
        }
        if ((modifiers & 0x10000) != 0) {
            out.print("@deprecated ");
        }
        if ((modifiers & 0x20000000) != 0) {
            out.print("@hidden ");
        }
    }

    private static void dumpAnnotations(PrintStream out, ClassAnnotation[] a) {
        if (a.length == 0) {
            return;
        }
        int i = 0;
        while (i < a.length) {
            a[i].dump(out);
            ++i;
        }
    }

    private static ClassField[] createFieldArray(int size) {
        if (size == 0) {
            return EMPTY_FIELD_ARRAY;
        }
        return new ClassField[size];
    }

    private static ClassMethod[] createMethodArray(int size) {
        if (size == 0) {
            return EMPTY_METHOD_ARRAY;
        }
        return new ClassMethod[size];
    }

    private void skipFieldOrMethod() {
        this.bp += 6;
        int attrCount = this.nextChar();
        int i = 0;
        while (i < attrCount) {
            this.bp += 2;
            int attrLen = this.nextInt();
            this.bp += attrLen;
            ++i;
        }
    }

    private void skipAnnotation() {
        this.bp += 2;
        int count = this.nextChar();
        int i = 0;
        while (i < count) {
            this.skipComponent();
            ++i;
        }
    }

    private void skipComponent() {
        this.bp += 2;
        this.skipComponentValue();
    }

    private void skipComponentValue() {
        byte tag = this.nextByte();
        this.skipValue(tag);
    }

    private void skipValue(byte componentTag) {
        switch (componentTag) {
            case 64: {
                this.skipAnnotation();
                break;
            }
            case 91: {
                int count = this.nextChar();
                int i = 0;
                while (i < count) {
                    this.skipComponentValue();
                    ++i;
                }
                break;
            }
            case 101: {
                this.bp += 4;
                break;
            }
            default: {
                this.bp += 2;
                break;
            }
        }
    }

    private ClassAnnotation[] readAnnotations(ClassAnnotation[] oldArray) {
        int oldCount;
        int count;
        if (oldArray == null) {
            oldArray = EMPTY_ANNOTATION_ARRAY;
        }
        ClassAnnotation[] newArray = (count = (oldCount = oldArray.length) + this.nextChar()) > 0 ? new ClassAnnotation[count] : EMPTY_ANNOTATION_ARRAY;
        if (oldCount > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, oldCount);
        }
        int i = oldCount;
        while (i < count) {
            newArray[i] = new ClassAnnotation(null);
            ++i;
        }
        return newArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAttributes(int targetBp) {
        ClassFile classFile = this;
        synchronized (classFile) {
            int savedBp = this.bp;
            try {
                this.bp = targetBp;
                int attrCount = this.nextChar();
                int i = 0;
                while (i < attrCount) {
                    char attrIndex = this.nextChar();
                    int attrLen = this.nextInt();
                    int attrSavedBp = this.bp;
                    Name attrName = this.readPoolName(attrIndex);
                    System.out.println("  '" + attrName + "' (" + attrLen + ')');
                    if (attrLen > 0) {
                        System.out.print("    ");
                        int j = 0;
                        while (j < attrLen) {
                            if (j > 0 && j % 24 == 0) {
                                System.out.println();
                                System.out.print("    ");
                            }
                            int ii = this.nextByte();
                            System.out.print(ClassFile.x(ii &= 0xFF, 2) + ' ');
                            ++j;
                        }
                        System.out.println();
                        this.dumpAttribute(attrName, attrSavedBp);
                    }
                    this.bp = attrSavedBp + attrLen;
                    ++i;
                }
            }
            finally {
                this.bp = savedBp;
            }
        }
    }

    private void dumpAttribute(Name attrName, int targetBp) {
        this.bp = targetBp;
        byte attribute = ClassFile.name2attribute(attrName);
        switch (attribute) {
            case 15: 
            case 16: {
                this.dumpAttribute_Name();
                break;
            }
            case 7: {
                this.dumpInnerClasses();
                break;
            }
        }
    }

    private void dumpInnerClasses() {
        int count = this.nextChar();
        NameType[] preliminary = new NameType[count];
        boolean actual = false;
        while (count-- > 0) {
            NameType inner = this.readPoolClass(this.nextChar());
            NameType outer = this.readPoolClass(this.nextChar());
            System.out.println("      Inner name: " + inner);
            System.out.println("      Outer name: " + outer);
            char unknown = this.nextChar();
            System.out.println("      <unknown>: " + ClassFile.x(unknown, 4));
            char flags = this.nextChar();
            System.out.println("      Modifiers: " + ClassFile.x(flags, 4));
            System.out.println();
        }
    }

    private void dumpAttribute_Name() {
        Name name = this.readPoolName(this.nextChar());
        System.out.println("      \"" + name + "\"");
        System.out.println();
    }

    private static String x(int i, int width) {
        String s = Integer.toHexString(i);
        while (s.length() < width) {
            s = '0' + s;
        }
        return s;
    }

    private void fileError(String msg) {
        throw new RuntimeException(msg);
    }

    static void internalError(String msg) {
        CommonUtilities.panic(msg);
    }

    static void maS$dumpAnnotations(PrintStream printStream, ClassAnnotation[] classAnnotationArray) {
        ClassFile.dumpAnnotations(printStream, classAnnotationArray);
    }

    static void maS$dumpModifiers(PrintStream printStream, int n, boolean bl, boolean bl2) {
        ClassFile.dumpModifiers(printStream, n, bl, bl2);
    }

    static void mav$dumpPoolObject(ClassFile classFile, PrintStream printStream, int n) {
        classFile.dumpPoolObject(printStream, n);
    }

    static void mav$dumpAttributes(ClassFile classFile, int n) {
        classFile.dumpAttributes(n);
    }

    static int ra$bp(ClassFile classFile) {
        return classFile.bp;
    }

    static void wa$bp(ClassFile classFile, int n) {
        classFile.bp = n;
    }

    static char mav$nextChar(ClassFile classFile) {
        return classFile.nextChar();
    }

    static Name mav$readPoolName(ClassFile classFile, int n) {
        return classFile.readPoolName(n);
    }

    static int mav$nextInt(ClassFile classFile) {
        return classFile.nextInt();
    }

    static byte maS$name2attribute(Name name) {
        return ClassFile.name2attribute(name);
    }

    static Name mav$readPoolExternal(ClassFile classFile, int n) {
        return classFile.readPoolExternal(n);
    }

    static ClassAnnotation[] mav$readAnnotations(ClassFile classFile, ClassAnnotation[] classAnnotationArray) {
        return classFile.readAnnotations(classAnnotationArray);
    }

    static void mav$fileError(ClassFile classFile, String string) {
        classFile.fileError(string);
    }

    static ClassAnnotation[] ra$EMPTY_ANNOTATION_ARRAY() {
        return EMPTY_ANNOTATION_ARRAY;
    }

    static Object mav$readPoolConstant(ClassFile classFile, int n, char c) {
        return classFile.readPoolConstant(n, c);
    }

    static void mav$skipFieldOrMethod(ClassFile classFile) {
        classFile.skipFieldOrMethod();
    }

    static NameType mav$readPoolClass(ClassFile classFile, int n) {
        return classFile.readPoolClass(n);
    }

    static byte mav$nextByte(ClassFile classFile) {
        return classFile.nextByte();
    }

    static ClassAnnotation[][] ra$EMPTY_ANNOTATION_ARRAY_ARRAY() {
        return EMPTY_ANNOTATION_ARRAY_ARRAY;
    }

    static Name ra$kInitS() {
        return kInitS;
    }

    static Name ra$kClinitS() {
        return kClinitS;
    }

    static ComponentValue[] ra$EMPTY_VALUE_ARRAY() {
        return EMPTY_VALUE_ARRAY;
    }

    static void mav$skipComponent(ClassFile classFile) {
        classFile.skipComponent();
    }

    static char mav$getChar(ClassFile classFile, int n) {
        return classFile.getChar(n);
    }

    static void mav$skipValue(ClassFile classFile, byte by) {
        classFile.skipValue(by);
    }

    final class ClassField {
        private int thisBp;
        private int modifiers;
        private String name;
        private String fieldDescriptor;
        private String fieldSignature;
        private int constantValueIndex;
        private ClassAnnotation[] fieldAnnotations;

        private void $init$() {
            this.constantValueIndex = 0;
            this.fieldAnnotations = null;
        }

        private ClassField() {
            this.$init$();
            this.thisBp = ClassFile.ra$bp(ClassFile.this);
            this.modifiers = ClassFile.mav$nextChar(ClassFile.this);
            this.name = ClassFile.mav$readPoolName(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
            this.fieldDescriptor = ClassFile.mav$readPoolExternal(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
            ClassFile.wa$bp(ClassFile.this, this.thisBp);
            ClassFile.mav$skipFieldOrMethod(ClassFile.this);
        }

        public final int getModifiers() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            return this.modifiers;
        }

        public final String getFieldName() {
            return this.name;
        }

        public final String getDescriptor() {
            return this.fieldDescriptor;
        }

        public final String getSignature() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            return this.fieldSignature;
        }

        public final boolean isDeprecated() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            return (this.modifiers & 0x10000) != 0;
        }

        public final boolean isHidden() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            return (this.modifiers & 0x20000000) != 0;
        }

        public final Object getConstantValue() {
            int descriptor;
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            if ((descriptor = this.fieldDescriptor.charAt(0)) == 76 && this.fieldDescriptor.equals("Ljava/lang/String;")) {
                descriptor = 115;
            }
            return ClassFile.mav$readPoolConstant(ClassFile.this, this.constantValueIndex, (char)descriptor);
        }

        public ClassAnnotation[] getDeclaredAnnotations() {
            if (this.fieldAnnotations == null) {
                this.readFieldAttributes();
            }
            return this.fieldAnnotations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFieldAttributes() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if ((this.modifiers & Integer.MIN_VALUE) != 0) {
                    return;
                }
                int savedBp = ClassFile.ra$bp(ClassFile.this);
                ClassFile.wa$bp(ClassFile.this, this.thisBp + 6);
                int attrCount = ClassFile.mav$nextChar(ClassFile.this);
                int i = 0;
                while (i < attrCount) {
                    Name attrName = ClassFile.mav$readPoolName(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this));
                    int attrLen = ClassFile.mav$nextInt(ClassFile.this);
                    int attrSavedBp = ClassFile.ra$bp(ClassFile.this);
                    byte attribute = ClassFile.maS$name2attribute(attrName);
                    switch (attribute) {
                        case 4: {
                            this.modifiers |= 0x10000;
                            break;
                        }
                        case 18: {
                            this.modifiers |= 0x20000000;
                            break;
                        }
                        case 15: {
                            this.fieldSignature = ClassFile.mav$readPoolExternal(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
                            break;
                        }
                        case 17: {
                            this.modifiers |= 0x1000;
                            break;
                        }
                        case 11: 
                        case 13: {
                            this.fieldAnnotations = ClassFile.mav$readAnnotations(ClassFile.this, this.fieldAnnotations);
                            int endBp = attrSavedBp + attrLen;
                            if (ClassFile.ra$bp(ClassFile.this) != endBp) {
                                ClassFile.mav$fileError(ClassFile.this, "Invalid annotations length");
                            }
                            ClassFile.wa$bp(ClassFile.this, endBp);
                            break;
                        }
                        case 3: {
                            this.constantValueIndex = ClassFile.mav$nextChar(ClassFile.this);
                            break;
                        }
                        default: {
                            ClassFile classFile2 = ClassFile.this;
                            ClassFile.wa$bp(classFile2, ClassFile.ra$bp(classFile2) + attrLen);
                            break;
                        }
                    }
                    ++i;
                }
                if (this.fieldAnnotations == null) {
                    this.fieldAnnotations = ClassFile.ra$EMPTY_ANNOTATION_ARRAY();
                }
                if (ClassFile.this.isDeprecated()) {
                    this.modifiers |= 0x10000;
                }
                if (ClassFile.this.isHidden()) {
                    this.modifiers |= 0x20000000;
                }
                this.modifiers |= Integer.MIN_VALUE;
                ClassFile.wa$bp(ClassFile.this, savedBp);
            }
        }

        public final void dump(PrintStream out) {
            this.readFieldAttributes();
            ClassFile.maS$dumpAnnotations(out, this.getDeclaredAnnotations());
            ClassFile.maS$dumpModifiers(out, this.getModifiers(), false, true);
            out.println(this.getFieldName() + ' ' + this.getDescriptor());
            String signature = this.getSignature();
            if (signature != null) {
                out.println("  signature: " + signature);
            }
            if (this.constantValueIndex > 0) {
                out.print("  constant value: " + this.constantValueIndex + ", ");
                ClassFile.mav$dumpPoolObject(ClassFile.this, out, this.constantValueIndex);
                out.println();
            }
            out.println();
            ClassFile.mav$dumpAttributes(ClassFile.this, this.thisBp + 6);
        }

        ClassField(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class ClassMethod {
        private int thisBp;
        private int modifiers;
        private Name name;
        private String methodDescriptor;
        private String methodSignature;
        private NameType[] exceptions;
        private ClassAnnotation[] methodAnnotations;
        private ClassAnnotation[][] parameterAnnotations;
        private ComponentValue defaultValue;

        private void $init$() {
            this.exceptions = null;
            this.methodAnnotations = null;
            this.parameterAnnotations = null;
            this.defaultValue = null;
        }

        private ClassMethod() {
            this.$init$();
            this.thisBp = ClassFile.ra$bp(ClassFile.this);
            this.modifiers = ClassFile.mav$nextChar(ClassFile.this);
            this.name = ClassFile.mav$readPoolName(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this));
            this.methodDescriptor = ClassFile.mav$readPoolExternal(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
            ClassFile.wa$bp(ClassFile.this, this.thisBp);
            ClassFile.mav$skipFieldOrMethod(ClassFile.this);
        }

        public final int getModifiers() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return this.modifiers;
        }

        public final String getDescriptor() {
            return this.methodDescriptor;
        }

        public final String getSignature() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return this.methodSignature;
        }

        public final boolean isClinit() {
            return this.name.index == ClassFile.ra$kClinitS().index;
        }

        public final boolean isConstructor() {
            return this.name.index == ClassFile.ra$kInitS().index;
        }

        public final String getMethodName() {
            return this.name.toString();
        }

        public final boolean isDeprecated() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return (this.modifiers & 0x10000) != 0;
        }

        public final boolean isHidden() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return (this.modifiers & 0x20000000) != 0;
        }

        public final NameType[] getThrownExceptionTypes() {
            if (this.exceptions == null) {
                this.readMethodAttributes();
            }
            return this.exceptions;
        }

        public ClassAnnotation[] getDeclaredAnnotations() {
            if (this.methodAnnotations == null) {
                this.readMethodAttributes();
            }
            return this.methodAnnotations;
        }

        public ClassAnnotation[][] getParameterAnnotations() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            if (this.parameterAnnotations != null) {
                return this.parameterAnnotations;
            }
            return null;
        }

        public ComponentValue getDefaultValue() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return this.defaultValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readMethodAttributes() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                int savedBp = ClassFile.ra$bp(ClassFile.this);
                try {
                    ClassFile.wa$bp(ClassFile.this, this.thisBp + 6);
                    int attrCount = ClassFile.mav$nextChar(ClassFile.this);
                    int i = 0;
                    while (i < attrCount) {
                        Name attrName = ClassFile.mav$readPoolName(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this));
                        int attrLen = ClassFile.mav$nextInt(ClassFile.this);
                        int attrSavedBp = ClassFile.ra$bp(ClassFile.this);
                        byte attribute = ClassFile.maS$name2attribute(attrName);
                        switch (attribute) {
                            case 4: {
                                this.modifiers |= 0x10000;
                                break;
                            }
                            case 18: {
                                this.modifiers |= 0x20000000;
                                break;
                            }
                            case 15: {
                                this.methodSignature = ClassFile.mav$readPoolExternal(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
                                break;
                            }
                            case 17: {
                                this.modifiers |= 0x1000;
                                break;
                            }
                            case 1: {
                                this.defaultValue = new ComponentValue(null);
                                break;
                            }
                            case 6: {
                                int exceptionCount = ClassFile.mav$nextChar(ClassFile.this);
                                this.exceptions = new NameType[exceptionCount];
                                int j = 0;
                                while (j < exceptionCount) {
                                    this.exceptions[j] = ClassFile.mav$readPoolClass(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this));
                                    ++j;
                                }
                                break;
                            }
                            case 11: 
                            case 13: {
                                this.methodAnnotations = ClassFile.mav$readAnnotations(ClassFile.this, this.methodAnnotations);
                                int endBp = attrSavedBp + attrLen;
                                if (ClassFile.ra$bp(ClassFile.this) != endBp) {
                                    ClassFile.mav$fileError(ClassFile.this, "Invalid annotations length");
                                }
                                ClassFile.wa$bp(ClassFile.this, endBp);
                                break;
                            }
                            case 12: 
                            case 14: {
                                int paramCount = ClassFile.mav$nextByte(ClassFile.this);
                                Object array = paramCount > 0 ? new ClassAnnotation[paramCount][] : ClassFile.ra$EMPTY_ANNOTATION_ARRAY_ARRAY();
                                int p = 0;
                                while (p < paramCount) {
                                    array[p] = this.parameterAnnotations == null ? ClassFile.mav$readAnnotations(ClassFile.this, null) : ClassFile.mav$readAnnotations(ClassFile.this, this.parameterAnnotations[p]);
                                    ++p;
                                }
                                this.parameterAnnotations = array;
                                int endBp = attrSavedBp + attrLen;
                                if (ClassFile.ra$bp(ClassFile.this) != endBp) {
                                    ClassFile.mav$fileError(ClassFile.this, "Invalid annotations length");
                                }
                                ClassFile.wa$bp(ClassFile.this, endBp);
                                break;
                            }
                            default: {
                                ClassFile classFile2 = ClassFile.this;
                                ClassFile.wa$bp(classFile2, ClassFile.ra$bp(classFile2) + attrLen);
                                break;
                            }
                        }
                        ++i;
                    }
                    if (this.exceptions == null) {
                        this.exceptions = NameType.EMPTY_ARRAY;
                    }
                    if (this.methodAnnotations == null) {
                        this.methodAnnotations = ClassFile.ra$EMPTY_ANNOTATION_ARRAY();
                    }
                    if (ClassFile.this.isDeprecated()) {
                        this.modifiers |= 0x10000;
                    }
                    if (ClassFile.this.isHidden()) {
                        this.modifiers |= 0x20000000;
                    }
                    this.modifiers |= Integer.MIN_VALUE;
                }
                finally {
                    ClassFile.wa$bp(ClassFile.this, savedBp);
                }
            }
        }

        public final void dump(PrintStream out) {
            this.readMethodAttributes();
            ClassFile.maS$dumpAnnotations(out, this.getDeclaredAnnotations());
            ClassFile.maS$dumpModifiers(out, this.getModifiers(), false, true);
            out.println(this.getMethodName() + ' ' + this.getDescriptor());
            String signature = this.getSignature();
            if (signature != null) {
                out.println("  signature: " + signature);
            }
            NameType[] exceptions = this.getThrownExceptionTypes();
            int i = 0;
            while (i < exceptions.length) {
                out.println("  throws " + exceptions[i].toString());
                ++i;
            }
            ClassFile.maS$dumpAnnotations(out, this.getDeclaredAnnotations());
            out.println();
            ClassFile.mav$dumpAttributes(ClassFile.this, this.thisBp + 6);
        }

        ClassMethod(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class ClassAnnotation {
        private final NameType annotationType;
        private final int compBp;
        private String[] componentNames;
        private ComponentValue[] componentValues;

        private void $init$() {
            this.componentNames = null;
            this.componentValues = null;
        }

        private ClassAnnotation() {
            this.$init$();
            this.annotationType = (NameType)ClassFile.mav$readPoolConstant(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this), 'c');
            this.compBp = ClassFile.ra$bp(ClassFile.this);
            int count = ClassFile.mav$nextChar(ClassFile.this);
            int i = 0;
            while (i < count) {
                ClassFile.mav$skipComponent(ClassFile.this);
                ++i;
            }
        }

        public final NameType getAnnotationType() {
            return this.annotationType;
        }

        public final String[] getComponentNames() {
            if (this.componentNames == null) {
                this.readComponents();
            }
            return this.componentNames;
        }

        public final ComponentValue[] getComponentValues() {
            if (this.componentValues == null) {
                this.readComponents();
            }
            return this.componentValues;
        }

        public final void dump(PrintStream out) {
            String type = this.annotationType.toString();
            String print = type.substring(1, type.length() - 1);
            out.print('@' + print);
            out.print('(');
            this.readComponents();
            int count = this.componentNames.length;
            boolean needComma = false;
            int i = 0;
            while (i < count) {
                if (needComma) {
                    out.print(", ");
                }
                out.print(this.componentNames[i] + " = ");
                ComponentValue.mav$dump(this.componentValues[i], out);
                needComma = true;
                ++i;
            }
            out.println(')');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readComponents() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.componentNames != null) {
                    return;
                }
                int savedBp = ClassFile.ra$bp(ClassFile.this);
                try {
                    ClassFile.wa$bp(ClassFile.this, this.compBp);
                    int count = ClassFile.mav$nextChar(ClassFile.this);
                    if (count == 0) {
                        this.componentValues = ClassFile.ra$EMPTY_VALUE_ARRAY();
                        this.componentNames = JavaConstants.EMPTY_STRING_ARRAY;
                    } else {
                        String[] newComponentNames = new String[count];
                        ComponentValue[] newComponentValues = new ComponentValue[count];
                        int i = 0;
                        while (i < count) {
                            newComponentNames[i] = ClassFile.mav$readPoolName(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
                            newComponentValues[i] = new ComponentValue(null);
                            ++i;
                        }
                        this.componentValues = newComponentValues;
                        this.componentNames = newComponentNames;
                    }
                }
                finally {
                    ClassFile.wa$bp(ClassFile.this, savedBp);
                }
            }
        }

        ClassAnnotation(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class ComponentValue {
        private final byte tag;
        private final int valueBp;
        private Object value;

        private void $init$() {
            this.value = null;
        }

        private ComponentValue() {
            this.$init$();
            this.tag = ClassFile.mav$nextByte(ClassFile.this);
            this.valueBp = ClassFile.ra$bp(ClassFile.this);
            ClassFile.mav$skipValue(ClassFile.this, this.tag);
        }

        public final char getComponentTag() {
            return (char)(this.tag & 0xFF);
        }

        public final Object getComponentValue() {
            if (this.value == null) {
                this.value = this.readValue();
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private Object readValue() {
            var9_1 = ClassFile.this;
            synchronized (var9_1) {
                if (this.value != null) {
                    var10_2 = this.value;
                    return var10_2;
                }
                switch (this.tag) {
                    case 101: {
                        classindex = ClassFile.mav$getChar(ClassFile.this, this.valueBp);
                        enumindex = ClassFile.mav$getChar(ClassFile.this, this.valueBp + 2);
                        var11_5 = new EnumReference(classindex, enumindex);
                        return var11_5;
                    }
                    case 91: {
                        count = ClassFile.mav$getChar(ClassFile.this, this.valueBp);
                        if (count == 0) {
                            var12_7 = ClassFile.ra$EMPTY_VALUE_ARRAY();
                            return var12_7;
                        }
                        values = new ComponentValue[count];
                        savedBp = ClassFile.ra$bp(ClassFile.this);
                        try {
                            ClassFile.wa$bp(ClassFile.this, this.valueBp + 2);
                            i = 0;
                            while (i < count) {
                                values[i] = new ComponentValue();
                                ++i;
                            }
                            var13_11 = values;
                            ** try [egrp 2[TRYBLOCK] [1 : 210->216)] { 
                        }
lbl30:
                        // 1 sources

                        catch (Throwable var14_12) {
                            throw var14_12;
                        }
                        finally {
                            ClassFile.wa$bp(ClassFile.this, savedBp);
                        }
lbl29:
                        // 1 sources

                        return var13_11;
                    }
                    case 64: {
                        savedBp = ClassFile.ra$bp(ClassFile.this);
                        try {
                            ClassFile.wa$bp(ClassFile.this, this.valueBp);
                            var15_14 = new ClassAnnotation(null);
                            ** try [egrp 4[TRYBLOCK] [3 : 273->279)] { 
                        }
lbl42:
                        // 1 sources

                        catch (Throwable var16_15) {
                            throw var16_15;
                        }
                        finally {
                            ClassFile.wa$bp(ClassFile.this, savedBp);
                        }
lbl41:
                        // 1 sources

                        return var15_14;
                    }
                }
                index = ClassFile.mav$getChar(ClassFile.this, this.valueBp);
                var17_17 = ClassFile.mav$readPoolConstant(ClassFile.this, index, this.getComponentTag());
                return var17_17;
            }
        }

        private void dump(PrintStream out) {
            Object o = this.getComponentValue();
            switch (this.tag) {
                case 66: 
                case 67: 
                case 68: 
                case 73: 
                case 74: 
                case 83: 
                case 90: {
                    out.print(o);
                    break;
                }
                case 115: {
                    out.print('\"' + o.toString() + '\"');
                    break;
                }
                case 64: {
                    ClassAnnotation a = (ClassAnnotation)o;
                    a.dump(out);
                    break;
                }
                case 99: {
                    out.print("(Class) " + o.toString());
                    break;
                }
                case 101: {
                    EnumReference e = (EnumReference)o;
                    EnumReference.mav$dump(e, out);
                    break;
                }
                case 91: {
                    CommonUtilities.notImplementedYet();
                }
                default: {
                    CommonUtilities.panic("Unknown component tag: " + this.tag);
                }
            }
        }

        ComponentValue(1 var2_2) {
            this();
        }

        static void mav$dump(ComponentValue componentValue, PrintStream printStream) {
            componentValue.dump(printStream);
        }

        public final class 1 {
        }
    }

    final class EnumReference {
        final NameType enumClassname;
        final Name enumName;

        EnumReference(int classIndex, int enumIndex) {
            this.enumClassname = (NameType)ClassFile.mav$readPoolConstant(ClassFile.this, classIndex, 'c');
            this.enumName = ClassFile.mav$readPoolName(ClassFile.this, enumIndex);
        }

        private void dump(PrintStream out) {
            out.print("(Enum) " + this.enumClassname.toString() + '.' + this.enumName);
        }

        static void mav$dump(EnumReference enumReference, PrintStream printStream) {
            enumReference.dump(printStream);
        }
    }
}

