/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.classfile.ClFile;
import oracle.javatools.parser.java.v2.classfile.ClParser;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.classfile.NameType;
import oracle.javatools.parser.java.v2.common.AbstractAnnotation;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.common.AbstractField;
import oracle.javatools.parser.java.v2.common.AbstractMethod;
import oracle.javatools.parser.java.v2.common.AbstractType;
import oracle.javatools.parser.java.v2.common.AbstractVariable;
import oracle.javatools.parser.java.v2.common.AnnotationComponents;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.common.SignatureHasType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.util.NullProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClClass
extends AbstractClass {
    private static final List kEmptyList = Collections.EMPTY_LIST;
    final JavaProvider provider;
    private final ClassFile classFile;
    private final JavaFile javaFile;
    protected Collection annotations;
    protected Map<String, ClTypeParameter> typeParameters;
    protected SignatureHasType superclass;
    protected Collection interfaceTypes;
    private Collection interfaces;
    private Collection<UnresolvedType> unresolvedInterfaces;
    private Map<String, List<ClMethod>> methods;
    private Collection constructors;
    private ClMethod clinitMethod;
    private Map<String, ClField> fields;
    private Map<String, JavaClass> classes;
    private JavaClass cachedOwningClass;
    private SourceClass sourceClass;

    private void $init$() {
        this.typeParameters = Collections.emptyMap();
        this.superclass = null;
        this.interfaceTypes = null;
        this.cachedOwningClass = this;
        this.sourceClass = null;
    }

    public ClClass(ClassFile classFile, JavaProvider provider) {
        this.$init$();
        this.classFile = classFile;
        if (provider != null) {
            this.provider = provider;
        } else {
            this.provider = NullProvider.getInstance();
            new NullPointerException("Null provider").printStackTrace();
        }
        this.javaFile = new ClFile(this, classFile.getURL());
        String signature = classFile.getSignature();
        if (signature != null) {
            this.parseSignature(signature);
            if (this.interfaceTypes == null) {
                this.interfaces = JavaConstants.kEmptyCollection;
            }
        } else {
            NameType nameType = classFile.getBaseClass();
            if (nameType != null) {
                this.superclass = new SignatureHasType('L', nameType.toString(), provider);
            }
        }
    }

    private void parseSignature(String signature) {
        ClParser parser = new ClParser(signature, this);
        parser.parseClassSignature0(this);
    }

    final ClassFile getClassFile() {
        return this.classFile;
    }

    @Override
    public JavaFile getFile() {
        return this.javaFile;
    }

    public JavaProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getName() {
        String qualifiedName = this.getQualifiedName();
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(lastDot + 1);
        }
        return qualifiedName;
    }

    @Override
    public String getSignature() {
        String signature = this.classFile.getSignature();
        if (signature != null) {
            return signature;
        }
        return super.getSignature();
    }

    @Override
    public boolean isInterface() {
        return (this.classFile.getModifiers() & 0x200) != 0;
    }

    @Override
    public String getQualifiedName() {
        JavaClass outerClass;
        String vmName = this.getVMName();
        int lastDollar = vmName.indexOf(36);
        if (lastDollar != -1 && (outerClass = this.getOwningClass()) != null) {
            String prefix = outerClass.getQualifiedName();
            int prefixLength = prefix.length();
            return prefix + '.' + vmName.substring(prefixLength + 1);
        }
        return vmName.replace('/', '.');
    }

    @Override
    public String getVMName() {
        return this.classFile.getFullClassName();
    }

    @Override
    public JavaPackage getPackage() {
        return this.provider.getPackage(this.getPackageName());
    }

    @Override
    public String getPackageName() {
        JavaClass owningClass = this.getOwningClass();
        if (owningClass != null) {
            return owningClass.getPackageName();
        }
        String qualifiedName = this.getQualifiedName();
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return "";
    }

    @Override
    public boolean hasTypeParameters() {
        return this.typeParameters.isEmpty() ^ true;
    }

    @Override
    public Collection getTypeParameters() {
        return this.copyCollection(this.typeParameters.values());
    }

    @Override
    public JavaTypeVariable getTypeParameter(String name) {
        return this.typeParameters.get(name);
    }

    @Override
    public JavaType getSuperclass() {
        if (this.superclass != null) {
            return this.superclass.getResolvedType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getInterfaces() {
        if (this.interfaces == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.interfaces == null) {
                    if (this.interfaceTypes != null) {
                        ArrayList<JavaType> list = new ArrayList<JavaType>();
                        ArrayList<UnresolvedType> unresolvedList = new ArrayList<UnresolvedType>();
                        for (SignatureHasType clType : this.interfaceTypes) {
                            JavaType type = clType.getResolvedType();
                            if (type != null) {
                                list.add(type);
                            }
                            unresolvedList.add(clType.getUnresolvedType());
                        }
                        this.interfaces = list;
                        this.unresolvedInterfaces = unresolvedList.isEmpty() ? JavaConstants.kEmptyCollection : unresolvedList;
                        this.interfaceTypes = null;
                    } else {
                        NameType[] things = this.classFile.getBaseInterfaces();
                        int thingCount = things.length;
                        if (thingCount == 0) {
                            this.interfaces = JavaConstants.kEmptyCollection;
                            this.unresolvedInterfaces = JavaConstants.kEmptyCollection;
                        } else {
                            ArrayList<JavaClass> list = new ArrayList<JavaClass>();
                            ArrayList<UnresolvedType> unresolvedList = new ArrayList<UnresolvedType>();
                            int i = 0;
                            while (i < thingCount) {
                                NameType thing = things[i];
                                if (thing != null) {
                                    JavaClass type = this.provider.getClassByVMName(things[i].toString());
                                    if (type != null) {
                                        list.add(type);
                                    }
                                    unresolvedList.add(QuickUnresolvedType.createUnresolvedType(thing.toString()));
                                }
                                ++i;
                            }
                            this.interfaces = list;
                            Collection<UnresolvedType> collection = this.unresolvedInterfaces = unresolvedList.isEmpty() ? JavaConstants.kEmptyCollection : unresolvedList;
                        }
                    }
                    if (this.interfaces.isEmpty()) {
                        this.interfaces = JavaConstants.kEmptyCollection;
                    }
                }
            }
        }
        return this.interfaces;
    }

    @Override
    public JavaField getDeclaredField(String name) {
        this.loadDeclaredFields();
        return this.fields.get(name);
    }

    @Override
    public Collection getDeclaredFields() {
        this.loadDeclaredFields();
        return this.copyCollection(this.fields.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeclaredFields() {
        if (this.fields == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.fields == null) {
                    ClassFile.ClassField[] things = this.classFile.getDeclaredFields();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.fields = Collections.emptyMap();
                    } else {
                        LinkedHashMap<String, ClField> list = new LinkedHashMap<String, ClField>();
                        int i = 0;
                        while (i < thingCount) {
                            ClassFile.ClassField thing = things[i];
                            if ((thing.getModifiers() & 0x1000) == 0) {
                                ClField field = new ClField(thing, null);
                                list.put(field.getName(), field);
                            }
                            ++i;
                        }
                        this.fields = list;
                    }
                }
            }
        }
    }

    @Override
    public Collection getDeclaredMethods() {
        this.loadDeclaredMethods();
        ArrayList<ClMethod> copy = new ArrayList<ClMethod>();
        for (List<ClMethod> list : this.methods.values()) {
            copy.addAll(list);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeclaredMethods() {
        if (this.methods == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.methods == null) {
                    ClassFile.ClassMethod[] things = this.classFile.getDeclaredMethods();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.methods = Collections.emptyMap();
                    } else {
                        LinkedHashMap<String, List<ClMethod>> methodMap = new LinkedHashMap<String, List<ClMethod>>();
                        int i = 0;
                        while (i < thingCount) {
                            ClassFile.ClassMethod thing = things[i];
                            if (!thing.getMethodName().startsWith("access$") && (thing.getModifiers() & 0x1000) == 0) {
                                ClMethod clMethod = new ClMethod(thing, null);
                                ArrayList<ClMethod> clMethods = (ArrayList<ClMethod>)methodMap.get(clMethod.getName());
                                if (clMethods == null) {
                                    clMethods = new ArrayList<ClMethod>();
                                    methodMap.put(clMethod.getName(), clMethods);
                                }
                                clMethods.add(clMethod);
                            }
                            ++i;
                        }
                        this.methods = methodMap;
                    }
                    ClassFile.ClassMethod clinit = this.classFile.getClinitMethod();
                    if (clinit != null) {
                        this.clinitMethod = new ClMethod(clinit, null);
                    }
                }
            }
        }
    }

    @Override
    public Collection getDeclaredMethods(String name) {
        this.loadDeclaredMethods();
        return this.copyCollection(this.methods.get(name));
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaType[] targetTypes) {
        if (targetTypes == null) {
            targetTypes = JavaType.EMPTY_ARRAY;
        }
        Collection methods = this.getDeclaredMethods(name);
        for (JavaMethod thing : methods) {
            if (!CommonUtilities.matchMethod(thing, targetTypes)) continue;
            return thing;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getDeclaredConstructors() {
        if (this.constructors == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.constructors == null) {
                    ClassFile.ClassMethod[] things = this.classFile.getDeclaredConstructors();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.constructors = JavaConstants.kEmptyCollection;
                    } else {
                        ArrayList<ClMethod> list = new ArrayList<ClMethod>();
                        int i = 0;
                        while (i < thingCount) {
                            list.add(new ClMethod(things[i], null));
                            ++i;
                        }
                        this.constructors = list;
                    }
                }
            }
        }
        return this.constructors;
    }

    @Override
    public JavaMethod getClinitMethod() {
        this.getDeclaredMethods();
        return this.clinitMethod;
    }

    @Override
    public Collection getDeclaredClasses() {
        this.loadDeclaredClasses();
        return this.copyCollection(this.classes.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeclaredClasses() {
        if (this.classes == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.classes == null) {
                    NameType[] things = this.classFile.getDeclaredInnerClasses();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.classes = Collections.emptyMap();
                    } else {
                        LinkedHashMap<String, JavaClass> list = new LinkedHashMap<String, JavaClass>();
                        int i = 0;
                        while (i < thingCount) {
                            JavaClass member = this.getInnerClassByVMName(things[i].toString());
                            if (member != null) {
                                list.put(member.getName(), member);
                            }
                            ++i;
                        }
                        this.classes = !list.isEmpty() ? list : Collections.emptyMap();
                    }
                }
            }
        }
    }

    @Override
    public JavaClass getDeclaredClass(String name) {
        this.loadDeclaredClasses();
        return this.classes.get(name);
    }

    @Override
    public JavaClass getOwningClass() {
        if (this.cachedOwningClass == this) {
            NameType nameType = this.classFile.getOuterClass();
            this.cachedOwningClass = nameType != null ? this.provider.getClassByVMName(nameType.toString()) : null;
        }
        return this.cachedOwningClass;
    }

    @Override
    public JavaElement getOwner() {
        JavaClass type = this.getOwningClass();
        if (type != null) {
            return type;
        }
        return this.getPackage();
    }

    @Override
    public boolean isDeprecated() {
        return this.classFile.isDeprecated();
    }

    @Override
    public boolean isHidden() {
        return this.classFile.isHidden();
    }

    @Override
    public int getModifiers() {
        return this.classFile.getModifiers();
    }

    public void setSourceElement(SourceElement input) {
        this.sourceClass = (SourceClass)input;
    }

    @Override
    public SourceElement getSourceElement() {
        if (this.sourceClass != null) {
            return this.sourceClass;
        }
        return this.getSourceClass(this.classFile.getSourceFilename());
    }

    @Override
    public URL getURL() {
        return this.classFile.getURL();
    }

    @Override
    public Collection getDeclaredAnnotations() {
        if (this.annotations == null) {
            ClassFile.ClassAnnotation[] things = this.classFile.getDeclaredAnnotations();
            this.annotations = this.createAnnotations(this, things);
        }
        return this.annotations;
    }

    @Override
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.interfaces = null;
        this.sourceClass = null;
        this.annotations = null;
        for (ClTypeParameter thing : this.getTypeParameters()) {
            thing.clearCompiledInfo();
        }
        for (ClMethod thing : this.getDeclaredMethods()) {
            thing.clearCompiledInfo();
        }
        Iterator iterator = this.getDeclaredFields().iterator();
        while (iterator.hasNext()) {
            ((ClField)iterator.next()).clearCompiledInfo();
        }
        Iterator iterator2 = this.getDeclaredClasses().iterator();
        while (iterator2.hasNext()) {
            ((JavaClass)iterator2.next()).clearCompiledInfo();
        }
    }

    protected SourceClass getSourceClass(String sourceFileNameHint) {
        return this.provider.getSourceClass(this.getQualifiedName());
    }

    protected JavaClass getInnerClassByVMName(String fqInnerVMName) {
        JavaClass inner = this.provider.getClassByVMName(fqInnerVMName);
        return inner;
    }

    @Override
    public Collection<UnresolvedType> getUnresolvedInterfaces() {
        if (this.interfaces == null) {
            this.getInterfaces();
        }
        return this.unresolvedInterfaces != null ? this.unresolvedInterfaces : JavaConstants.kEmptyCollection;
    }

    private Object readComponentValue(ClassFile.ComponentValue value, JavaElement owner) {
        Object o = value.getComponentValue();
        char ch = value.getComponentTag();
        switch (ch) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return o;
            }
            case 's': {
                if (o != null) {
                    return o.toString();
                }
                return null;
            }
            case 'c': {
                NameType cNameType = (NameType)o;
                return this.nameType2signatureHasType(cNameType).getResolvedType();
            }
            case 'e': {
                ClassFile.EnumReference e = (ClassFile.EnumReference)o;
                JavaType type = this.nameType2signatureHasType(e.enumClassname).getResolvedType();
                if (type != null) {
                    return type.getDeclaredField(e.enumName.toString());
                }
                return null;
            }
            case '@': {
                ClassFile.ClassAnnotation a = (ClassFile.ClassAnnotation)o;
                return new ClAnnotation(owner, a);
            }
            case '[': {
                ClassFile.ComponentValue[] values = (ClassFile.ComponentValue[])o;
                int count = values.length;
                if (count == 0) {
                    return JavaConstants.EMPTY_OBJECT_ARRAY;
                }
                Object[] things = new Object[count];
                int i = 0;
                while (i < count) {
                    things[i] = this.readComponentValue(values[i], owner);
                    ++i;
                }
                return things;
            }
        }
        CommonUtilities.panic("Unknown component tag: " + ch);
        return null;
    }

    private Collection createAnnotations(JavaHasAnnotations owner, ClassFile.ClassAnnotation[] things) {
        int thingCount = things.length;
        if (thingCount == 0) {
            return JavaConstants.kEmptyCollection;
        }
        JavaAnnotation[] array = new JavaAnnotation[thingCount];
        int i = 0;
        while (i < thingCount) {
            array[i] = new ClAnnotation(owner, things[i]);
            ++i;
        }
        return Arrays.asList(array);
    }

    private SignatureHasType nameType2signatureHasType(NameType nameType) {
        String lnameString = nameType.toString();
        int len = lnameString.length();
        if (len == 1) {
            return new SignatureHasType(lnameString.charAt(0), this.provider);
        }
        String name = lnameString.substring(1, len - 1);
        return new SignatureHasType('L', name, this.provider);
    }

    private static void errorMalformed(String message) {
        CommonUtilities.panic(message);
    }

    private <T> List<T> copyCollection(Collection<T> original) {
        if (original == null) {
            return Collections.emptyList();
        }
        ArrayList<T> copy = new ArrayList<T>(original.size());
        for (T member : original) {
            copy.add(member);
        }
        return copy;
    }

    static Collection mav$createAnnotations(ClClass clClass, JavaHasAnnotations javaHasAnnotations, ClassFile.ClassAnnotation[] classAnnotationArray) {
        return clClass.createAnnotations(javaHasAnnotations, classAnnotationArray);
    }

    static JavaFile ra$javaFile(ClClass clClass) {
        return clClass.javaFile;
    }

    static Object mav$readComponentValue(ClClass clClass, ClassFile.ComponentValue componentValue, JavaElement javaElement) {
        return clClass.readComponentValue(componentValue, javaElement);
    }

    static ClassFile ra$classFile(ClClass clClass) {
        return clClass.classFile;
    }

    static List ra$kEmptyList() {
        return kEmptyList;
    }

    static void wa$interfaces(ClClass clClass, Collection collection) {
        clClass.interfaces = collection;
    }

    static SignatureHasType mav$nameType2signatureHasType(ClClass clClass, NameType nameType) {
        return clClass.nameType2signatureHasType(nameType);
    }

    private class ClField
    extends AbstractField {
        private ClassFile.ClassField thing;
        protected Collection annotations;
        private SignatureHasType type;

        private ClField(ClassFile.ClassField thing) {
            this.thing = thing;
            String signature = thing.getSignature();
            this.type = signature != null ? this.parseSignature(signature) : this.parseSignature(thing.getDescriptor());
        }

        private SignatureHasType parseSignature(String signature) {
            ClParser parser = new ClParser(signature, ClClass.this);
            return (SignatureHasType)parser.parseTypeSignature0();
        }

        public JavaFile getFile() {
            return ClClass.ra$javaFile(ClClass.this);
        }

        final ClassFile.ClassField getClassField() {
            return this.thing;
        }

        public JavaType getResolvedType() {
            return this.type.getResolvedType();
        }

        public UnresolvedType getUnresolvedType() {
            return this.type.getUnresolvedType();
        }

        public String getName() {
            return this.thing.getFieldName();
        }

        public JavaClass getOwningClass() {
            return ClClass.this;
        }

        public JavaElement getOwner() {
            return this.getOwningClass();
        }

        public String getDescriptor() {
            return this.thing.getDescriptor();
        }

        public String getSignature() {
            String signature = this.thing.getSignature();
            if (signature != null) {
                return signature;
            }
            return this.getDescriptor();
        }

        public boolean isDeprecated() {
            return this.thing.isDeprecated();
        }

        public boolean isHidden() {
            return this.thing.isHidden();
        }

        public int getModifiers() {
            return this.thing.getModifiers();
        }

        public SourceElement getSourceElement() {
            SourceClass sourceClass = (SourceClass)ClClass.this.getSourceElement();
            return CommonUtilities.getSourceElement(this, sourceClass);
        }

        public Collection getDeclaredAnnotations() {
            if (this.annotations == null) {
                ClassFile.ClassAnnotation[] things = this.thing.getDeclaredAnnotations();
                this.annotations = ClClass.mav$createAnnotations(ClClass.this, this, things);
            }
            return this.annotations;
        }

        public Object getConstantValue() {
            if (this.isEnumConstant()) {
                return this;
            }
            return this.thing.getConstantValue();
        }

        public void clearCompiledInfo() {
            this.annotations = null;
        }

        ClField(ClassFile.ClassField classField, 1 var3_3) {
            this(classField);
        }

        public final class 1 {
        }
    }

    protected class ClMethod
    extends AbstractMethod {
        private final ClassFile.ClassMethod thing;
        protected Collection annotations;
        protected Map<String, ClTypeParameter> typeParameters;
        protected SignatureHasType returnType;
        protected Collection formalParameters;
        protected Collection exceptionTypes;
        private Collection exceptions;
        private Object value;

        private void $init$() {
            this.typeParameters = Collections.emptyMap();
            this.formalParameters = JavaConstants.kEmptyCollection;
            this.exceptionTypes = null;
            this.value = null;
        }

        private ClMethod(ClassFile.ClassMethod thing) {
            this.$init$();
            this.thing = thing;
            String signature = thing.getSignature();
            if (signature != null) {
                this.parseSignature(signature);
            } else {
                String descriptor = thing.getDescriptor();
                this.parseSignature(descriptor);
            }
        }

        private void parseSignature(String signature) {
            ClParser parser = new ClParser(signature, ClClass.this, this);
            parser.parseMethodTypeSignature0(this);
        }

        public JavaFile getFile() {
            return ClClass.ra$javaFile(ClClass.this);
        }

        final ClassFile.ClassMethod getClassMethod() {
            return this.thing;
        }

        public boolean isConstructor() {
            return this.thing.isConstructor();
        }

        public JavaType getResolvedType() {
            return this.returnType.getResolvedType();
        }

        public UnresolvedType getUnresolvedType() {
            return this.returnType.getUnresolvedType();
        }

        public String getName() {
            return this.thing.getMethodName();
        }

        public JavaClass getOwningClass() {
            return ClClass.this;
        }

        public JavaElement getOwner() {
            return this.getOwningClass();
        }

        public boolean hasTypeParameters() {
            return this.typeParameters.isEmpty() ^ true;
        }

        public Collection getTypeParameters() {
            return this.typeParameters.values();
        }

        public JavaTypeVariable getTypeParameter(String name) {
            return this.typeParameters.get(name);
        }

        public Collection getParameters() {
            return this.formalParameters;
        }

        public Collection getExceptions() {
            if (this.exceptions == null) {
                if (this.exceptionTypes != null) {
                    ArrayList<JavaType> list = new ArrayList<JavaType>();
                    for (SignatureHasType clType : this.exceptionTypes) {
                        JavaType type = clType.getResolvedType();
                        if (type == null) continue;
                        list.add(type);
                    }
                    this.exceptions = list;
                    this.exceptionTypes = null;
                } else {
                    NameType[] things = this.thing.getThrownExceptionTypes();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.exceptions = JavaConstants.kEmptyCollection;
                    } else {
                        ArrayList<JavaClass> list = new ArrayList<JavaClass>();
                        int i = 0;
                        while (i < thingCount) {
                            JavaClass type = ClClass.this.provider.getClassByVMName(things[i].toString());
                            if (type != null) {
                                list.add(type);
                            }
                            ++i;
                        }
                        this.exceptions = list;
                    }
                }
                if (this.exceptions.isEmpty()) {
                    this.exceptions = JavaConstants.kEmptyCollection;
                }
            }
            return this.exceptions;
        }

        public boolean isDeprecated() {
            return this.thing.isDeprecated();
        }

        public boolean isHidden() {
            return this.thing.isHidden();
        }

        public int getModifiers() {
            return this.thing.getModifiers();
        }

        public String getDescriptor() {
            return this.thing.getDescriptor();
        }

        public String getSignature() {
            String signature = this.thing.getSignature();
            if (signature != null) {
                return signature;
            }
            return this.getDescriptor();
        }

        public SourceElement getSourceElement() {
            SourceClass sourceClass = (SourceClass)ClClass.this.getSourceElement();
            return CommonUtilities.getSourceElement(this, sourceClass);
        }

        public Object getDefaultValue() {
            ClassFile.ComponentValue cv;
            if (this.value == null && (cv = this.thing.getDefaultValue()) != null) {
                this.value = ClClass.mav$readComponentValue(ClClass.this, cv, this);
            }
            return this.value;
        }

        public void clearCompiledInfo() {
            this.exceptions = null;
            this.annotations = null;
            this.value = null;
        }

        public Collection getDeclaredAnnotations() {
            if (this.annotations == null) {
                ClassFile.ClassAnnotation[] things = this.thing.getDeclaredAnnotations();
                this.annotations = ClClass.mav$createAnnotations(ClClass.this, this, things);
            }
            return this.annotations;
        }

        ClMethod(ClassFile.ClassMethod classMethod, 1 var3_3) {
            this(classMethod);
        }

        static ClassFile.ClassMethod ra$thing(ClMethod clMethod) {
            return clMethod.thing;
        }

        protected class ClVariable
        extends AbstractVariable
        implements JavaLocalVariable {
            private final SignatureHasType type;
            private final int index;
            private Collection annotations;

            protected ClVariable(SignatureHasType type, int index) {
                this.type = type;
                this.index = index;
            }

            public JavaFile getFile() {
                return ClClass.ra$javaFile(ClClass.this);
            }

            public int getElementKind() {
                return 7;
            }

            public JavaType getResolvedType() {
                return this.type.getResolvedType();
            }

            public UnresolvedType getUnresolvedType() {
                return this.type.getUnresolvedType();
            }

            public String getName() {
                SourceVariable var = (SourceVariable)this.getSourceElement();
                if (var != null) {
                    return var.getName();
                }
                return "";
            }

            public JavaElement getOwner() {
                return ClMethod.this;
            }

            public int getModifiers() {
                if (ClMethod.this.isVarargs() && this.index == ClMethod.this.formalParameters.size() - 1) {
                    return 128;
                }
                return 0;
            }

            public Collection getDeclaredAnnotations() {
                if (this.annotations == null) {
                    ClassFile.ClassAnnotation[][] allThings = ClMethod.ra$thing(ClMethod.this).getParameterAnnotations();
                    if (allThings != null && allThings.length > 0) {
                        try {
                            ClassFile.ClassAnnotation[] things = allThings[this.index];
                            this.annotations = ClClass.mav$createAnnotations(ClClass.this, this, things);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            URL url = ClClass.ra$classFile(ClClass.this).getURL();
                            if (url != null) {
                                new RuntimeException(url.toString(), e).printStackTrace();
                            }
                            e.printStackTrace();
                        }
                    }
                    if (this.annotations == null) {
                        this.annotations = ClClass.ra$kEmptyList();
                    }
                }
                return this.annotations;
            }

            public SourceElement getSourceElement() {
                SourceMethod sourceMethod = (SourceMethod)ClMethod.this.getSourceElement();
                if (sourceMethod == null) {
                    return null;
                }
                List parameters = sourceMethod.getSourceParameters();
                if (parameters.size() <= this.index) {
                    return null;
                }
                return (SourceElement)parameters.get(this.index);
            }
        }

        public final class 1 {
        }
    }

    protected class ClTypeParameter
    extends AbstractType
    implements JavaTypeVariable {
        private final JavaIsGeneric owner;
        private final String name;
        protected SignatureHasType superclassBound;
        protected List interfaceBounds;
        private JavaType[] resolvedInterfaces;
        private JavaType[] resolvedBounds;

        private void $init$() {
            this.superclassBound = null;
            this.interfaceBounds = ClClass.ra$kEmptyList();
            this.resolvedInterfaces = null;
            this.resolvedBounds = null;
        }

        protected ClTypeParameter(JavaIsGeneric owner, String name) {
            this.$init$();
            this.owner = owner;
            this.name = name;
        }

        public JavaFile getFile() {
            return ClClass.ra$javaFile(ClClass.this);
        }

        public String getTypeSignature() {
            return CommonUtilities.getTypeSignature(this);
        }

        public String getDescriptor() {
            return CommonUtilities.getDescriptor(this);
        }

        public String getUniqueIdentifier() {
            return CommonUtilities.getUniqueIdentifier(this);
        }

        public String getQualifiedName() {
            return this.getName();
        }

        public String getVMName() {
            return this.getName();
        }

        public int getElementKind() {
            return 10;
        }

        public String getName() {
            return this.name;
        }

        public JavaElement getOwner() {
            return this.owner;
        }

        public JavaMember getOwningMember() {
            return this.owner;
        }

        public JavaClass getTypeErasure() {
            return CommonUtilities.getTypeErasure(this);
        }

        public JavaType getSuperclass() {
            JavaType resolved;
            if (this.superclassBound != null && (resolved = this.superclassBound.getResolvedType()) != null) {
                return resolved;
            }
            return ClClass.this.provider.getClassByVMName("java/lang/Object");
        }

        public Collection getInterfaces() {
            JavaType[] resolvedInterfaces = this.getResolvedInterfaces();
            if (resolvedInterfaces.length > 0) {
                return Arrays.asList(resolvedInterfaces);
            }
            return JavaConstants.kEmptyCollection;
        }

        public Collection getBounds() {
            JavaType[] resolvedBounds = this.getResolvedBounds();
            if (resolvedBounds.length > 0) {
                return Arrays.asList(resolvedBounds);
            }
            return JavaConstants.kEmptyCollection;
        }

        public void clearCompiledInfo() {
            super.clearCompiledInfo();
            ClClass.wa$interfaces(ClClass.this, null);
        }

        public JavaType[] getResolvedInterfaces() {
            if (this.resolvedInterfaces == null) {
                ArrayList<JavaType> list = ClClass.ra$kEmptyList();
                if (this.interfaceBounds != null && !this.interfaceBounds.isEmpty()) {
                    list = new ArrayList<JavaType>();
                    for (SignatureHasType clType : this.interfaceBounds) {
                        JavaType type = clType.getResolvedType();
                        if (type == null) continue;
                        list.add(type);
                    }
                }
                this.resolvedInterfaces = list.isEmpty() ? JavaType.EMPTY_ARRAY : list.toArray(new JavaType[list.size()]);
            }
            return this.resolvedInterfaces;
        }

        public JavaType[] getResolvedBounds() {
            if (this.resolvedBounds == null) {
                JavaType type;
                JavaType[] resolvedInterfaces = this.getResolvedInterfaces();
                if (this.superclassBound != null && (type = this.superclassBound.getResolvedType()) != null) {
                    int count = resolvedInterfaces.length;
                    JavaType[] newArray = new JavaType[count + 1];
                    newArray[0] = type;
                    System.arraycopy(resolvedInterfaces, 0, newArray, 1, count);
                    this.resolvedBounds = newArray;
                }
                if (this.resolvedBounds == null) {
                    this.resolvedBounds = resolvedInterfaces;
                }
            }
            return this.resolvedBounds;
        }
    }

    protected class ClAnnotation
    extends AbstractAnnotation
    implements JavaAnnotation {
        private final JavaElement owner;
        private final ClassFile.ClassAnnotation thing;
        private final SignatureHasType annotationType;
        private AnnotationComponents components;

        private void $init$() {
            this.components = null;
        }

        protected ClAnnotation(JavaElement owner, ClassFile.ClassAnnotation thing) {
            this.$init$();
            this.owner = owner;
            this.thing = thing;
            this.annotationType = ClClass.mav$nameType2signatureHasType(ClClass.this, thing.getAnnotationType());
        }

        public JavaFile getFile() {
            return ClClass.ra$javaFile(ClClass.this);
        }

        public int getElementKind() {
            return 2;
        }

        public JavaElement getOwner() {
            return this.owner;
        }

        public SourceElement getSourceElement() {
            SourceElement ownerSource = this.owner.getSourceElement();
            if (ownerSource == null) {
                return null;
            }
            SourceHasModifiers ownerElement = (SourceHasModifiers)ownerSource;
            return CommonUtilities.getSourceElement(this, ownerElement);
        }

        public JavaType getResolvedType() {
            return this.annotationType.getResolvedType();
        }

        public Map getComponents() {
            if (this.components == null) {
                try {
                    String[] names;
                    int count;
                    AnnotationComponents map = AnnotationComponents.createInstance(this.getResolvedType());
                    if (map != null && (count = (names = this.thing.getComponentNames()).length) > 0) {
                        ClassFile.ComponentValue[] values = this.thing.getComponentValues();
                        int i = 0;
                        while (i < count) {
                            Object value = ClClass.mav$readComponentValue(ClClass.this, values[i], this);
                            if (value != null) {
                                map.assignValue(names[i], value);
                            }
                            ++i;
                        }
                    }
                    this.components = map;
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            return this.components;
        }

        public UnresolvedType getUnresolvedType() {
            return this.annotationType.getUnresolvedType();
        }
    }
}

