/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.ClassBodySymbol;
import oracle.javatools.parser.java.v1.symbol.ClassListSymbol;
import oracle.javatools.parser.java.v1.symbol.MemberSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Nameable;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class MethodSymbol
extends MemberSymbol
implements Nameable {
    private NameSymbol name;
    private ArrayList parameters;
    private VariableSymbol[] parameterArray;
    private ClassListSymbol thrownClasses;
    static final MethodSymbol[] EMPTY_ARRAY = new MethodSymbol[0];

    public boolean isConstructor() {
        return this.code == 370;
    }

    public VariableSymbol[] getParameters() {
        return this.parameterArray;
    }

    public NameSymbol[] getThrows() {
        return this.thrownClasses != null ? this.thrownClasses.listClasses() : NameSymbol.EMPTY_ARRAY;
    }

    public TypeSymbol[] getThrownTypes() {
        return this.thrownClasses != null ? this.thrownClasses.listClassTypes() : TypeSymbol.EMPTY_ARRAY;
    }

    public TypeSymbol getReturnType() {
        return this.getType();
    }

    public int getScopeType() {
        return 3;
    }

    public VariableSymbol findVariable(String name) {
        VariableSymbol[] paramSyms = this.getParameters();
        int paramCount = paramSyms.length;
        int i = 0;
        while (i < paramCount) {
            VariableSymbol paramSym = paramSyms[i];
            if (paramSym != null && MethodSymbol.matches(paramSym, name)) {
                return paramSym;
            }
            ++i;
        }
        return null;
    }

    public VariableSymbol[] getVariables() {
        return this.getParameters();
    }

    private void $init$() {
        this.name = null;
        this.parameters = MethodSymbol.allocArrayList();
        this.parameterArray = null;
    }

    MethodSymbol(int code) {
        super(code);
        this.$init$();
        if (code != 340 && code != 370) {
            this.internalError("Wrong code for a MethodSymbol");
        }
    }

    TypeSymbol getType() {
        TypeSymbol t = super.getType();
        if (t == null && this.parent.code == 280) {
            return ((MemberSymbol)this.parent).getType();
        }
        return t;
    }

    void addParameter(VariableSymbol param) {
        this.parameters.add(param);
    }

    void setThrows(ClassListSymbol thrownClasses) {
        this.thrownClasses = thrownClasses;
    }

    void addToClass(ClassBodySymbol body) {
        if (this.isConstructor()) {
            body.addConstructor(this);
        } else {
            body.addMethod(this);
        }
    }

    void doneParsing() {
        super.doneParsing();
        this.generateParameterArray();
    }

    private void generateParameterArray() {
        int size = this.parameters.size();
        this.parameterArray = size > 0 ? this.parameters.toArray(new VariableSymbol[size]) : VariableSymbol.EMPTY_ARRAY;
        MethodSymbol.freeArrayList(this.parameters);
        this.parameters = null;
    }

    public NameSymbol getName() {
        return this.name;
    }

    public void setName(NameSymbol name) {
        this.name = name;
    }
}

