/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.CodeElement;
import oracle.javatools.parser.java.v1.symbol.ControlStatement;
import oracle.javatools.parser.java.v1.symbol.ExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class ForStatement
extends ControlStatement {
    private CodeElement[] initArray;
    private ExpressionSymbol conditional;
    private ExpressionSymbol[] updateArray;
    private ArrayList inits;
    private ArrayList updates;

    public CodeElement[] getInits() {
        return this.initArray;
    }

    public ExpressionSymbol getConditional() {
        return this.conditional;
    }

    public ExpressionSymbol[] getUpdates() {
        return this.updateArray;
    }

    public VariableSymbol findVariable(String name) {
        CodeElement[] initSyms = this.getInits();
        int initCount = initSyms.length;
        int c = 0;
        while (c < initCount) {
            CodeElement initSym = initSyms[c];
            if (initSym != null) {
                VariableSymbol[] varSyms = initSym.getVariables();
                if (varSyms == null) {
                    return null;
                }
                int varCount = varSyms.length;
                int v = 0;
                while (v < varCount) {
                    VariableSymbol varSym = varSyms[v];
                    if (varSym != null && ForStatement.matches(varSym, name)) {
                        return varSym;
                    }
                    ++v;
                }
            }
            ++c;
        }
        return null;
    }

    private void $init$() {
        this.initArray = null;
        this.conditional = null;
        this.updateArray = null;
        this.inits = ForStatement.allocArrayList();
        this.updates = ForStatement.allocArrayList();
    }

    ForStatement() {
        super(532);
        this.$init$();
    }

    void addInit(CodeElement init) {
        this.inits.add(init);
    }

    void setConditional(ExpressionSymbol conditional) {
        this.conditional = conditional;
    }

    void addUpdate(ExpressionSymbol update) {
        this.updates.add(update);
    }

    void doneParsing() {
        super.doneParsing();
        this.generateInitArray();
        this.generateUpdateArray();
    }

    private void generateInitArray() {
        int size = this.inits.size();
        this.initArray = size > 0 ? this.inits.toArray(new CodeElement[size]) : CodeElement.EMPTY_ARRAY;
        ForStatement.freeArrayList(this.inits);
        this.inits = null;
    }

    private void generateUpdateArray() {
        int size = this.updates.size();
        this.updateArray = size > 0 ? this.updates.toArray(new ExpressionSymbol[size]) : ExpressionSymbol.EMPTY_ARRAY;
        ForStatement.freeArrayList(this.updates);
        this.updates = null;
    }
}

