/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import oracle.javatools.parser.java.v1.symbol.ErrorReporter;
import oracle.javatools.parser.java.v1.symbol.ErrorSymbol;
import oracle.javatools.parser.java.v1.symbol.ExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbolFactory;
import oracle.javatools.parser.java.v1.symbol.OperatorExpression;
import oracle.javatools.parser.util.ExpressionStack;

class ExpressionWrapper
extends ExpressionSymbol
implements ErrorReporter {
    private ErrorSymbol[] errorArray;
    private ExpressionStack stack;

    public boolean hasErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray.length > 0;
    }

    public ErrorSymbol[] getErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray;
    }

    public final void setErrorArray(ErrorSymbol[] errorArray) {
        this.errorArray = errorArray;
    }

    private void $init$() {
        this.errorArray = null;
    }

    ExpressionWrapper(int code, int index) {
        super(code, index);
        this.$init$();
    }

    void addOperand(ExpressionSymbol operand) {
        if (this.firstOperand == null) {
            this.firstOperand = operand;
        } else {
            if (this.stack == null) {
                this.stack = new ExpressionStack();
                this.stack.add(this.firstOperand);
            }
            this.stack.add(operand);
        }
    }

    void process(JavaSymbolFactory f) {
        if (this.stack != null) {
            this.stack.setClosingArgument(f);
            this.firstOperand = (ExpressionSymbol)this.stack.process();
            this.stack = null;
            if (ExpressionWrapper.isBinaryPlus(this.firstOperand)) {
                this.firstOperand = ExpressionWrapper.rebalance(this.firstOperand);
            }
        }
    }

    private static boolean isBinaryPlus(ExpressionSymbol e) {
        return e.getExactCode() == 67 && e.getCategory() == 3;
    }

    private static ExpressionSymbol rotate(ExpressionSymbol p) {
        ExpressionSymbol d = p.firstOperand;
        OperatorExpression b = (OperatorExpression)d.firstOperand;
        ExpressionSymbol c = b.secondOperand;
        p.firstOperand = b;
        b.secondOperand = d;
        d.firstOperand = c;
        return b;
    }

    private static ExpressionSymbol rebalance(ExpressionSymbol root) {
        ExpressionSymbol current = root;
        int count = 0;
        while (ExpressionWrapper.isBinaryPlus(current)) {
            current = current.firstOperand;
            ++count;
        }
        while (count > 4) {
            current = root;
            while (ExpressionWrapper.isBinaryPlus(current.firstOperand) && ExpressionWrapper.isBinaryPlus(current.firstOperand.firstOperand)) {
                current = ExpressionWrapper.rotate(current);
            }
            count /= 2;
        }
        return root;
    }
}

