/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.CatchClause;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.CodeElement;
import oracle.javatools.parser.java.v1.symbol.ErrorReporter;
import oracle.javatools.parser.java.v1.symbol.ErrorSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class CodeBlockSymbol
extends JavaSymbol
implements ErrorReporter,
Scope {
    private CodeElement[] codeElementArray;
    private ErrorSymbol[] errorArray;
    private ArrayList codeElements;
    private Scope scope;

    public CodeElement[] getCodeElements() {
        if (this.codeElementArray == null) {
            this.generateCodeElementArray();
        }
        return this.codeElementArray;
    }

    public boolean isFilledIn() {
        return this.code != 509;
    }

    public boolean hasErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray.length > 0;
    }

    public ErrorSymbol[] getErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray;
    }

    public final void setErrorArray(ErrorSymbol[] errorArray) {
        this.errorArray = errorArray;
    }

    public int getScopeType() {
        return 4;
    }

    public Scope getEnclosingScope() {
        return this.scope;
    }

    public void setEnclosingScope(Scope scope) {
        this.scope = scope;
    }

    public int getModifiers() {
        return 0;
    }

    public boolean findLabel(String name) {
        return false;
    }

    public VariableSymbol findVariable(String name) {
        CodeElement[] elementSyms = this.getCodeElements();
        int elementCount = elementSyms.length;
        int c = 0;
        while (c < elementCount) {
            CodeElement elementSym = elementSyms[c];
            if (elementSym != null && elementSym.getType() == 2) {
                VariableSymbol[] varSyms = elementSym.getVariables();
                int varCount = varSyms.length;
                int v = 0;
                while (v < varCount) {
                    VariableSymbol varSym = varSyms[v];
                    if (varSym != null && CodeBlockSymbol.matches(varSym, name)) {
                        return varSym;
                    }
                    ++v;
                }
            }
            ++c;
        }
        return null;
    }

    public ClassSymbol findType(String name) {
        CodeElement[] elementSyms = this.getCodeElements();
        int elementCount = elementSyms.length;
        int c = 0;
        while (c < elementCount) {
            ClassSymbol classSym;
            CodeElement elementSym = elementSyms[c];
            if (elementSym != null && elementSym.getType() == 1 && CodeBlockSymbol.matches(classSym = elementSym.getClassDefinition(), name)) {
                return classSym;
            }
            ++c;
        }
        return null;
    }

    public NameSymbol[] getLabels() {
        return NameSymbol.EMPTY_ARRAY;
    }

    public VariableSymbol[] getVariables() {
        CodeElement[] elementSyms = this.getCodeElements();
        int elementCount = elementSyms.length;
        int outCount = 0;
        int c = 0;
        while (c < elementCount) {
            CodeElement elementSym = elementSyms[c];
            if (elementSym != null && elementSym.getType() == 2) {
                VariableSymbol[] varSyms = elementSym.getVariables();
                outCount += varSyms.length;
            }
            ++c;
        }
        if (outCount == 0) {
            return VariableSymbol.EMPTY_ARRAY;
        }
        VariableSymbol[] out = new VariableSymbol[outCount];
        outCount = 0;
        int c2 = 0;
        while (c2 < elementCount) {
            CodeElement elementSym = elementSyms[c2];
            if (elementSym != null && elementSym.getType() == 2) {
                VariableSymbol[] varSyms = elementSym.getVariables();
                int varCount = varSyms.length;
                int v = 0;
                while (v < varCount) {
                    out[outCount++] = varSyms[v];
                    ++v;
                }
            }
            ++c2;
        }
        return out;
    }

    public ClassSymbol[] getClasses() {
        CodeElement[] elementSyms = this.getCodeElements();
        int elementCount = elementSyms.length;
        int outCount = 0;
        int c = 0;
        while (c < elementCount) {
            CodeElement elementSym = elementSyms[c];
            if (elementSym != null && elementSym.getType() == 1) {
                ++outCount;
            }
            ++c;
        }
        if (outCount == 0) {
            return ClassSymbol.EMPTY_ARRAY;
        }
        ClassSymbol[] out = new ClassSymbol[outCount];
        outCount = 0;
        int c2 = 0;
        while (c2 < elementCount) {
            CodeElement elementSym = elementSyms[c2];
            if (elementSym != null && elementSym.getType() == 1) {
                out[outCount++] = elementSym.getClassDefinition();
            }
            ++c2;
        }
        return out;
    }

    public CatchClause[] getCatchClauses() {
        return CatchClause.EMPTY_ARRAY;
    }

    private void $init$() {
        this.codeElementArray = null;
        this.errorArray = null;
        this.codeElements = CodeBlockSymbol.allocArrayList();
    }

    CodeBlockSymbol(int code) {
        super(code);
        this.$init$();
    }

    void addCodeElement(CodeElement ce) {
        this.codeElements.add(ce);
    }

    void doneParsing() {
        super.doneParsing();
        this.generateCodeElementArray();
    }

    private void generateCodeElementArray() {
        int size = this.codeElements.size();
        this.codeElementArray = size > 0 ? this.codeElements.toArray(new CodeElement[size]) : CodeElement.EMPTY_ARRAY;
        CodeBlockSymbol.freeArrayList(this.codeElements);
        this.codeElements = null;
    }
}

