/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.CatchClause;
import oracle.javatools.parser.java.v1.symbol.ClassBodySymbol;
import oracle.javatools.parser.java.v1.symbol.ClassListSymbol;
import oracle.javatools.parser.java.v1.symbol.CodeElement;
import oracle.javatools.parser.java.v1.symbol.CommentSymbol;
import oracle.javatools.parser.java.v1.symbol.Commentable;
import oracle.javatools.parser.java.v1.symbol.CreatorExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.FieldSymbol;
import oracle.javatools.parser.java.v1.symbol.HasModifiers;
import oracle.javatools.parser.java.v1.symbol.InnerClassSymbol;
import oracle.javatools.parser.java.v1.symbol.MemberSymbol;
import oracle.javatools.parser.java.v1.symbol.MethodSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Nameable;
import oracle.javatools.parser.java.v1.symbol.RootSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class ClassSymbol
extends HasModifiers
implements Commentable,
Nameable,
Scope {
    private CommentSymbol comment;
    private NameSymbol name;
    private int modifiers;
    private int classIndex;
    private TypeSymbol baseClass;
    private ClassListSymbol baseInterfaces;
    private ClassBodySymbol body;
    private Scope scope;
    static final ClassSymbol[] EMPTY_ARRAY = new ClassSymbol[0];

    public boolean isClass() {
        return this.code == 200 || this.code == 760;
    }

    public NameSymbol getBaseClass() {
        if (this.baseClass == null) {
            return null;
        }
        return this.baseClass.getName();
    }

    public TypeSymbol getBaseClassType() {
        return this.baseClass;
    }

    public ClassBodySymbol getBody() {
        return this.body;
    }

    public NameSymbol[] getBaseInterfaces() {
        return this.baseInterfaces != null ? this.baseInterfaces.listClasses() : NameSymbol.EMPTY_ARRAY;
    }

    public TypeSymbol[] getBaseInterfaceTypes() {
        return this.baseInterfaces != null ? this.baseInterfaces.listClassTypes() : TypeSymbol.EMPTY_ARRAY;
    }

    public MemberSymbol[] getMembers() {
        return this.body.listMembers();
    }

    public MethodSymbol[] getMethods() {
        return this.body.listMethods();
    }

    public FieldSymbol[] getFields() {
        return this.body.listFields();
    }

    public MethodSymbol[] getConstructors() {
        return this.body.listConstructors();
    }

    public InnerClassSymbol[] getInnerClasses() {
        return this.body.listInnerClasses();
    }

    public MemberSymbol[] getInitializers() {
        return this.body.listInitializers();
    }

    public boolean isDeprecated() {
        if (this.comment != null) {
            return this.comment.isDeprecated();
        }
        return false;
    }

    public boolean isHidden() {
        if (this.comment != null) {
            return this.comment.isHidden();
        }
        return false;
    }

    public int getScopeType() {
        return 1;
    }

    public Scope getEnclosingScope() {
        return this.scope;
    }

    public void setEnclosingScope(Scope scope) {
        this.scope = scope;
    }

    public boolean findLabel(String name) {
        return false;
    }

    public VariableSymbol findVariable(String name) {
        FieldSymbol[] fieldSyms = this.getFields();
        int fieldCount = fieldSyms.length;
        int f = 0;
        while (f < fieldCount) {
            FieldSymbol fieldSym = fieldSyms[f];
            if (fieldSym != null) {
                VariableSymbol[] varSyms = fieldSym.getVariables();
                int varCount = varSyms.length;
                int v = 0;
                while (v < varCount) {
                    VariableSymbol varSym = varSyms[v];
                    if (ClassSymbol.matches(varSym, name)) {
                        return varSym;
                    }
                    ++v;
                }
            }
            ++f;
        }
        return null;
    }

    public ClassSymbol findType(String name) {
        InnerClassSymbol[] classSyms = this.getInnerClasses();
        int classCount = classSyms.length;
        int i = 0;
        while (i < classCount) {
            ClassSymbol classSym = classSyms[i].getClassDefinition();
            if (ClassSymbol.matches(classSym, name)) {
                return classSym;
            }
            ++i;
        }
        return null;
    }

    public NameSymbol[] getLabels() {
        return NameSymbol.EMPTY_ARRAY;
    }

    public VariableSymbol[] getVariables() {
        FieldSymbol[] fields = this.getFields();
        ArrayList list = ClassSymbol.allocArrayList();
        int fieldCount = fields.length;
        int f = 0;
        while (f < fieldCount) {
            VariableSymbol[] varSyms;
            FieldSymbol field = fields[f];
            if (field != null && (varSyms = field.getVariables()) != null) {
                int varCount = varSyms.length;
                int v = 0;
                while (v < varCount) {
                    VariableSymbol varSym = varSyms[v];
                    if (varSym != null) {
                        list.add(varSym);
                    }
                    ++v;
                }
            }
            ++f;
        }
        int count = list.size();
        VariableSymbol[] out = count > 0 ? list.toArray(new VariableSymbol[count]) : VariableSymbol.EMPTY_ARRAY;
        ClassSymbol.freeArrayList(list);
        return out;
    }

    public ClassSymbol[] getClasses() {
        InnerClassSymbol[] syms = this.getInnerClasses();
        int count = syms.length;
        ClassSymbol[] out = new ClassSymbol[count];
        int i = 0;
        while (i < count) {
            InnerClassSymbol sym = syms[i];
            if (sym != null) {
                out[i] = sym.getClassDefinition();
            }
            ++i;
        }
        return out;
    }

    public CatchClause[] getCatchClauses() {
        return CatchClause.EMPTY_ARRAY;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    private void $init$() {
        this.comment = null;
        this.name = null;
        this.modifiers = 0;
    }

    ClassSymbol(int code, int index) {
        super(code);
        this.$init$();
        this.classIndex = index;
    }

    void setBody(ClassBodySymbol body) {
        this.body = body;
    }

    void setBaseClass(TypeSymbol type) {
        this.baseClass = type;
    }

    void setBaseInterfaces(ClassListSymbol interfaces) {
        this.baseInterfaces = interfaces;
    }

    void doneParsing() {
        if (this.code == 200 || this.code == 400) {
            this.setModifiers(((HasModifiers)this.parent).getModifiers());
            if (this.parent.code == 280) {
                MemberSymbol memberSym = (MemberSymbol)this.parent;
                this.setComment(memberSym.getComment());
                new InnerClassSymbol(this);
            } else if (this.parent.parent.code == 510) {
                ((CodeElement)this.parent.parent).setClass(this);
                this.body.doneParsingLocalClass(true, this);
            } else {
                this.setComment(((Commentable)((Object)this.parent)).getComment());
                RootSymbol root = (RootSymbol)this.parent.parent;
                root.addClass(this);
            }
        } else if (this.code == 760) {
            ((CreatorExpressionSymbol)this.parent).setClass(this);
        }
    }

    public CommentSymbol getComment() {
        return this.comment;
    }

    public void setComment(CommentSymbol comment) {
        this.comment = comment;
    }

    public NameSymbol getName() {
        return this.name;
    }

    public void setName(NameSymbol name) {
        this.name = name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }
}

