/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v1.JavaParser;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.ExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.ImportSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.MethodSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Nameable;
import oracle.javatools.parser.java.v1.symbol.PackageSymbol;
import oracle.javatools.parser.java.v1.symbol.RootSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public final class JavaUtilities {
    private static final int IMPORTS_EXPLICIT_ONLY = 1;
    private static final int IMPORTS_MULTI_ONLY = 2;
    private static final int IMPORTS_ALL = 3;

    private JavaUtilities() {
    }

    public static RootSymbol getParseTree(ReadTextBuffer textBuffer) {
        return JavaUtilities.getParseTree(textBuffer, false);
    }

    public static RootSymbol getParseTree(ReadTextBuffer textBuffer, boolean fullDepth) {
        RootSymbol rootSymbol = null;
        textBuffer.readLock();
        try {
            try {
                JavaParser.ParsingOptions parseOptions = new JavaParser.ParsingOptions();
                parseOptions.parseDepth = fullDepth ? 3 : 2;
                parseOptions.reportErrors = true;
                rootSymbol = (RootSymbol)JavaParser.parse(textBuffer, parseOptions);
            }
            catch (Exception e) {
                rootSymbol = null;
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return rootSymbol;
    }

    public static RootSymbol getImportsParseTree(TextBuffer textBuffer) {
        RootSymbol rootSymbol = null;
        textBuffer.readLock();
        try {
            try {
                JavaParser.ParsingOptions parseOptions = new JavaParser.ParsingOptions();
                parseOptions.parseDepth = 1;
                parseOptions.reportErrors = true;
                rootSymbol = (RootSymbol)JavaParser.parse(textBuffer, parseOptions);
            }
            catch (Exception e) {
                rootSymbol = null;
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return rootSymbol;
    }

    public static ExpressionSymbol parseExpression(String target) {
        ReadTextBuffer targetBuffer = TextBufferFactory.createReadTextBuffer(target);
        JavaParser.ParsingOptions options = new JavaParser.ParsingOptions();
        options.inputType = 3;
        ExpressionSymbol targetExpr = (ExpressionSymbol)JavaParser.parse(targetBuffer, options);
        return targetExpr;
    }

    public static ExpressionSymbol parseExpression(ReadTextBuffer wholeBuffer, int startOffset, int endOffset, Scope scope) {
        EofTextBuffer buffer = new EofTextBuffer(wholeBuffer, endOffset, null);
        JavaParser.ParsingOptions options = new JavaParser.ParsingOptions();
        options.inputType = 3;
        options.startOffset = startOffset;
        options.scope = scope;
        return (ExpressionSymbol)JavaParser.parse(buffer, options);
    }

    public static MethodSymbol parseMethodDeclaration(String target) {
        String classTarget = "class __aoeunth__ { " + target + " { } }";
        ReadTextBuffer classBuffer = TextBufferFactory.createReadTextBuffer(classTarget);
        RootSymbol rootSymbol = JavaParser.parse(classBuffer);
        if (rootSymbol == null) {
            return null;
        }
        try {
            ClassSymbol[] classes = rootSymbol.getClasses();
            ClassSymbol shellClass = classes[0];
            MethodSymbol[] methods = shellClass.getMethods();
            MethodSymbol out = methods[0];
            if (out != null) {
                MethodSymbol methodSymbol = out;
                return methodSymbol;
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        return null;
    }

    public static String[] getExplicitImports(RootSymbol rootSymbol) {
        List importList = JavaUtilities.getImports(rootSymbol, 1);
        String[] importArray = JavaUtilities.convertListToArray(importList);
        return importArray;
    }

    public static String[] getMultiImports(RootSymbol rootSymbol) {
        List importList = JavaUtilities.getImports(rootSymbol, 2);
        String[] importArray = JavaUtilities.convertListToArray(importList);
        return importArray;
    }

    public static String[] getMultiImportPackages(RootSymbol rootSymbol) {
        List importList = JavaUtilities.getImports(rootSymbol, 2);
        ArrayList<String> packageList = new ArrayList<String>();
        for (String importString : importList) {
            int lastDot = importString.lastIndexOf(46);
            String packageName = importString.substring(0, lastDot);
            packageList.add(packageName);
        }
        String[] importArray = JavaUtilities.convertListToArray(packageList);
        return importArray;
    }

    public static String[] getAllImports(RootSymbol rootSymbol) {
        List importList = JavaUtilities.getImports(rootSymbol, 3);
        String[] importArray = JavaUtilities.convertListToArray(importList);
        return importArray;
    }

    public static String getPackageName(RootSymbol rootSymbol) {
        String packageName = "";
        if (rootSymbol != null) {
            PackageSymbol packageSymbol = rootSymbol.getPackage();
            packageName = JavaUtilities.getSymbolName(packageSymbol);
        }
        return packageName;
    }

    public static String getClassName(ClassSymbol classSymbol) {
        return JavaUtilities.getSymbolName(classSymbol);
    }

    public static String getMethodName(MethodSymbol methodSymbol) {
        return JavaUtilities.getSymbolName(methodSymbol);
    }

    public static String getVariableName(VariableSymbol variableSymbol) {
        return JavaUtilities.getSymbolName(variableSymbol);
    }

    public static String getTypeName(TypeSymbol typeSymbol) {
        return JavaUtilities.getSymbolName(typeSymbol);
    }

    public static int getSymbolNameOffset(Nameable nameableSymbol) {
        int offset = -1;
        if (nameableSymbol != null) {
            NameSymbol nameSymbol = nameableSymbol.getName();
            if (nameSymbol != null) {
                return nameSymbol.getStartOffset();
            }
            return ((JavaSymbol)((Object)nameableSymbol)).getStartOffset();
        }
        return offset;
    }

    public static int getSymbolNameLength(Nameable nameableSymbol) {
        NameSymbol nameSymbol;
        int length = 0;
        if (nameableSymbol != null && (nameSymbol = nameableSymbol.getName()) != null) {
            return nameSymbol.getEndOffset() - nameSymbol.getStartOffset();
        }
        return length;
    }

    public static String getSymbolName(Nameable nameableSymbol) {
        String symbolName = "";
        if (nameableSymbol != null) {
            NameSymbol nameSymbol = nameableSymbol.getName();
            symbolName = JavaUtilities.getSymbolName(nameSymbol);
        }
        return symbolName;
    }

    public static String getSymbolName(NameSymbol nameSymbol) {
        String name;
        String symbolName = "";
        if (nameSymbol != null && (name = nameSymbol.getValue()) != null) {
            symbolName = name;
        }
        return symbolName;
    }

    public static int getArrayDimension(TypeSymbol typeSymbol) {
        int dimension = 0;
        if (typeSymbol != null) {
            dimension = typeSymbol.getArrayDimension();
        }
        return dimension;
    }

    public static String[] convertListToArray(List list) {
        int listSize = list.size();
        String[] array = new String[listSize];
        int i = 0;
        while (i < listSize) {
            array[i] = (String)list.get(i);
            ++i;
        }
        return array;
    }

    public static boolean inJavaSymbol(int offset, JavaSymbol javaSymbol) {
        return offset >= javaSymbol.getStartOffset() && offset <= javaSymbol.getEndOffset();
    }

    /*
     * Unable to fully structure code
     */
    public static String trimWhitespace(String name, int start, int end) {
        while (start < end && Character.isWhitespace(name.charAt(start))) {
            ++start;
        }
        if (start != end) ** GOTO lbl7
        return "";
lbl-1000:
        // 1 sources

        {
            --end;
lbl7:
            // 2 sources

            ** while (Character.isWhitespace((char)name.charAt((int)(end - 1))))
        }
lbl8:
        // 1 sources

        return name.substring(start, end);
    }

    public static String trimWhitespace(String name, int start) {
        return JavaUtilities.trimWhitespace(name, start, name.length());
    }

    public static String trimWhitespace(String name) {
        return JavaUtilities.trimWhitespace(name, 0, name.length());
    }

    public static String[] breakUpQualifiedName(String name) {
        int fullLength = name.length();
        int count = 1;
        int i = 0;
        while (i < fullLength) {
            if (name.charAt(i) == '.') {
                ++count;
            }
            ++i;
        }
        int nNames = count;
        String[] outArray = new String[nNames];
        int prevDot = -1;
        int lastDot = name.indexOf(46);
        int i2 = 0;
        while (i2 < nNames - 1) {
            outArray[i2] = JavaUtilities.trimWhitespace(name, prevDot + 1, lastDot);
            prevDot = lastDot;
            lastDot = name.indexOf(46, prevDot + 1);
            ++i2;
        }
        outArray[nNames - 1] = JavaUtilities.trimWhitespace(name, prevDot + 1);
        return outArray;
    }

    private static List getImports(RootSymbol rootSymbol, int importRequestType) {
        ImportSymbol[] importSymbols;
        ArrayList<String> importList = new ArrayList<String>();
        if (rootSymbol != null && (importSymbols = rootSymbol.getImports()) != null) {
            int listSize = importSymbols.length;
            int i = 0;
            while (i < listSize) {
                ImportSymbol importSymbol = importSymbols[i];
                String importName = JavaUtilities.getSymbolName(importSymbol);
                if (importName != null && importName.length() > 0) {
                    int importType;
                    int n = importType = importName.endsWith(".*") ? 2 : 1;
                    if ((importType & importRequestType) != 0) {
                        importList.add(importName);
                    }
                }
                ++i;
            }
        }
        return importList;
    }

    private static class EofTextBuffer
    implements ReadTextBuffer {
        private ReadTextBuffer textBuffer;
        private int eofOffset;

        private EofTextBuffer(ReadTextBuffer textBuffer, int eofOffset) {
            this.textBuffer = textBuffer;
            this.eofOffset = eofOffset;
        }

        public int getLength() {
            return this.eofOffset;
        }

        public char getChar(int offset) throws IndexOutOfBoundsException {
            if (this.eofOffset < offset + 1) {
                throw new IndexOutOfBoundsException("Index out of range: " + offset);
            }
            return this.textBuffer.getChar(offset);
        }

        public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
            if (this.eofOffset < offset + length) {
                throw new IndexOutOfBoundsException("Index out of range: " + (offset + length));
            }
            return this.textBuffer.getChars(offset, length);
        }

        public String getString(int offset, int length) throws IndexOutOfBoundsException {
            if (this.eofOffset < offset + length) {
                throw new IndexOutOfBoundsException("Index out of range: " + (offset + length));
            }
            return this.textBuffer.getString(offset, length);
        }

        public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
            if (this.eofOffset < offset + length) {
                throw new IndexOutOfBoundsException("Index out of range: " + (offset + length));
            }
            this.textBuffer.getText(offset, length, segment);
        }

        public void readLock() {
            this.textBuffer.readLock();
        }

        public boolean tryReadLock() {
            return this.textBuffer.tryReadLock();
        }

        public int getLockStatus() {
            return this.textBuffer.getLockStatus();
        }

        public void readUnlock() {
            this.textBuffer.readUnlock();
        }

        EofTextBuffer(ReadTextBuffer readTextBuffer, int n, 1 var3_3) {
            this(readTextBuffer, n);
        }

        public final class 1 {
        }
    }
}

