/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.html;

import oracle.javatools.parser.AbstractLexer;

abstract class EmbeddedLexer
extends AbstractLexer {
    protected boolean recognizeJSP = false;
    protected boolean recognizeEmbeddedTags = false;

    EmbeddedLexer() {
    }

    public void setRecognizeJSP(boolean recognizeJSP) {
        this.recognizeJSP = recognizeJSP;
    }

    public void setRecognizeEmbeddedTags(boolean recognizeEmbeddedTags) {
        this.recognizeEmbeddedTags = recognizeEmbeddedTags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void skipHTMLTag() {
        char quote = '\u0000';
        boolean endOnQuote = false;
        while (true) {
            char c;
            if ((c = this.textBuffer.getChar(this.currentPos++)) == '\\') {
                ++this.currentPos;
                continue;
            }
            if (quote != '\u0000') {
                if (quote != c) continue;
                quote = '\u0000';
                if (!endOnQuote) continue;
                --this.currentPos;
                return;
            }
            if (c == '\"' || c == '\'') {
                quote = c;
                if (!this.isEmbeddedTagStart(this.currentPos)) continue;
                this.skipEmbeddedTag();
                continue;
            }
            if (c == '<') {
                if (this.isEmbeddedTagStart(this.currentPos - 1)) {
                    if (this.textBuffer.getChar(this.currentPos) == '/') {
                        --this.currentPos;
                        return;
                    }
                    c = this.textBuffer.getChar(this.currentPos - 2);
                    if (c == '\"' || c == '\'') {
                        quote = c;
                    }
                    this.skipEmbeddedTag();
                    c = this.textBuffer.getChar(this.currentPos);
                    if (quote == c) return;
                    if (quote == '\u0000') continue;
                    endOnQuote = true;
                    continue;
                }
                if (quote != '\u0000') continue;
                --this.currentPos;
                return;
            }
            if (c == '>') return;
        }
    }

    private void _skipToTagEnd() {
        while (this.textBuffer.getChar(this.currentPos++) != '>') {
        }
    }

    protected boolean isEmbeddedTagStart(int searchPosition) {
        char c;
        if (this.recognizeJSP && this.recognizeEmbeddedTags) {
            char c2;
            if ((c2 = this.textBuffer.getChar(searchPosition++)) == '<') {
                if (this.textBuffer.getChar(searchPosition) == '%' && this.textBuffer.getChar(searchPosition + 1) == '=') {
                    return true;
                }
                int MAX_PREFIX_LOOKAHEAD = 6;
                int j = 0;
                while (j <= MAX_PREFIX_LOOKAHEAD) {
                    if (this.textBuffer.getChar(searchPosition + j) == '\'' || this.textBuffer.getChar(searchPosition + j) == '\"') {
                        return false;
                    }
                    if (this.textBuffer.getChar(searchPosition + j) == ':') {
                        return true;
                    }
                    ++j;
                }
                return false;
            }
            if (c2 == '$') {
                return this.textBuffer.getChar(searchPosition) == '{';
            }
        } else if (this.recognizeEmbeddedTags && (c = this.textBuffer.getChar(searchPosition++)) == '<') {
            return this.textBuffer.getChar(searchPosition) != '!' || this.textBuffer.getChar(searchPosition + 1) != '-' || this.textBuffer.getChar(searchPosition + 2) != '-';
        }
        return false;
    }

    protected void skipEmbeddedTag() {
        if (this.textBuffer.getChar(this.currentPos + 1) == '%') {
            this.skipJSPScriplet();
        } else if (this.textBuffer.getChar(this.currentPos) == '{' || this.textBuffer.getChar(this.currentPos + 1) == '{') {
            this.skipJSPEL();
        } else {
            this.skipHTMLTag();
            if (this.textBuffer.getChar(this.currentPos - 1) == '>' && this.textBuffer.getChar(this.currentPos - 2) != '/' && this.textBuffer.getChar(this.currentPos) != '\"' && this.textBuffer.getChar(this.currentPos) != '\'') {
                this._skipToTagEnd();
            }
        }
    }

    protected void skipJSPScriplet() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '%' || (c = this.textBuffer.getChar(this.currentPos)) != '>') {
        }
        ++this.currentPos;
    }

    protected void skipJSPEL() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '}') {
        }
    }
}

