/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.generic;

import oracle.javatools.parser.generic.BraceHelper;
import oracle.javatools.parser.generic.GenericTokens;
import oracle.javatools.parser.util.KeywordTable;

public abstract class Language
implements GenericTokens {
    protected KeywordTable keywordTable = null;
    protected BraceHelper braceHelper;
    public static final String[] EMPTY_ARRAY = new String[0];

    protected Language() {
    }

    public abstract boolean isCaseSensitive();

    public abstract boolean isIdentifierCharacter(char var1);

    public abstract String[] getKeywords();

    protected KeywordTable getKeywordTable() {
        if (this.keywordTable == null) {
            String[] keywords = this.getKeywords();
            int numKeywords = keywords != null ? keywords.length : 0;
            boolean sensitive = this.isCaseSensitive();
            this.keywordTable = new KeywordTable(numKeywords);
            this.keywordTable.setCaseSensitivity(sensitive);
            int i = 0;
            while (i < numKeywords) {
                String keyword = keywords[i];
                if (keyword != null && keyword.length() > 0) {
                    this.keywordTable.addKeyword(keyword, 10);
                }
                ++i;
            }
        }
        return this.keywordTable;
    }

    public abstract String[] getSingleLineComments();

    public abstract String[][] getMultiLineComments();

    public abstract String[][] getQuotes();

    public abstract String[][] getBraces();

    public String[] getOperators() {
        return EMPTY_ARRAY;
    }

    public abstract boolean usesIntegers();

    public abstract boolean usesFloats();

    public abstract String[] getOctals();

    public abstract String[] getHexadecimals();

    public BraceHelper getBraceHelper() {
        if (this.braceHelper == null && this.getBraces() != null) {
            this.braceHelper = new BraceHelper(this);
        }
        return this.braceHelper;
    }
}

