/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.generic;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.generic.GenericTokens;
import oracle.javatools.parser.generic.Language;
import oracle.javatools.parser.util.KeywordTable;

public class GenericLexer
extends AbstractLexer
implements GenericTokens {
    protected int lastToken = -1;
    protected int startOffset = -1;
    protected int endOffset = -1;
    protected boolean useLastToken = false;
    protected boolean skipComments = false;
    protected KeywordTable keywordTable;
    protected Language language;
    private static final String[] FLOAT_PATTERNS = new String[]{".0", ".1", ".2", ".3", ".4", ".5", ".6", ".7", ".8", ".9"};
    private static final String[] EXPONENT_PATTERNS = new String[]{"e+0", "e+1", "e+2", "e+3", "e+4", "e+5", "e+6", "e+7", "e+8", "e+9", "e-0", "e-1", "e-2", "e-3", "e-4", "e-5", "e-6", "e-7", "e-8", "e-9", "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9"};

    public GenericLexer(Language language) {
        this.setTextBuffer(null);
        this.setPosition(0);
        this.language = language;
        this.keywordTable = language.getKeywordTable();
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    public int lex(LexerToken lexedToken) {
        block21: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            this.lastToken = 0;
            try {
                int hash;
                char c;
                block5: while (true) {
                    c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block5;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    int isSLCStart = this.isSingleLineCommentStart(this.startOffset);
                    if (isSLCStart != -1) {
                        this.lastToken = 12;
                        this.skipSingleLineComment(this.startOffset, isSLCStart);
                        if (this.skipComments) {
                            this.lastToken = 0;
                            continue;
                        }
                        break block21;
                    }
                    int isMLCStart = this.isMultiLineCommentStart(this.startOffset);
                    if (isMLCStart != -1) {
                        this.lastToken = 13;
                        this.skipMultiLineComment(this.startOffset, isMLCStart);
                        if (this.skipComments) {
                            this.lastToken = 0;
                            continue;
                        }
                        break block21;
                    }
                    int isQuoteStart = this.isQuotesStart(this.startOffset);
                    if (isQuoteStart != -1) {
                        this.lastToken = 14;
                        this.skipQuotes(this.startOffset, isQuoteStart);
                        break block21;
                    }
                    int isOpenBraceStart = this.isOpenBraceStart(this.startOffset);
                    if (isOpenBraceStart != -1) {
                        this.lastToken = 17;
                        this.skipOpenBrace(this.startOffset, isOpenBraceStart);
                        break block21;
                    }
                    int isCloseBraceStart = this.isCloseBraceStart(this.startOffset);
                    if (isCloseBraceStart != -1) {
                        this.lastToken = 18;
                        this.skipCloseBrace(this.startOffset, isCloseBraceStart);
                        break block21;
                    }
                    int isHexStart = this.isHexadecimalStart(this.startOffset);
                    if (isHexStart != -1) {
                        this.lastToken = 15;
                        this.skipHexadecimal(this.startOffset, isHexStart);
                        break block21;
                    }
                    int isOctalStart = this.isOctalStart(this.startOffset);
                    if (isOctalStart != -1) {
                        this.lastToken = 15;
                        this.skipOctal(this.startOffset, isOctalStart);
                        break block21;
                    }
                    boolean isDecimalStart = this.isDecimalStart(this.startOffset);
                    if (isDecimalStart) {
                        this.lastToken = 15;
                        this.skipDecimal(this.startOffset);
                        break block21;
                    }
                    boolean isDecimalPointStart = this.isDecimalPointStart(this.startOffset);
                    if (isDecimalPointStart) {
                        this.lastToken = 16;
                        this.skipFloat(this.startOffset);
                        break block21;
                    }
                    boolean isOperatorStart = this.isOperatorStart(this.startOffset);
                    if (isOperatorStart) {
                        this.lastToken = 19;
                        this.skipOperator(this.startOffset);
                        break block21;
                    }
                    if (this.language.isIdentifierCharacter(c)) break;
                }
                int n = hash = this.language.isCaseSensitive() ? KeywordTable.computePartialHash(c, 0) : KeywordTable.computeInsensitivePartialHash(c, 0);
                while (this.language.isIdentifierCharacter(c = this.textBuffer.getChar(this.currentPos))) {
                    hash = this.language.isCaseSensitive() ? KeywordTable.computePartialHash(c, hash) : KeywordTable.computeInsensitivePartialHash(c, hash);
                    ++this.currentPos;
                }
                int keyword = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, hash);
                this.lastToken = keyword == -1 ? 11 : keyword;
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken == 0) {
                    this.startOffset = this.currentPos;
                }
                if (!this.skipComments || this.lastToken != 12 && this.lastToken != 13) break block21;
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int offset) {
        super.setPosition(offset);
        this.useLastToken = false;
    }

    private int isSingleLineCommentStart(int offset) {
        String[] comments = this.language.getSingleLineComments();
        return this.getMatchingPattern(offset, comments);
    }

    private void skipSingleLineComment(int startOffset, int index) {
        String[] comments = this.language.getSingleLineComments();
        int startLength = comments[index].length();
        this.currentPos = startOffset + startLength;
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
        }
    }

    private int isMultiLineCommentStart(int offset) {
        String[][] commentPairs = this.language.getMultiLineComments();
        int numPairs = commentPairs.length;
        int i = 0;
        while (i < numPairs) {
            String[] comments = commentPairs[i];
            if (this.matchPattern(offset, comments[0]) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void skipMultiLineComment(int startOffset, int index) {
        String[][] commentPairs = this.language.getMultiLineComments();
        String[] comments = commentPairs[index];
        int startLength = comments[0].length();
        String commentEnd = comments[1];
        this.currentPos = startOffset + startLength;
        while (true) {
            int length;
            if ((length = this.matchPattern(this.currentPos, commentEnd)) != -1) {
                this.currentPos += length;
                return;
            }
            ++this.currentPos;
        }
    }

    private int isQuotesStart(int offset) {
        String[][] quotePairs = this.language.getQuotes();
        int numPairs = quotePairs.length;
        int i = 0;
        while (i < numPairs) {
            String[] quotes = quotePairs[i];
            if (this.matchPattern(offset, quotes[0]) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void skipQuotes(int startOffset, int index) {
        String[][] quotePairs = this.language.getQuotes();
        String[] quotes = quotePairs[index];
        int startLength = quotes[0].length();
        String quoteEnd = quotes[1];
        int quotesLength = quotes.length;
        this.currentPos = startOffset + startLength;
        block0: while (true) {
            int i = 2;
            while (i < quotesLength) {
                int length = this.matchPattern(this.currentPos, quotes[i]);
                if (length != -1) {
                    this.currentPos += length;
                    continue block0;
                }
                ++i;
            }
            int length = this.matchPattern(this.currentPos, quoteEnd);
            if (length != -1) {
                this.currentPos += length;
                return;
            }
            ++this.currentPos;
        }
    }

    private int isOpenBraceStart(int offset) {
        String[][] bracePairs = this.language.getBraces();
        int numPairs = bracePairs.length;
        int i = 0;
        while (i < numPairs) {
            String[] braces = bracePairs[i];
            if (this.matchPattern(offset, braces[0]) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void skipOpenBrace(int startOffset, int index) {
        String[][] bracePairs = this.language.getBraces();
        String[] braces = bracePairs[index];
        int braceLength = braces[0].length();
        this.currentPos = startOffset + braceLength;
    }

    private int isCloseBraceStart(int offset) {
        String[][] bracePairs = this.language.getBraces();
        int numPairs = bracePairs.length;
        int i = 0;
        while (i < numPairs) {
            String[] braces = bracePairs[i];
            if (this.matchPattern(offset, braces[1]) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void skipCloseBrace(int startOffset, int index) {
        String[][] bracePairs = this.language.getBraces();
        String[] braces = bracePairs[index];
        int braceLength = braces[0].length();
        this.currentPos = startOffset + braceLength;
    }

    private boolean isOperatorStart(int offset) {
        String[] operators = this.language.getOperators();
        int numOperators = operators != null ? operators.length : 0;
        char c = this.textBuffer.getChar(offset);
        int i = 0;
        while (i < numOperators) {
            String operator = operators[i];
            if (operator.length() > 0 && operator.charAt(0) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void skipOperator(int startOffset) {
        String[] operators = this.language.getOperators();
        int numOperators = operators != null ? operators.length : 0;
        int currentLen = 2;
        boolean foundOne = true;
        while (foundOne) {
            this.currentPos = startOffset + currentLen - 1;
            foundOne = false;
            int i = 0;
            while (i < numOperators) {
                String operator = operators[i];
                if (operator.length() == currentLen && this.matchPattern(startOffset, operator) != -1) {
                    foundOne = true;
                    break;
                }
                ++i;
            }
            ++currentLen;
        }
    }

    private int isHexadecimalStart(int offset) {
        if (this.language.usesIntegers()) {
            String[] prefixes = this.language.getHexadecimals();
            return this.getMatchingPattern(offset, prefixes);
        }
        return -1;
    }

    private void skipHexadecimal(int startOffset, int index) {
        String[] prefixes = this.language.getHexadecimals();
        int startLength = prefixes[index].length();
        this.currentPos = startOffset + startLength;
        char c;
        while (this.isHexDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private int isOctalStart(int offset) {
        String[] prefixes;
        int index;
        if (this.language.usesIntegers() && (index = this.getMatchingPattern(offset, prefixes = this.language.getOctals())) != -1 && prefixes[index].equals("0")) {
            return -1;
        }
        return -1;
    }

    private void skipOctal(int startOffset, int index) {
        String[] prefixes = this.language.getOctals();
        int startLength = prefixes[index].length();
        this.currentPos = startOffset + startLength;
        char c;
        while (this.isOctalDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private boolean isDecimalStart(int offset) {
        char c;
        return this.language.usesIntegers() && this.isDecimalDigit(c = this.textBuffer.getChar(offset));
    }

    private void skipDecimal(int startOffset) {
        this.skipDecimalDigits(startOffset);
        char c = this.textBuffer.getChar(this.currentPos);
        if (this.language.usesFloats()) {
            if (c == '.') {
                this.lastToken = 16;
                this.skipFloat(this.currentPos);
            } else {
                int index = this.isExponentStart(this.currentPos);
                if (index != -1) {
                    this.lastToken = 16;
                    this.skipExponent(this.currentPos, index);
                }
            }
        }
    }

    private void skipDecimalDigits(int startOffset) {
        char c;
        while (this.isDecimalDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private boolean isDecimalPointStart(int offset) {
        if (this.language.usesFloats()) {
            int index = this.getMatchingPattern(offset, FLOAT_PATTERNS);
            return index != -1;
        }
        return false;
    }

    private int isExponentStart(int offset) {
        if (this.language.usesFloats()) {
            return this.getMatchingPattern(offset, EXPONENT_PATTERNS);
        }
        return -1;
    }

    private void skipFloat(int startOffset) {
        this.skipDecimalDigits(startOffset);
        char c = this.textBuffer.getChar(this.currentPos);
        if (c == '.') {
            ++this.currentPos;
        }
        this.skipDecimalDigits(this.currentPos);
        int index = this.isExponentStart(this.currentPos);
        if (index != -1) {
            this.skipExponent(this.currentPos, index);
        }
    }

    private void skipExponent(int startOffset, int index) {
        int startLength = EXPONENT_PATTERNS[index].length();
        this.currentPos += startLength;
        this.skipDecimalDigits(this.currentPos);
    }

    private int getMatchingPattern(int offset, String[] patterns) {
        if (patterns == null || patterns.length == 0) {
            return -1;
        }
        int numPatterns = patterns.length;
        int i = 0;
        while (i < numPatterns) {
            if (this.matchPattern(offset, patterns[i]) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int matchPattern(int offset, String pattern) {
        if (pattern == null || pattern.length() == 0) {
            return -1;
        }
        int patternLength = pattern.length();
        int patternOffset = 0;
        while (patternOffset < patternLength) {
            char p_c;
            char tb_c;
            if ((tb_c = this.textBuffer.getChar(offset++)) == (p_c = pattern.charAt(patternOffset++))) continue;
            return -1;
        }
        return patternLength;
    }

    private boolean isOctalDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return true;
            }
        }
        return false;
    }

    private boolean isDecimalDigit(char c) {
        switch (c) {
            case '8': 
            case '9': {
                return true;
            }
        }
        return this.isOctalDigit(c);
    }

    private boolean isHexDigit(char c) {
        switch (c) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return this.isDecimalDigit(c);
    }

    protected int fillLexerToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int token) {
        switch (token) {
            case 10: {
                return "TK_KEYWORD";
            }
            case 11: {
                return "TK_IDENTIFIER";
            }
            case 12: {
                return "TK_SINGLE_COMMENT";
            }
            case 13: {
                return "TK_MULTI_COMMENT";
            }
            case 14: {
                return "TK_QUOTES";
            }
            case 15: {
                return "TK_INTEGER";
            }
            case 16: {
                return "TK_FLOAT";
            }
            case 17: {
                return "TK_OPEN_BRACE";
            }
            case 18: {
                return "TK_CLOSE_BRACE";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int token) {
        switch (token) {
            case 10: {
                return "keyword";
            }
            case 11: {
                return "identifier";
            }
            case 12: {
                return "single-line comment";
            }
            case 13: {
                return "multi-line comment";
            }
            case 14: {
                return "quote literal";
            }
            case 15: {
                return "integer";
            }
            case 16: {
                return "float";
            }
            case 17: {
                return "open brace";
            }
            case 18: {
                return "close brace";
            }
        }
        return "**UNKNOWN**";
    }
}

