/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.logging;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import oracle.ide.Version;
import oracle.javatools.logging.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Diagnostics {
    private static final int BANNER_WIDTH = 79;
    private static final char BANNER_CHAR = '-';
    private static File diagnosticDirectory = new File(System.getProperty("user.home"), "oracleide-diagnostics");
    private static final Collection<File> lockedFiles = new ArrayList<File>();
    private static boolean installedShutdownHook = false;

    private Diagnostics() {
    }

    public static File getDiagnosticDirectory() {
        return diagnosticDirectory;
    }

    public static void setDiagnosticDirectory(File diagnosticDirectory) {
        if (!diagnosticDirectory.isDirectory() && !diagnosticDirectory.mkdirs()) {
            throw new IllegalArgumentException("Cannot create " + diagnosticDirectory);
        }
        Diagnostics.unlockFiles(Arrays.asList(diagnosticDirectory.listFiles()));
        Diagnostics.diagnosticDirectory = diagnosticDirectory;
    }

    public static boolean isLockedFile(File file) {
        String fileName = file.getName();
        return fileName.endsWith(".locked") || fileName.endsWith(".lck");
    }

    public static synchronized File newLockedFile(String prefix) {
        File file = Diagnostics.newFile(prefix);
        file = new File(file.getPath() + ".locked");
        lockedFiles.add(file);
        Diagnostics.installShutdownHook();
        return file;
    }

    private static void installShutdownHook() {
        if (installedShutdownHook) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new 1());
    }

    private static void unlockFiles(Collection<File> files) {
        for (File file : files) {
            if (!file.getName().endsWith(".locked")) continue;
            file.renameTo(new File(file.getPath().substring(0, file.getPath().length() - ".locked".length())));
        }
    }

    public static File newFile(String prefix, String suffix) {
        File file;
        diagnosticDirectory.mkdirs();
        if (!diagnosticDirectory.canWrite()) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        name.append(Version.NAME_SHORT.toUpperCase());
        if (Diagnostics.nonEmpty(prefix)) {
            name.append("-" + prefix + "-");
        }
        Calendar calendar = Calendar.getInstance();
        name.append(calendar.get(1));
        name.append(Diagnostics.stringOf(calendar.get(2) + 1, 2));
        name.append(Diagnostics.stringOf(calendar.get(5), 2));
        name.append('-');
        name.append(Diagnostics.stringOf(calendar.get(11), 2));
        name.append(Diagnostics.stringOf(calendar.get(12), 2));
        name.append(Diagnostics.stringOf(calendar.get(13), 2));
        if (Diagnostics.nonEmpty(suffix)) {
            name.append("-" + suffix);
        }
        if ((file = new File(diagnosticDirectory, name + ".txt")).exists() && !file.canWrite()) {
            return null;
        }
        return file;
    }

    public static File newFile(String prefix) {
        return Diagnostics.newFile(prefix, null);
    }

    public static void writeBanner(Writer w, String bannerText) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(w);
            writer.println(Diagnostics.repeat('-', 79));
            writer.print(Diagnostics.repeat('-', 2));
            writer.print(" ");
            writer.println(bannerText);
            writer.println(Diagnostics.repeat('-', 79));
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }

    public static void writeSystemConfiguration(Writer w) throws IOException {
        w.append(Configuration.systemProperties());
    }

    private static String repeat(char c, int num) {
        StringBuilder sb = new StringBuilder(num);
        int i = 0;
        while (i < num) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private static String stringOf(int value, int width) {
        String string = String.valueOf(value);
        StringBuilder buffer = new StringBuilder();
        int i = string.length();
        while (i < width) {
            buffer.append('0');
            ++i;
        }
        buffer.append(string);
        return buffer.toString();
    }

    private static boolean nonEmpty(String s) {
        return s != null && s.length() > 0;
    }

    static Collection ra$lockedFiles() {
        return lockedFiles;
    }

    static void maS$unlockFiles(Collection collection) {
        Diagnostics.unlockFiles(collection);
    }

    static final class 1
    extends Thread {
        public void run() {
            Diagnostics.maS$unlockFiles(Diagnostics.ra$lockedFiles());
        }
    }
}

