/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AuditedWriteList<T>
implements List<T> {
    private final List<T> delegate;
    private Throwable lastModification;

    AuditedWriteList(List<T> delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void audit() {
        AuditedWriteList auditedWriteList = this;
        synchronized (auditedWriteList) {
            this.lastModification = new Throwable("List modified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLastModificationAsCause(Throwable t) {
        AuditedWriteList auditedWriteList = this;
        synchronized (auditedWriteList) {
            if (this.lastModification != null) {
                t.initCause(this.lastModification);
            }
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T> iteratorDelegate = this.delegate.iterator();
        return new 1(this, iteratorDelegate);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        this.audit();
        return this.delegate.remove(o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.audit();
        return this.delegate.addAll(index, c);
    }

    @Override
    public void clear() {
        this.audit();
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public T get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public T set(int index, T element) {
        this.audit();
        return this.delegate.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.audit();
        this.delegate.add(index, element);
    }

    @Override
    public T remove(int index) {
        this.audit();
        return this.delegate.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new AuditingListIterator<T>(this.delegate.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new AuditingListIterator<T>(this.delegate.listIterator(index));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public boolean add(T o) {
        this.audit();
        return this.delegate.add(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.audit();
        return this.delegate.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.audit();
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.audit();
        return this.delegate.retainAll(c);
    }

    public String toString() {
        return this.delegate.toString();
    }

    static void mav$initLastModificationAsCause(AuditedWriteList auditedWriteList, Throwable throwable) {
        auditedWriteList.initLastModificationAsCause(throwable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 1
    implements Iterator {
        private final /* synthetic */ Iterator v$iteratorDelegate;
        final /* synthetic */ AuditedWriteList this$0;

        @Override
        public boolean hasNext() {
            return this.v$iteratorDelegate.hasNext();
        }

        public T next() {
            try {
                Object e = this.v$iteratorDelegate.next();
                return e;
            }
            catch (ConcurrentModificationException cme) {
                AuditedWriteList.mav$initLastModificationAsCause(this.this$0, cme);
                throw cme;
            }
        }

        @Override
        public void remove() {
            try {
                this.v$iteratorDelegate.remove();
            }
            catch (ConcurrentModificationException cme) {
                AuditedWriteList.mav$initLastModificationAsCause(this.this$0, cme);
                throw cme;
            }
        }

        public 1(AuditedWriteList auditedWriteList, Iterator iterator) {
            this.v$iteratorDelegate = iterator;
            this.this$0 = auditedWriteList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuditingListIterator<T>
    implements ListIterator<T> {
        private final ListIterator<T> delegate;

        AuditingListIterator(ListIterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            try {
                T t = this.delegate.next();
                return t;
            }
            catch (ConcurrentModificationException cme) {
                AuditedWriteList.mav$initLastModificationAsCause(AuditedWriteList.this, cme);
                throw cme;
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public T previous() {
            try {
                T t = this.delegate.previous();
                return t;
            }
            catch (ConcurrentModificationException cme) {
                AuditedWriteList.mav$initLastModificationAsCause(AuditedWriteList.this, cme);
                throw cme;
            }
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            try {
                this.delegate.remove();
            }
            catch (ConcurrentModificationException cme) {
                AuditedWriteList.mav$initLastModificationAsCause(AuditedWriteList.this, cme);
                throw cme;
            }
        }

        @Override
        public void set(T o) {
            try {
                this.delegate.set(o);
            }
            catch (ConcurrentModificationException cme) {
                AuditedWriteList.mav$initLastModificationAsCause(AuditedWriteList.this, cme);
                throw cme;
            }
        }

        @Override
        public void add(T o) {
            try {
                this.delegate.add(o);
            }
            catch (ConcurrentModificationException cme) {
                AuditedWriteList.mav$initLastModificationAsCause(AuditedWriteList.this, cme);
                throw cme;
            }
        }
    }
}

