/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.sequence;

import java.util.ArrayList;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;

public class SequenceCompareAlgorithm
implements CompareAlgorithm {
    public boolean canCompare(CompareContributor first, CompareContributor second) {
        return true;
    }

    public CompareModel compare(CompareContributor first, CompareContributor second) throws CompareFailedException {
        SequenceCompareContributor one = (SequenceCompareContributor)first;
        SequenceCompareContributor two = (SequenceCompareContributor)second;
        SequenceCompareDifference[] diffs = this.getDifferences(one, two);
        if (diffs == null) {
            diffs = new SequenceCompareDifference[]{new SequenceCompareDifference(2)};
            diffs[0].setFirstStart(0);
            diffs[0].setFirstLength(one.getLength());
            diffs[0].setSecondStart(0);
            diffs[0].setSecondLength(two.getLength());
        }
        return new SequenceCompareModel(one, two, diffs);
    }

    private void dumpBlocks(SequenceCompareDifference[] blocks) {
        int i = 0;
        while (i < blocks.length) {
            SequenceCompareDifference thisBlock = blocks[i];
            System.err.println(i + ": " + thisBlock.getKind() + " (" + thisBlock._firstStart + ", " + thisBlock._firstLength + " ) => (" + thisBlock._secondStart + ", " + thisBlock._secondLength + " )");
            ++i;
        }
    }

    protected SequenceCompareDifference[] getDifferences(SequenceCompareContributor first, SequenceCompareContributor second) {
        int upper;
        int secondLen = second.getLength();
        int firstLen = first.getLength();
        if (firstLen == secondLen && secondLen == 1) {
            if (!first.equal(0, second, 0)) {
                SequenceCompareDifference[] diffs = new SequenceCompareDifference[]{new SequenceCompareDifference(2)};
                diffs[0].setFirstStart(0);
                diffs[0].setFirstLength(1);
                diffs[0].setSecondStart(0);
                diffs[0].setSecondLength(1);
                return diffs;
            }
            return new SequenceCompareDifference[0];
        }
        int dLength = 2 * Math.max(secondLen, firstLen);
        int origin = dLength / 2;
        int[] last_d = new int[dLength + 1];
        LinkedDifferenceBlock[] differences = new LinkedDifferenceBlock[dLength + 1];
        int row = 0;
        while (row < secondLen && row < firstLen && this.equal(second, row, first, row)) {
            ++row;
        }
        last_d[origin] = row;
        differences[origin] = null;
        int lower = row == secondLen ? origin + 1 : origin - 1;
        int n = upper = row == firstLen ? origin - 1 : origin + 1;
        if (lower > upper) {
            return new SequenceCompareDifference[0];
        }
        int d = 1;
        while (d < dLength) {
            int k = lower;
            while (k <= upper) {
                LinkedDifferenceBlock difference;
                if (k == origin - d || k != origin + d && last_d[k + 1] >= last_d[k - 1]) {
                    row = last_d[k + 1] + 1;
                    difference = new LinkedDifferenceBlock(differences[k + 1], 1);
                } else {
                    row = last_d[k - 1];
                    difference = new LinkedDifferenceBlock(differences[k - 1], 0);
                }
                int column = row + k - origin;
                difference.setLeftStart(column);
                difference.setRightStart(row);
                differences[k] = difference;
                while (row < secondLen && column < firstLen && this.equal(second, row, first, column)) {
                    ++row;
                    ++column;
                }
                last_d[k] = row;
                if (row == secondLen && column == firstLen) {
                    return this.coalesceDiffs(differences[k]);
                }
                if (row == secondLen) {
                    lower = k + 2;
                }
                if (column == firstLen) {
                    upper = k - 2;
                }
                k += 2;
            }
            --lower;
            ++upper;
            ++d;
        }
        return null;
    }

    private void dumpBlocks(LinkedDifferenceBlock start) {
        do {
            System.err.print(start.getKind() == 0 ? "INS: (" : "DEL: (");
            System.err.print(LinkedDifferenceBlock.ra$_firstStart(start) + ", " + LinkedDifferenceBlock.ra$_secondStart(start));
            System.err.println(")");
        } while ((start = LinkedDifferenceBlock.ra$_next(start)) != null);
    }

    private SequenceCompareDifference[] coalesceDiffs(LinkedDifferenceBlock start) {
        LinkedDifferenceBlock linkedBlock = this.reverse(start);
        ArrayList<SequenceCompareDifference> result = new ArrayList<SequenceCompareDifference>();
        SequenceCompareDifference diffBlock = null;
        while (linkedBlock != null) {
            diffBlock = new SequenceCompareDifference(2);
            if (LinkedDifferenceBlock.ra$_kind(linkedBlock) == 0) {
                diffBlock._secondStart = LinkedDifferenceBlock.ra$_secondStart(linkedBlock) + 1;
                diffBlock._firstStart = LinkedDifferenceBlock.ra$_firstStart(linkedBlock);
                LinkedDifferenceBlock b = linkedBlock;
                do {
                    linkedBlock = linkedBlock.getNext();
                    ++diffBlock._firstLength;
                } while (linkedBlock != null && LinkedDifferenceBlock.ra$_kind(linkedBlock) == 0 && LinkedDifferenceBlock.ra$_secondStart(linkedBlock) == LinkedDifferenceBlock.ra$_secondStart(b));
            } else {
                boolean isChange;
                diffBlock._secondStart = LinkedDifferenceBlock.ra$_secondStart(linkedBlock);
                diffBlock._firstStart = LinkedDifferenceBlock.ra$_firstStart(linkedBlock);
                LinkedDifferenceBlock a = linkedBlock;
                do {
                    a = linkedBlock;
                    linkedBlock = linkedBlock.getNext();
                    ++diffBlock._secondLength;
                } while (linkedBlock != null && LinkedDifferenceBlock.ra$_kind(linkedBlock) == 1 && LinkedDifferenceBlock.ra$_secondStart(linkedBlock) == LinkedDifferenceBlock.ra$_secondStart(a) + 1);
                boolean bl = isChange = linkedBlock != null && LinkedDifferenceBlock.ra$_kind(linkedBlock) == 0 && LinkedDifferenceBlock.ra$_secondStart(linkedBlock) == LinkedDifferenceBlock.ra$_secondStart(a);
                if (isChange) {
                    LinkedDifferenceBlock b = linkedBlock;
                    do {
                        linkedBlock = linkedBlock.getNext();
                        ++diffBlock._firstLength;
                    } while (linkedBlock != null && LinkedDifferenceBlock.ra$_kind(linkedBlock) == 0 && LinkedDifferenceBlock.ra$_secondStart(linkedBlock) == LinkedDifferenceBlock.ra$_secondStart(b));
                } else {
                    diffBlock._firstLength = 0;
                }
                ++diffBlock._firstStart;
            }
            --diffBlock._secondStart;
            --diffBlock._firstStart;
            result.add(diffBlock);
        }
        return result.toArray(new SequenceCompareDifference[0]);
    }

    private LinkedDifferenceBlock reverse(LinkedDifferenceBlock block) {
        LinkedDifferenceBlock ahead = block;
        LinkedDifferenceBlock current = null;
        while (ahead != null) {
            LinkedDifferenceBlock behind = current;
            current = ahead;
            ahead = ahead.getNext();
            current.setNext(behind);
        }
        return current;
    }

    private boolean equal(SequenceCompareContributor first, int index, SequenceCompareContributor second, int index2) {
        return first.equal(index, second, index2);
    }

    private class LinkedDifferenceBlock {
        public static final int INSERT = 0;
        public static final int DELETE = 1;
        private LinkedDifferenceBlock _next;
        private int _kind;
        private int _firstStart;
        private int _secondStart;

        LinkedDifferenceBlock() {
        }

        LinkedDifferenceBlock(LinkedDifferenceBlock next, int kind) {
            this._kind = kind;
            this._next = next;
        }

        int getKind() {
            return this._kind;
        }

        void setKind(int kind) {
            this._kind = kind;
        }

        void setLeftStart(int leftStart) {
            this._firstStart = leftStart;
        }

        void setRightStart(int rightStart) {
            this._secondStart = rightStart;
        }

        LinkedDifferenceBlock getNext() {
            return this._next;
        }

        void setNext(LinkedDifferenceBlock block) {
            this._next = block;
        }

        static int ra$_kind(LinkedDifferenceBlock linkedDifferenceBlock) {
            return linkedDifferenceBlock._kind;
        }

        static int ra$_secondStart(LinkedDifferenceBlock linkedDifferenceBlock) {
            return linkedDifferenceBlock._secondStart;
        }

        static int ra$_firstStart(LinkedDifferenceBlock linkedDifferenceBlock) {
            return linkedDifferenceBlock._firstStart;
        }

        static LinkedDifferenceBlock ra$_next(LinkedDifferenceBlock linkedDifferenceBlock) {
            return linkedDifferenceBlock._next;
        }
    }
}

