/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.directory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Observable;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;

public class DirectoryList
extends Observable {
    private final ArrayList _files;
    private Object _clearState;

    private void $init$() {
        this._files = new ArrayList();
        this._clearState = null;
        this.clearModified();
    }

    public DirectoryFile getFile(int index) {
        return (DirectoryFile)this._files.get(index);
    }

    public int getSize() {
        return this._files.size();
    }

    public void appendFile(DirectoryFile file) {
        int i = this.binarySearch(file);
        if (i >= 0) {
            throw new IllegalStateException();
        }
        this._files.add(Math.abs(i + 1), file);
        this.clearModified();
    }

    public void insertFile(int index, DirectoryFile file) {
        this._files.add(index, file);
        this.setChanged();
    }

    public DirectoryFile removeFile(int index) {
        DirectoryFile file = (DirectoryFile)this._files.remove(index);
        this.setChanged();
        return file;
    }

    public void clearModified() {
        boolean wasModified = this.isModified();
        this._clearState = this.getState();
        if (wasModified) {
            this.setChanged();
        }
    }

    public boolean isModified() {
        return this._clearState != null && !this._clearState.equals(this.getState());
    }

    void sort() {
        Collections.sort(this._files);
    }

    DirectoryFile[] getFiles() {
        return this._files.toArray(new DirectoryFile[0]);
    }

    int indexOf(DirectoryFile file) {
        return this._files.indexOf(file);
    }

    int binarySearch(DirectoryFile file) {
        return Collections.binarySearch(this._files, file);
    }

    private Object getState() {
        ArrayList<String> ids = new ArrayList<String>();
        int i = 0;
        while (i < this.getSize()) {
            ids.add(this.getFile(i).toString());
            ++i;
        }
        Collections.sort(ids);
        return ids;
    }

    public DirectoryList() {
        this.$init$();
    }
}

