/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareMergeAlgorithm;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.algorithm.directory.DirectoryCompareAlgorithm;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareAlgorithm;
import oracle.javatools.compare.algorithm.text.TextCompareAlgorithm;

public final class CompareModelFactory {
    private static final Map<CompareType, Class> _algorithms = new HashMap<CompareType, Class>();

    private CompareModelFactory() {
    }

    static {
        CompareModelFactory.registerCompareAlgorithm(CompareType.TEXT, TextCompareAlgorithm.class);
        CompareModelFactory.registerCompareAlgorithm(CompareType.CHARACTER, SequenceCompareAlgorithm.class);
        CompareModelFactory.registerCompareAlgorithm(CompareType.DIRECTORY, DirectoryCompareAlgorithm.class);
    }

    public static final void registerAlgorithm(CompareAlgorithm compareAlgorithm) {
    }

    public static final void registerCompareAlgorithm(CompareType type, Class algorithmClass) {
        _algorithms.put(type, algorithmClass);
    }

    public static CompareModel createCompareModel(CompareContributor first, CompareContributor second) throws CompareFailedException {
        return CompareModelFactory.createCompareModel(first, second, CompareType.TEXT);
    }

    public static CompareModel createMergeModel(CompareContributor first, CompareContributor second, CompareContributor ancestor) throws CompareFailedException {
        return CompareModelFactory.createMergeModel(first, second, ancestor, CompareType.TEXT);
    }

    public static CompareModel createCompareModel(CompareContributor first, CompareContributor second, CompareType type) throws CompareFailedException {
        CompareAlgorithm compareAlgorithm = CompareModelFactory.createCompareAlgorithm(type);
        if (compareAlgorithm != null) {
            CompareModel compareModel = compareAlgorithm.compare(first, second);
            if (compareModel != null) {
                compareModel.setType(type);
            }
            return compareModel;
        }
        throw new IllegalArgumentException("cannot create compare model with " + first + " and " + second);
    }

    public static CompareModel createMergeModel(CompareContributor first, CompareContributor second, CompareContributor ancestor, CompareType type) throws CompareFailedException {
        CompareAlgorithm compareAlgorithm = CompareModelFactory.createCompareAlgorithm(type);
        if (compareAlgorithm instanceof CompareMergeAlgorithm) {
            CompareModel compareModel = ((CompareMergeAlgorithm)compareAlgorithm).merge(first, second, ancestor);
            if (compareModel != null) {
                compareModel.setType(type);
            }
            return compareModel;
        }
        throw new IllegalArgumentException("cannot create merge model with " + first + " and " + second);
    }

    public static CompareAlgorithm createCompareAlgorithm(CompareType type) {
        CompareAlgorithm compareAlgorithm = null;
        Class algorithmClass = _algorithms.get(type);
        try {
            if (algorithmClass != null) {
                compareAlgorithm = (CompareAlgorithm)algorithmClass.newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return compareAlgorithm;
    }
}

